/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.properties;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.maven.ui.properties.ModuleDependencyController;
import org.mule.tooling.model.project.MuleExtension;
import org.mule.tooling.ui.properties.DependencyController;
import org.mule.tooling.ui.properties.DependencyNameLabelProvider;
import org.mule.tooling.ui.properties.DependencyVersionLabelProvider;
import org.mule.tooling.ui.properties.IDependency;
import org.mule.tooling.ui.properties.MuleDependenciesView;
import org.mule.tooling.utils.collection.ListView;

public class MuleModuleDependenciesView
extends MuleDependenciesView {
    public MuleModuleDependenciesView(DependencyController<?> dependencyController, Composite parent) {
        super(dependencyController, parent);
    }

    protected void addColumns() {
        this.getDependenciesTable().addColumn("Name", 200, dependency -> dependency.getName(), (dependency, value) -> {}, dependency -> Collections.emptySet(), (CellLabelProvider)new DependencyNameLabelProvider());
        this.getDependenciesTable().addColumn("Version", 80, dependency -> dependency.getVersion(), (dependency, value) -> dependency.setVersion(value), dependency -> dependency.getAvailableVersions(), (CellLabelProvider)new DependencyVersionLabelProvider());
    }

    protected void contributeAddItems() {
        super.contributeAddItems();
        this.getDependenciesTable().contributeAddItem("from Featured Modules", () -> {
            IMuleProject muleProject = ((ModuleDependencyController)this.getDependencyController()).getMuleProject();
            List declaredExtensions = muleProject.getDeclaredExtensions();
            List moduleDependencies = declaredExtensions.stream().map(e -> MavenUtils.getDependency((MuleExtension)e)).collect(Collectors.toList());
            List modifiedInput = this.getDependenciesTable().getModifiedInput().stream().map(IDependency::getDependency).collect(Collectors.toList());
            ((ModuleDependencyController)this.dependencyController).addFeaturedModule(ListView.of(moduleDependencies, modifiedInput));
        }, 1);
    }
}

