/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.properties;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.m2.dependency.MavenCoordinates;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.module.FeaturedModulesTracker;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.maven.ui.properties.ModuleDependency;
import org.mule.tooling.ui.editors.FeaturedModulesDialog;
import org.mule.tooling.ui.project.MavenDependencyPickerDialog;
import org.mule.tooling.ui.properties.DependencyController;
import org.mule.tooling.ui.properties.IDependency;
import org.mule.tooling.ui.properties.IDependencyManager;
import org.mule.tooling.ui.properties.ModuleDependencyManager;
import org.mule.tooling.ui.properties.ModuleWizardMode;
import org.mule.tooling.ui.properties.dependencies.AddDependencyWizardDialog;
import org.mule.tooling.ui.properties.dependencies.DependencyUtils;
import org.mule.tooling.ui.properties.dependencies.WizardDependencyMode;

public class ModuleDependencyController
extends DependencyController<ModuleDependencyManager> {
    private IMuleProject muleProject;

    public ModuleDependencyController(IMuleProject muleProject, ModuleDependencyManager dependencyManager) {
        super((IDependencyManager)dependencyManager);
        this.muleProject = muleProject;
    }

    public void searchInExchange() {
        AddDependencyWizardDialog dialog = AddDependencyWizardDialog.create((Shell)Display.getCurrent().getActiveShell(), (WizardDependencyMode)new ModuleWizardMode(this.dependencyManager));
        if (dialog.open() == 0) {
            List result = dialog.getResult();
            AnalyticsRecordsFactory.single((String)Events.ADD_MODULE_FROM_PALETTE_CONFIGURATION_WINDOW, (IMuleProject)this.muleProject).withModuleProperty(result).track();
            this.dependenciesAdded(result.stream().map(module -> new ModuleDependency((ExternalContributionMuleModule)module, DependencyUtils.getOriginalScope((IMuleProject)this.muleProject, (ExternalContributionMuleModule)module))).collect(Collectors.toList()));
        }
    }

    public void addMavenDependency() {
        MavenDependency dependency;
        IDependencyManager.Result resolveDependency;
        MavenDependencyPickerDialog dialog = new MavenDependencyPickerDialog(Display.getCurrent().getActiveShell());
        dialog.setDefaultClassifier("mule-plugin");
        dialog.setDefaultArtifact("module");
        if (dialog.open() == 0 && !(resolveDependency = ((ModuleDependencyManager)this.dependencyManager).resolveDependency(dependency = dialog.getDependency())).isFailure()) {
            ExternalContributionMuleModule module = (ExternalContributionMuleModule)resolveDependency.getResult().get();
            AnalyticsRecordsFactory.single((String)Events.ADD_MAVEN_DEPENDENCY_WIZARD, (IMuleProject)this.muleProject).withModuleProperty(Arrays.asList(module)).track();
            this.dependencyAdded(new ModuleDependency(module, DependencyUtils.getOriginalScope((IMuleProject)this.muleProject, (ExternalContributionMuleModule)module)));
        }
    }

    public void addFeaturedModule(List<MavenDependency> projectDependencies) {
        IServerDefinition serverDefinition = this.muleProject.getServerDefinition();
        if (FeaturedModulesTracker.instance().isLoaded(serverDefinition.getId())) {
            List workspaceModules = MuleCorePlugin.getModuleContributionManager().getModulesFrom(serverDefinition);
            FeaturedModulesDialog featuredDialog = new FeaturedModulesDialog(Display.getCurrent().getActiveShell());
            List<String> dependencyGA = projectDependencies.stream().map(dependency -> MavenUtils.getGA((MavenDependency)dependency).toLowerCase()).collect(Collectors.toList());
            HashMap modules = new HashMap();
            workspaceModules.forEach(em -> {
                ExternalContributionMuleModule otherEM;
                String ga = MavenUtils.getGA((MavenCoordinates)em.getCoordinates());
                if (modules.containsKey(ga) && new ComparableVersion((otherEM = (ExternalContributionMuleModule)modules.get(ga)).getVersion()).compareTo(new ComparableVersion(em.getVersion())) < 0) {
                    return;
                }
                modules.put(ga, em);
            });
            dependencyGA.forEach(modules::remove);
            List input = modules.values().stream().sorted((dep1, dep2) -> dep1.getName().compareTo(dep2.getName())).collect(Collectors.toList());
            featuredDialog.setInput(input);
            featuredDialog.open(() -> {
                List selectedModules = featuredDialog.getSelectedModules();
                AnalyticsRecordsFactory.single((String)Events.ADD_MODULE_FROM_FEATURED_MODULES, (IMuleProject)this.muleProject).withModuleProperty(selectedModules).track();
                this.dependenciesAdded(selectedModules.stream().map(module -> new ModuleDependency((ExternalContributionMuleModule)module, DependencyUtils.getOriginalScope((IMuleProject)this.muleProject, (ExternalContributionMuleModule)module))).collect(Collectors.toList()));
            });
        } else {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Add from Featured Modules", (String)"Featured modules are being initialized.");
        }
    }

    public List<IDependency> getDependencies() {
        List externalModules = ((ModuleDependencyManager)this.dependencyManager).getDependencies();
        Map moduleToAvailableVersions = MuleCorePlugin.getModuleContributionManager().getAvailableVersions(externalModules, this.muleProject.getServerDefinition());
        List<IDependency> input = externalModules.stream().map(module -> new ModuleDependency((ExternalContributionMuleModule)module, DependencyUtils.getOriginalScope((IMuleProject)this.muleProject, (ExternalContributionMuleModule)module))).collect(Collectors.toList());
        for (IDependency module2 : input) {
            String ga = MavenUtils.getGA((MavenDependency)module2.getDependency());
            for (ExternalContributionMuleModule moduleVersion : (Set)moduleToAvailableVersions.get(ga)) {
                ((ModuleDependency)module2).addAvailableVersion(moduleVersion);
            }
        }
        return input;
    }

    public IMuleProject getMuleProject() {
        return this.muleProject;
    }
}

