/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.properties;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.tooling.core.auth.PlatformUrls;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.dependency.PojoMavenDependencyBuilder;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.exchange.ExchangeAssetAttributesInfo;
import org.mule.tooling.ui.properties.IDependency;
import org.mule.tooling.ui.properties.IExchangeAsset;

public class ModuleDependency
implements IDependency,
IExchangeAsset {
    private String version;
    private Set<String> versions = Sets.newHashSet();
    private String name;
    private String organization;
    private Optional<String> classifier;
    private Map<String, String> versionsToDescriptionMap = new HashMap<String, String>();
    private String artifactId;
    private String originalVersion;
    private MavenDependency.Scope scope;

    public ModuleDependency(ExternalContributionMuleModule module, MavenDependency.Scope scope) {
        String[] gav = module.getId().split(":");
        this.name = module.getName();
        this.originalVersion = this.version = module.getVersion();
        this.organization = gav[0];
        this.artifactId = gav[1];
        this.classifier = Optional.ofNullable("mule-plugin");
        this.versionsToDescriptionMap.put(this.version, module.getDescription());
        this.scope = scope;
    }

    public void addAvailableVersion(ExternalContributionMuleModule module) {
        this.addAvailableVersion(module.getVersion(), module.getDescription());
    }

    public void addAvailableVersion(String version, String description) {
        this.versionsToDescriptionMap.put(version, description);
        this.versions.add(version);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.versionsToDescriptionMap.get(this.version);
    }

    public String getVersion() {
        return this.version;
    }

    public Set<String> getAvailableVersions() {
        return this.versions;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return this.getName();
    }

    public String getGroupId() {
        return this.organization;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getClassifier() {
        return this.classifier.get();
    }

    public String getOrganizationId() {
        return this.organization;
    }

    public MavenDependency getDependency() {
        return ((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)PojoMavenDependencyBuilder.newInstance().withGroupId(this.getGroupId())).withArtifactId(this.getArtifactId())).withVersion(this.getVersion())).withClassifier(this.getClassifier())).withType("jar")).withScope(this.getScope())).build();
    }

    public String getOriginalVersion() {
        return this.originalVersion;
    }

    public void setOriginalVersion(String version) {
        this.originalVersion = version;
    }

    public String getLink() {
        return PlatformUrls.getExchangeAssetUrl((String)this.getGroupId(), (String)this.getArtifactId(), Optional.ofNullable(this.getVersion()));
    }

    public Optional<ExchangeAssetAttributesInfo> getExchangeAssetAttributesInfo() {
        return Optional.empty();
    }

    public void setExchangeAssetAttributesInfo(ExchangeAssetAttributesInfo info) {
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isSnapshot() {
        return this.version.toLowerCase().endsWith("-snapshot");
    }

    public MavenDependency.Scope getScope() {
        return this.scope;
    }
}

