/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.properties;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.maven.ui.properties.DataWeaveDependency;
import org.mule.tooling.ui.project.MavenDependencyPickerDialog;
import org.mule.tooling.ui.properties.DataWeaveWizardMode;
import org.mule.tooling.ui.properties.DependencyController;
import org.mule.tooling.ui.properties.IDependency;
import org.mule.tooling.ui.properties.IDependencyManager;
import org.mule.tooling.ui.properties.dependencies.AddDependencyWizardDialog;
import org.mule.tooling.ui.properties.dependencies.WizardDependencyMode;

public class DataWeaveDependencyController
extends DependencyController<IDependencyManager<MavenDependency>> {
    private IMuleProject muleProject;

    public DataWeaveDependencyController(IMuleProject muleProject, IDependencyManager<MavenDependency> dependencyManager) {
        super(dependencyManager);
        this.muleProject = muleProject;
    }

    public void searchInExchange() {
        AddDependencyWizardDialog dialog = AddDependencyWizardDialog.create((Shell)Display.getCurrent().getActiveShell(), (WizardDependencyMode)new DataWeaveWizardMode(this.dependencyManager));
        if (dialog.open() == 0) {
            List dependencies = dialog.getResult();
            dependencies.forEach(resolvedDependency -> this.sendMetric((MavenDependency)resolvedDependency, "Exchange"));
            dependencies.forEach(resolveDependency -> this.dependencyAdded(new DataWeaveDependency((MavenDependency)resolveDependency)));
        }
    }

    private void sendMetric(MavenDependency dependency, String source) {
        AnalyticsRecordsFactory.single((String)Events.ADDED_DW_LIBRARY).withDependencyProperty(Arrays.asList(dependency)).addMetadata("source", source).addMetadata("dependency", dependency.asString()).track();
    }

    public void addMavenDependency() {
        MavenDependency dependency;
        IDependencyManager.Result resolveDependency;
        MavenDependencyPickerDialog dialog = new MavenDependencyPickerDialog(Display.getCurrent().getActiveShell());
        dialog.setDefaultClassifier("mule-plugin");
        dialog.setDefaultArtifact("mule-plugin");
        if (dialog.open() == 0 && !(resolveDependency = this.dependencyManager.resolveDependency(dependency = dialog.getDependency())).isFailure()) {
            MavenDependency resolvedDependency = (MavenDependency)resolveDependency.getResult().get();
            this.dependencyAdded(new DataWeaveDependency(resolvedDependency));
            this.sendMetric(resolvedDependency, "Maven");
        }
    }

    public List<IDependency> getDependencies() {
        return this.dependencyManager.getDependencies().stream().map(d -> new DataWeaveDependency((MavenDependency)d)).collect(Collectors.toList());
    }

    public IMuleProject getMuleProject() {
        return this.muleProject;
    }
}

