/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.properties;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.tooling.core.auth.PlatformUrls;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.dependency.PojoMavenDependencyBuilder;
import org.mule.tooling.exchange.ExchangeAsset;
import org.mule.tooling.exchange.ExchangeAssetAttributesInfo;
import org.mule.tooling.ui.properties.IDependency;
import org.mule.tooling.ui.properties.IExchangeAsset;

public class DataWeaveDependency
implements IDependency,
IExchangeAsset {
    private String version;
    private String originalVersion;
    private Map<String, String> versions = new HashMap<String, String>();
    private Optional<String> name;
    private String organization;
    private Optional<String> classifier = Optional.empty();
    private Optional<ExchangeAssetAttributesInfo> exchangeAssetAttributesInfo = Optional.empty();
    private boolean snapshot;
    private String artifactId;
    private MavenDependency.Scope scope;

    public DataWeaveDependency(ExchangeAsset exchangeAsset) {
        this.artifactId = exchangeAsset.getArtifactId();
        this.name = Optional.ofNullable(exchangeAsset.getName());
        this.originalVersion = this.version = exchangeAsset.getVersion();
        this.organization = exchangeAsset.getGroupId();
        this.classifier = Optional.ofNullable(exchangeAsset.getClassifier());
        this.snapshot = exchangeAsset.isSnapshot();
        String description = exchangeAsset.getDescription();
        this.versions.put(this.version, description == null ? "" : description);
        this.exchangeAssetAttributesInfo = Optional.ofNullable(exchangeAsset.getExchangeAssetAttributesInfo());
    }

    public DataWeaveDependency(MavenDependency maven) {
        this.artifactId = maven.getArtifactId();
        this.name = Optional.empty();
        this.originalVersion = this.version = maven.getVersion();
        this.organization = maven.getGroupId();
        this.classifier = maven.getClassifier();
        this.snapshot = maven.isSnapshot();
        this.scope = Optional.ofNullable(maven.getScope()).orElse(MavenDependency.Scope.COMPILE);
    }

    public String getName() {
        return this.name.orElse(this.artifactId);
    }

    public String getDescription() {
        return this.versions.containsKey(this.version) ? this.versions.get(this.version) : "";
    }

    public String getVersion() {
        return this.version;
    }

    public Set<String> getAvailableVersions() {
        return this.versions.keySet();
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return this.getName();
    }

    public String getGroupId() {
        return this.organization;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getClassifier() {
        return this.classifier.orElse("raml");
    }

    public String getOrganizationId() {
        return this.organization;
    }

    public MavenDependency getDependency() {
        return ((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)PojoMavenDependencyBuilder.newInstance().withGroupId(this.getGroupId())).withArtifactId(this.getArtifactId())).withVersion(this.getVersion())).withClassifier(this.getClassifier())).withType("jar")).build();
    }

    public String getOriginalVersion() {
        return this.originalVersion;
    }

    public void setOriginalVersion(String version) {
        this.originalVersion = version;
    }

    public void addAvailableVersion(String version, String description) {
        this.versions.put(version, description);
    }

    public String getLink() {
        return PlatformUrls.getExchangeAssetUrl((String)this.getGroupId(), (String)this.getArtifactId(), Optional.ofNullable(this.version));
    }

    public Optional<ExchangeAssetAttributesInfo> getExchangeAssetAttributesInfo() {
        return this.exchangeAssetAttributesInfo;
    }

    public void setExchangeAssetAttributesInfo(ExchangeAssetAttributesInfo info) {
        this.exchangeAssetAttributesInfo = Optional.ofNullable(info);
    }

    public void setName(String name) {
        this.name = Optional.of(name);
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public MavenDependency.Scope getScope() {
        return this.scope;
    }
}

