/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.preferences;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.maven.runner.SyncGetResultCallback;
import org.mule.tooling.maven.ui.MavenImages;
import org.mule.tooling.maven.ui.actions.MavenInstallationTester;
import org.mule.tooling.ui.utils.UiUtils;

public class TestMavenComponent {
    private static final String BUTTON_TEXT = "Test Maven Configuration";
    private static final String MAVEN_OUTPUT_TOOLTIP = "< hit the Test Maven Configuration button and check the results here >";
    private static final Point STATUS_LABEL_HINT = new Point(16, 16);
    private String mavenHome;
    private Button testMavenButton;
    private Label statusLabel;
    private Text mavenOutputText;
    private boolean visibleByDefault;
    private boolean embedded;

    public TestMavenComponent(Composite parent, Point span, boolean visibleByDefault) {
        this.visibleByDefault = visibleByDefault;
        Composite parentComposite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(2).equalWidth(false).applyTo(parentComposite);
        GridDataFactory.fillDefaults().span(span).grab(true, true).applyTo((Control)parentComposite);
        this.createTestMavenButton(parentComposite);
        this.statusLabel = new Label(parentComposite, 0);
        GridDataFactory.swtDefaults().align(1, 4).hint(STATUS_LABEL_HINT).applyTo((Control)this.statusLabel);
        this.createMavenOutputText(parentComposite);
    }

    public TestMavenComponent(Composite parent, Point span) {
        this(parent, span, false);
    }

    private void createTestMavenButton(Composite composite) {
        this.testMavenButton = new Button(composite, 0);
        this.testMavenButton.setText(BUTTON_TEXT);
        this.testMavenButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestMavenComponent.this.testMaven();
            }
        });
        GridDataFactory.swtDefaults().applyTo((Control)this.testMavenButton);
    }

    private void createMavenOutputText(Composite composite) {
        this.mavenOutputText = new Text(composite, 2120);
        this.mavenOutputText.setEditable(false);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).align(4, 4).applyTo((Control)this.mavenOutputText);
        this.mavenOutputText.setVisible(this.visibleByDefault);
        if (this.visibleByDefault) {
            UiUtils.addGrayedTooltipWhenEmpty((Text)this.mavenOutputText, (String)MAVEN_OUTPUT_TOOLTIP);
        }
    }

    protected void testMaven() {
        this.statusLabel.setImage(MavenImages.BUSY);
        this.emptyDisplayEventsQueue();
        final MavenInstallationTester mavenInstallationTester = new MavenInstallationTester(this.embedded, this.mavenHome);
        mavenInstallationTester.test(new SyncGetResultCallback(){

            public void finished(final int result) {
                super.finished(result);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TestMavenComponent.this.onTestFinished(mavenInstallationTester, result);
                    }
                });
            }
        });
    }

    void onTestFinished(MavenInstallationTester mavenInstallationTester, int result) {
        Image statusImage = result == 0 ? MavenImages.OK_IMAGE : MavenImages.NOT_OK_IMAGE;
        this.statusLabel.setImage(statusImage);
        this.mavenOutputText.setText(mavenInstallationTester.getOutput());
        this.mavenOutputText.setVisible(true);
    }

    private void emptyDisplayEventsQueue() {
        Display currentDisplay = Display.getCurrent();
        Display display = currentDisplay == null ? Display.getDefault() : currentDisplay;
        int fuse = 100;
        while (display.readAndDispatch() && --fuse > 0) {
        }
        display.sleep();
    }

    public void setMavenHome(boolean embedded, String mavenHome) {
        this.embedded = embedded;
        this.mavenHome = mavenHome;
    }

    public void setEnabled(boolean enabled) {
        this.testMavenButton.setEnabled(enabled);
        if (!enabled) {
            this.mavenOutputText.setVisible(this.visibleByDefault);
            this.mavenOutputText.setText("");
            this.statusLabel.setImage(null);
        }
    }
}

