/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.preferences;

import java.io.File;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.core.m2.MavenConfiguration;
import org.mule.tooling.maven.ui.preferences.ObservableFileFieldEditor;

public class SettingsFieldValidator {
    private static final String EMPTY_SETTINGS_FILE = "Maven Settings file path cannot be empty";
    private static final String INVALID_SETTINGS_FILE = "Selected file is not a valid Maven Settings";

    private SettingsFieldValidator() {
    }

    public static boolean validateSettingsField(ObservableFileFieldEditor fieldEditor, Text textControl) {
        String text = textControl.getText();
        if (textControl.isEnabled()) {
            if (!text.isEmpty()) {
                boolean validMavenSettings = MavenConfiguration.instance().getSettings(new File(text)) != null;
                fieldEditor.setErrorMessage(validMavenSettings ? null : INVALID_SETTINGS_FILE);
                return validMavenSettings;
            }
            fieldEditor.setErrorMessage(EMPTY_SETTINGS_FILE);
            return false;
        }
        fieldEditor.setErrorMessage(null);
        return true;
    }
}

