/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.preferences;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.settings.Server;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.m2.internal.settings.MavenSettingsHelper;
import org.mule.tooling.maven.ui.MavenUIPlugin;
import org.mule.tooling.maven.ui.preferences.FieldEditorListener;
import org.mule.tooling.maven.ui.preferences.ObservableBooleanFieldEditor;
import org.mule.tooling.maven.ui.preferences.ObservableFileFieldEditor;
import org.mule.tooling.maven.ui.preferences.ServerSettingsDialog;
import org.mule.tooling.maven.ui.preferences.SettingsFieldValidator;
import org.mule.tooling.ui.authentication.widgets.SWTFactory;
import org.xml.sax.SAXException;

public abstract class ServersSettingsPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
FieldEditorListener {
    private static final String REMOVE_SERVER_CONFIRM_MESSAGE = "Are you sure to remove {0} from your settings.xml file?";
    private MavenSettingsHelper serverSettingsHelper;
    protected IPreferenceStore preferenceStore;
    private File selectedFile;
    private List<Server> servers = new ArrayList<Server>();
    private Table serversTable;
    protected TableViewer serversTableViewer;
    protected boolean overrideCheckbox;
    protected String overrideCheckboxId;
    protected String settingsFilePath;
    protected String settingsFilePathId;
    protected Button removeButton;
    protected Button editButton;
    protected Button addButton;
    private String pageIntro = "";
    private ObservableFileFieldEditor mavenSettingsPathEditor;
    private String overrideLabel;
    private String settingsFilePathLabel;

    public ServersSettingsPage(String pageIntro, String overrideCheckboxId, String overrideLabel, String settingsFilePathId, String settingsFilePathLabel) {
        super(1);
        this.pageIntro = pageIntro;
        this.overrideCheckboxId = overrideCheckboxId;
        this.overrideLabel = overrideLabel;
        this.settingsFilePathId = settingsFilePathId;
        this.settingsFilePathLabel = settingsFilePathLabel;
    }

    public void init(IWorkbench arg0) {
        this.preferenceStore = MavenUIPlugin.getDefault().getPreferenceStore();
        this.setPreferenceStore(this.preferenceStore);
        this.initPreferenceListeners(this.preferenceStore);
        this.setDescription(this.pageIntro);
    }

    protected void initialize() {
        super.initialize();
        this.overrideCheckbox = this.preferenceStore.getBoolean(this.overrideCheckboxId);
        this.settingsFilePath = this.preferenceStore.getString(this.settingsFilePathId);
        this.mavenSettingsPathEditor.setEnabled(this.overrideCheckbox, this.getFieldEditorParent());
        this.getAndShowServers();
    }

    @Override
    public void valueChanged(String preference, Object arg) {
        if (preference.equals(this.overrideCheckboxId)) {
            this.overrideCheckbox = (Boolean)arg;
            this.mavenSettingsPathEditor.setEnabled(this.overrideCheckbox, this.getFieldEditorParent());
            this.serversTable.removeAll();
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.getAndShowServers();
        } else if (preference.equals(this.settingsFilePathId)) {
            this.settingsFilePath = (String)arg;
            if (StringUtils.isBlank((String)this.settingsFilePath) && !this.overrideCheckbox) {
                this.getDefaultFile().ifPresent(file -> {
                    String string = this.settingsFilePath = file.getAbsolutePath();
                });
                this.getAndShowServers();
                this.settingsFilePath = "";
            } else {
                this.getAndShowServers();
            }
        }
        this.checkState();
    }

    protected void createFieldEditors() {
        String[] extensions = new String[]{"*.xml"};
        ObservableBooleanFieldEditor overrideSettingsEditor = new ObservableBooleanFieldEditor(this.overrideCheckboxId, this.overrideLabel, this.getFieldEditorParent(), this);
        this.mavenSettingsPathEditor = new ObservableFileFieldEditor(this.settingsFilePathId, this.settingsFilePathLabel, this.getFieldEditorParent(), SettingsFieldValidator::validateSettingsField, this);
        this.mavenSettingsPathEditor.setFileExtensions(extensions);
        this.addField((FieldEditor)overrideSettingsEditor);
        this.addField((FieldEditor)this.mavenSettingsPathEditor);
        this.createTable(this.getFieldEditorParent());
        this.createButtonColumn(this.getFieldEditorParent());
        this.getAndShowServers();
    }

    private void createTable(Composite parent) {
        Composite tableContent = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)2, (int)0, (int)0);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)tableContent);
        this.serversTableViewer = new TableViewer(tableContent, 68098);
        this.serversTableViewer.addSelectionChangedListener(event -> {
            int selectedElements = this.serversTable.getSelection().length;
            boolean selectionNotEmpty = selectedElements > 0;
            boolean oneSelected = selectedElements == 1;
            boolean canEdit = this.calculateEditButtonsEnabled(this.overrideCheckbox);
            this.removeButton.setEnabled(selectionNotEmpty && canEdit);
            this.editButton.setEnabled(oneSelected && canEdit);
        });
        this.serversTable = this.serversTableViewer.getTable();
        this.serversTable.setHeaderVisible(true);
        this.serversTable.setLinesVisible(true);
        this.createTableViewerColumn("Server id", new ColumnLabelProvider(){

            public String getText(Object element) {
                Server p = (Server)element;
                return p.getId();
            }
        });
        this.createTableViewerColumn("User name", new ColumnLabelProvider(){

            public String getText(Object element) {
                Server p = (Server)element;
                return p.getUsername();
            }
        });
        this.serversTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.serversTableViewer.setInput(this.servers);
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, 390).applyTo((Control)this.serversTable);
    }

    private void createButtonColumn(Composite parent) {
        Composite buttonsColumn = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)2, (int)0, (int)0);
        GridDataFactory.fillDefaults().grab(false, false).span(1, 1).applyTo((Control)buttonsColumn);
        this.addButton = this.createButton("Add", buttonsColumn, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServersSettingsPage.this.addServer();
            }
        });
        this.addButton.setEnabled(true);
        this.editButton = this.createButton("Edit", buttonsColumn, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServersSettingsPage.this.editServer();
            }
        });
        this.editButton.setEnabled(false);
        this.removeButton = this.createButton("Remove", buttonsColumn, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServersSettingsPage.this.removeServer();
            }
        });
        this.removeButton.setEnabled(false);
    }

    private Button createButton(String name, Composite parent, SelectionListener listener) {
        Button button = new Button(parent, 1);
        button.setText(name);
        button.addSelectionListener(listener);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)button);
        return button;
    }

    private void addServer() {
        ServerSettingsDialog window = new ServerSettingsDialog(Display.getDefault().getActiveShell(), "Add server", this.servers);
        if (window.open() == 0) {
            Server newServer = this.createServer(window);
            this.servers.add(newServer);
            this.serversTableViewer.refresh();
            this.serverSettingsHelper.addServer(window.getId(), window.getUsername(), window.getPassword());
        }
    }

    private void editServer() {
        Server selectedServer = (Server)this.serversTable.getSelection()[0].getData();
        ServerSettingsDialog window = new ServerSettingsDialog(Display.getDefault().getActiveShell(), "Edit server", this.servers);
        window.setServer(selectedServer);
        if (window.open() == 0) {
            Server newServer = this.createServer(window);
            int indexOld = this.servers.indexOf(selectedServer);
            this.servers.remove(indexOld);
            this.servers.add(indexOld, newServer);
            this.serversTableViewer.refresh();
            this.serverSettingsHelper.editServer(selectedServer.getId(), newServer);
        }
    }

    private Server createServer(ServerSettingsDialog window) {
        Server newServer = new Server();
        newServer.setId(window.getId());
        newServer.setUsername(window.getUsername());
        newServer.setPassword(window.getPassword());
        return newServer;
    }

    private void removeServer() {
        TableItem[] selectedServers = this.serversTable.getSelection();
        Boolean delete = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Confirm deletion", (String)MessageFormat.format(REMOVE_SERVER_CONFIRM_MESSAGE, selectedServers.length == 1 ? "this server" : "these servers"));
        if (delete.booleanValue()) {
            TableItem[] tableItemArray = selectedServers;
            int n = selectedServers.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem server = tableItemArray[n2];
                this.serverSettingsHelper.removeServer(server.getText(0));
                this.servers.remove(server.getData());
                ++n2;
            }
            this.serversTableViewer.refresh();
        }
    }

    protected void getAndShowServers() {
        try {
            this.getServersFromFile();
        }
        catch (IOException | SAXException e) {
            MuleCorePlugin.logError((String)("Unexpected error while retrieving servers from settings file in: " + this.settingsFilePath + "."), (Throwable)e);
        }
        this.serversTableViewer.refresh();
    }

    private void getServersFromFile() throws SAXException, IOException {
        Optional<File> file = this.getSelectedSettingsFile();
        this.servers.clear();
        if (file.isPresent()) {
            this.selectedFile = file.get();
            this.serverSettingsHelper = new MavenSettingsHelper(this.selectedFile);
            for (Server server : this.serverSettingsHelper.getServers()) {
                this.servers.add(server);
            }
        }
    }

    protected Optional<File> getSelectedSettingsFile() {
        if (this.overrideCheckbox) {
            return this.getSettingsFileFromPath();
        }
        return this.getDefaultFile();
    }

    private void createTableViewerColumn(String title, ColumnLabelProvider columnProvider) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.serversTableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(200);
        viewerColumn.setLabelProvider((CellLabelProvider)columnProvider);
    }

    public Optional<File> getSettingsFileFromPath() {
        File settingsFile = new File(this.settingsFilePath);
        return settingsFile.exists() ? Optional.of(settingsFile) : Optional.empty();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.initialize();
        }
        super.setVisible(visible);
    }

    public boolean performOk() {
        if (this.selectedFile.canWrite()) {
            try {
                this.serverSettingsHelper.write(this.selectedFile);
            }
            catch (IOException e) {
                MuleCorePlugin.logError((String)e.getMessage(), (Throwable)e);
            }
        }
        super.performOk();
        return true;
    }

    abstract Optional<File> getDefaultFile();

    abstract boolean calculateEditButtonsEnabled(boolean var1);

    abstract void initPreferenceListeners(IPreferenceStore var1);
}

