/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.preferences;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.settings.Server;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ServerSettingsDialog
extends Dialog {
    private static final String PASSWORD_LABEL = "Password";
    private static final String USERNAME_LABEL = "Username";
    private static final String ID_LABEL = "Id";
    private static final String ERROR_DIALOG_TITLE = "Invalid Input";
    private static final int WIDTH_HINT = 400;
    private String title;
    private Text txtId;
    private Text txtUsername;
    private Text txtPassword;
    private String id = "";
    private String username = "";
    private String password = "";
    private List<Server> servers;

    protected ServerSettingsDialog(Shell parentShell, String title, List<Server> servers) {
        super(parentShell);
        this.title = title;
        this.servers = servers;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(400, -1).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).spacing(5, 10).applyTo(container);
        this.txtId = this.createLabel(container, ID_LABEL, 2048);
        this.txtUsername = this.createLabel(container, USERNAME_LABEL, 2048);
        this.txtPassword = this.createLabel(container, PASSWORD_LABEL, 0x400800);
        this.txtId.setText(this.id);
        this.txtUsername.setText(this.username);
        this.txtPassword.setText(this.password);
        return container;
    }

    private Text createLabel(Composite container, String name, int style) {
        Label lbl = new Label(container, 0);
        lbl.setText(name);
        Text newField = new Text(container, style);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)newField);
        return newField;
    }

    private void saveInput() {
        this.id = this.txtId.getText();
        this.username = this.txtUsername.getText();
        this.password = this.txtPassword.getText();
    }

    private boolean existServer(String serverId) {
        for (Server server : this.servers) {
            if (!serverId.equals(server.getId())) continue;
            return true;
        }
        return false;
    }

    protected void okPressed() {
        Boolean allFieldsAreConfigured = StringUtils.isNotBlank((String)this.txtId.getText()) && StringUtils.isNotBlank((String)this.txtUsername.getText()) && StringUtils.isNotBlank((String)this.txtPassword.getText());
        if (allFieldsAreConfigured.booleanValue()) {
            if (this.id.equals(this.txtId.getText()) || !this.existServer(this.txtId.getText())) {
                this.saveInput();
                super.okPressed();
            } else {
                MessageDialog.openError((Shell)this.getShell(), (String)ERROR_DIALOG_TITLE, (String)("Server Id '" + this.txtId.getText() + "' already exist."));
            }
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)ERROR_DIALOG_TITLE, (String)"All fields are required.");
        }
    }

    public String getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setServer(Server server) {
        this.id = server.getId();
        this.username = server.getUsername();
        this.password = server.getPassword();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }
}

