/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.preferences;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.mule.tooling.maven.ui.MavenUIPlugin;
import org.mule.tooling.utils.exception.IllegalCreationException;

public class NotificationsPreferences {
    public static final String ID = "org.mule.tooling.ui.notifications";
    public static final String ENABLE_MULE_MODULES_UPDATES_NOTIFICATIONS = "studio.mule.modules.updates.notifications.enabled";
    public static final String ENABLE_MULE_MODULES_UPDATES_CHECK_AT_STARTUP = "studio.mule.modules.updates.check.at.startup.enabled";
    public static final String ENABLE_MULE_MODULES_UPDATES_CHECK_AFTER_TIME_ELAPSED = "studio.mule.modules.updates.check.after.time.elapsed.enabled";
    public static final String DELAY_BETWEEN_CHECKS = "studio.mule.modules.updates.notifications.delay.between.checks";
    public static final String LAST_CHECK_FOR_UPDATES = "studio.mule.modules.updates.notifications.last.check";
    public static final String UPDATES_DIALOG_SORT_BY = "studio.mule.modules.updates.dialog.sort.by";
    public static final String ORDER_BY_PROJECT = "byProject";
    public static final String ORDER_BY_MODULE = "byModule";

    private NotificationsPreferences() {
        throw new IllegalCreationException();
    }

    public static boolean areNotificationsEnabled() {
        return MavenUIPlugin.getDefault().getPreferenceStore().getBoolean(ENABLE_MULE_MODULES_UPDATES_NOTIFICATIONS);
    }

    public static boolean isCheckAtStartupEnabled() {
        return MavenUIPlugin.getDefault().getPreferenceStore().getBoolean(ENABLE_MULE_MODULES_UPDATES_CHECK_AT_STARTUP);
    }

    public static boolean isCheckAfterTimeElapsedEnabled() {
        return MavenUIPlugin.getDefault().getPreferenceStore().getBoolean(ENABLE_MULE_MODULES_UPDATES_CHECK_AFTER_TIME_ELAPSED);
    }

    public static int daysUntilNextCheckForUpdates() {
        return MavenUIPlugin.getDefault().getPreferenceStore().getInt(DELAY_BETWEEN_CHECKS);
    }

    public static String dateOfLastCheckForUpdates() {
        return MavenUIPlugin.getDefault().getPreferenceStore().getString(LAST_CHECK_FOR_UPDATES);
    }

    public static void updateDateOfLastCheckForUpdates() {
        MavenUIPlugin.getDefault().getPreferenceStore().setValue(LAST_CHECK_FOR_UPDATES, LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss")));
    }

    public static String getUpdatesDialogSortBy() {
        return MavenUIPlugin.getDefault().getPreferenceStore().getString(UPDATES_DIALOG_SORT_BY);
    }

    public static void openPreferencePage(Shell parentShell) {
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)parentShell, (String)ID, (String[])new String[]{ID}, null, (int)1);
        dialog.setBlockOnOpen(true);
        dialog.open();
    }
}

