/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.preferences;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.utils.JobUtils;
import org.mule.tooling.maven.ui.MavenUIPlugin;
import org.mule.tooling.maven.ui.command.MuleDependenciesUpdatesChecker;
import org.mule.tooling.maven.ui.preferences.NotificationsPreferences;
import org.mule.tooling.maven.ui.utils.MavenUiUtils;

public class NotificationsPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private Composite muleModulesUpdatesTriggersComposite;
    private Composite muleModulesUpdatesDelayComposite;
    private BooleanFieldEditor muleModulesUpdatesNotificationsEnabled;
    private BooleanFieldEditor muleModulesUpdatesCheckAtStartupEnabled;
    private BooleanFieldEditor muleModulesUpdatesCheckAfterTimeElapsedEnabled;
    private IntegerFieldEditor muleModulesUpdatesDelayBetweenChecks;
    private StringFieldEditor muleModulesUpdatesLastCheck;

    public NotificationsPreferencePage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(MavenUIPlugin.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        this.createMuleModulesUpdatesGroup();
    }

    protected void initialize() {
        super.initialize();
        this.enableOrDisableUpdatesNotificationsPreferences();
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getProperty().equals("field_editor_value") && (event.getSource().equals(this.muleModulesUpdatesNotificationsEnabled) || event.getSource().equals(this.muleModulesUpdatesCheckAfterTimeElapsedEnabled))) {
            this.enableOrDisableUpdatesNotificationsPreferences();
        }
    }

    private void createMuleModulesUpdatesGroup() {
        Group muleModulesUpdatesGroup = new Group(this.getFieldEditorParent(), 32);
        muleModulesUpdatesGroup.setText("Mule Modules Updates");
        GridDataFactory.swtDefaults().align(4, 1).grab(true, false).span(2, 1).applyTo((Control)muleModulesUpdatesGroup);
        this.muleModulesUpdatesNotificationsEnabled = new BooleanFieldEditor("studio.mule.modules.updates.notifications.enabled", "Enable notifications", (Composite)muleModulesUpdatesGroup);
        this.addField((FieldEditor)this.muleModulesUpdatesNotificationsEnabled);
        this.createTriggersPreferences(muleModulesUpdatesGroup);
        this.createLastCheckDate(muleModulesUpdatesGroup);
        this.createSortByPreference(muleModulesUpdatesGroup);
        GridLayoutFactory.fillDefaults().margins(5, 5).numColumns(2).generateLayout((Composite)muleModulesUpdatesGroup);
    }

    private void createTriggersPreferences(Group parentGroup) {
        this.muleModulesUpdatesTriggersComposite = new Composite((Composite)parentGroup, 0);
        GridDataFactory.swtDefaults().align(4, 1).grab(true, false).span(2, 1).indent(15, 0).applyTo((Control)this.muleModulesUpdatesTriggersComposite);
        this.muleModulesUpdatesCheckAtStartupEnabled = new BooleanFieldEditor("studio.mule.modules.updates.check.at.startup.enabled", "Check for updates at startup", this.muleModulesUpdatesTriggersComposite);
        this.addField((FieldEditor)this.muleModulesUpdatesCheckAtStartupEnabled);
        this.muleModulesUpdatesCheckAfterTimeElapsedEnabled = new BooleanFieldEditor("studio.mule.modules.updates.check.after.time.elapsed.enabled", "Check for updates after time elapsed", this.muleModulesUpdatesTriggersComposite);
        this.addField((FieldEditor)this.muleModulesUpdatesCheckAfterTimeElapsedEnabled);
        this.muleModulesUpdatesDelayComposite = new Composite(this.muleModulesUpdatesTriggersComposite, 0);
        GridDataFactory.swtDefaults().align(4, 1).grab(true, false).span(2, 1).indent(30, 0).applyTo((Control)this.muleModulesUpdatesDelayComposite);
        this.muleModulesUpdatesDelayBetweenChecks = new IntegerFieldEditor("studio.mule.modules.updates.notifications.delay.between.checks", "Time between checks for updates (1-30 days)", this.muleModulesUpdatesDelayComposite);
        this.muleModulesUpdatesDelayBetweenChecks.setValidRange(1, 30);
        this.addField((FieldEditor)this.muleModulesUpdatesDelayBetweenChecks);
    }

    private void createLastCheckDate(Group parentGroup) {
        this.muleModulesUpdatesLastCheck = new StringFieldEditor("studio.mule.modules.updates.notifications.last.check", "Latest check", (Composite)parentGroup);
        this.muleModulesUpdatesLastCheck.getTextControl((Composite)parentGroup).setEnabled(false);
        this.addField((FieldEditor)this.muleModulesUpdatesLastCheck);
    }

    private void createSortByPreference(Group parentGroup) {
        RadioGroupFieldEditor muleModulesUpdatesDialogSortBy = new RadioGroupFieldEditor("studio.mule.modules.updates.dialog.sort.by", "Order the Manage Modules dialog by", 2, (String[][])new String[][]{{"Projects", "byProject"}, {"Modules", "byModule"}}, (Composite)parentGroup, true);
        this.addField((FieldEditor)muleModulesUpdatesDialogSortBy);
    }

    private void enableOrDisableUpdatesNotificationsPreferences() {
        this.muleModulesUpdatesCheckAtStartupEnabled.setEnabled(this.muleModulesUpdatesNotificationsEnabled.getBooleanValue(), this.muleModulesUpdatesTriggersComposite);
        this.muleModulesUpdatesCheckAfterTimeElapsedEnabled.setEnabled(this.muleModulesUpdatesNotificationsEnabled.getBooleanValue(), this.muleModulesUpdatesTriggersComposite);
        this.muleModulesUpdatesDelayBetweenChecks.setEnabled(this.muleModulesUpdatesNotificationsEnabled.getBooleanValue() && this.muleModulesUpdatesCheckAfterTimeElapsedEnabled.getBooleanValue(), this.muleModulesUpdatesDelayComposite);
    }

    private boolean shouldCheckAfterTimeElapsed() {
        return this.muleModulesUpdatesNotificationsEnabled.getBooleanValue() && this.muleModulesUpdatesCheckAfterTimeElapsedEnabled.getBooleanValue();
    }

    public boolean performOk() {
        this.reviewPeriodicJobState();
        if (this.triggersChanged()) {
            AnalyticsRecordsFactory.single((String)Events.MULE_MODULES_UPDATES_NOTIFICATION_TRIGGERS_ENABLED).addMetadata("enabledTriggers", this.determineState()).track();
        }
        return super.performOk();
    }

    private void reviewPeriodicJobState() {
        boolean oldNotificationsEnabled = NotificationsPreferences.areNotificationsEnabled();
        boolean newNotificationsEnabled = this.muleModulesUpdatesNotificationsEnabled.getBooleanValue();
        boolean oldCheckAfterDelayEnabled = NotificationsPreferences.isCheckAfterTimeElapsedEnabled();
        boolean newCheckAfterDelayEnabled = this.muleModulesUpdatesCheckAfterTimeElapsedEnabled.getBooleanValue();
        int oldDelay = NotificationsPreferences.daysUntilNextCheckForUpdates();
        int newDelay = this.muleModulesUpdatesDelayBetweenChecks.getIntValue();
        if (oldNotificationsEnabled != newNotificationsEnabled) {
            if (this.shouldCheckAfterTimeElapsed()) {
                new MuleDependenciesUpdatesChecker().schedule(MavenUiUtils.computeDelay(newDelay));
            } else {
                JobUtils.cancelJob((String)"Periodic Mule Modules updates check");
            }
        } else if (oldCheckAfterDelayEnabled != newCheckAfterDelayEnabled) {
            if (this.shouldCheckAfterTimeElapsed()) {
                new MuleDependenciesUpdatesChecker().schedule(MavenUiUtils.computeDelay(newDelay));
            } else {
                JobUtils.cancelJob((String)"Periodic Mule Modules updates check");
            }
        } else if (oldDelay != newDelay && this.shouldCheckAfterTimeElapsed()) {
            JobUtils.rescheduleJob((String)"Periodic Mule Modules updates check", (long)MavenUiUtils.computeDelay(newDelay));
        }
    }

    private boolean triggersChanged() {
        boolean oldNotificationsEnabled = NotificationsPreferences.areNotificationsEnabled();
        boolean newNotificationsEnabled = this.muleModulesUpdatesNotificationsEnabled.getBooleanValue();
        boolean oldCheckAtStartupEnabled = NotificationsPreferences.isCheckAtStartupEnabled();
        boolean newCheckAtStartupEnabled = this.muleModulesUpdatesCheckAtStartupEnabled.getBooleanValue();
        boolean oldCheckAfterDelayEnabled = NotificationsPreferences.isCheckAfterTimeElapsedEnabled();
        boolean newCheckAfterDelayEnabled = this.muleModulesUpdatesCheckAfterTimeElapsedEnabled.getBooleanValue();
        if (oldNotificationsEnabled != newNotificationsEnabled) {
            return newNotificationsEnabled ? newCheckAtStartupEnabled || newCheckAfterDelayEnabled : oldCheckAtStartupEnabled || oldCheckAfterDelayEnabled;
        }
        if (newNotificationsEnabled) {
            return oldCheckAtStartupEnabled != newCheckAtStartupEnabled || oldCheckAfterDelayEnabled != newCheckAfterDelayEnabled;
        }
        return false;
    }

    private String determineState() {
        boolean notificationsEnabled = this.muleModulesUpdatesNotificationsEnabled.getBooleanValue();
        boolean checkAtStartupEnabled = this.muleModulesUpdatesCheckAtStartupEnabled.getBooleanValue();
        boolean checkAfterDelayEnabled = this.muleModulesUpdatesCheckAfterTimeElapsedEnabled.getBooleanValue();
        if (notificationsEnabled) {
            if (checkAtStartupEnabled && checkAfterDelayEnabled) {
                return "all-enabled";
            }
            if (checkAtStartupEnabled) {
                return "only-at-startup-enabled";
            }
            if (checkAfterDelayEnabled) {
                return "only-after-time-elapsed-enabled";
            }
        }
        return "all-disabled";
    }

    protected void performDefaults() {
        String lastCheckValue = this.muleModulesUpdatesLastCheck.getStringValue();
        super.performDefaults();
        this.muleModulesUpdatesLastCheck.setStringValue(lastCheckValue);
    }
}

