/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.preferences;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.mule.tooling.maven.runner.MavenBinarySearcher;
import org.mule.tooling.maven.ui.preferences.DefaultBuildCommandLineExtension;
import org.mule.tooling.ui.preferences.MuleStudioPreferencePage;

public class MavenPreferencesInitializer
extends AbstractPreferenceInitializer {
    private static final String DEFAULT_GROUPID = "com.mycompany";
    private static final String ENV_VARIABLE_M2_HOME = "M2_HOME";
    private static final String ENV_VARIABLE_M2 = "M2";

    public void initializeDefaultPreferences() {
        IEclipsePreferences preferenceStore = DefaultScope.INSTANCE.getNode("org.mule.tooling.core");
        String defaultMavenHome = this.getDefaultMavenInstallationHome();
        String string = defaultMavenHome = defaultMavenHome == null ? "" : defaultMavenHome;
        if (preferenceStore.get("mule_core_plugin_preference_maven_embedded", null) == null) {
            preferenceStore.putBoolean("mule_core_plugin_preference_maven_embedded", true);
        }
        if (preferenceStore.get("mule_core_plugin_preference_maven_path", null) == null) {
            preferenceStore.put("mule_core_plugin_preference_maven_path", defaultMavenHome);
        }
        if (preferenceStore.get("mule_core_plugin_preference_dont_warn_no_installation_found", null) == null) {
            preferenceStore.putBoolean("mule_core_plugin_preference_dont_warn_no_installation_found", false);
        }
        if (preferenceStore.get("mule_core_plugin_preference_maven_base_cmdline", null) == null) {
            preferenceStore.put("mule_core_plugin_preference_maven_base_cmdline", this.getDefaultBuildCommandLine());
        }
        if (preferenceStore.get("mule_core_plugin_preference_maven_default_groupid", null) == null) {
            preferenceStore.put("mule_core_plugin_preference_maven_default_groupid", DEFAULT_GROUPID);
        }
        if (preferenceStore.get("mule_core_plugin_preference_maven_runtime_version_warning", null) == null) {
            preferenceStore.putBoolean("mule_core_plugin_preference_maven_runtime_version_warning", true);
        }
        if (preferenceStore.get("mule_core_plugin_preference_maven_default_releases_policy", null) == null) {
            preferenceStore.put("mule_core_plugin_preference_maven_default_releases_policy", "always");
        }
        if (preferenceStore.get("mule_core_plugin_preference_maven_default_snapshots_policy", null) == null) {
            preferenceStore.put("mule_core_plugin_preference_maven_default_snapshots_policy", "never");
        }
        if (preferenceStore.get("mule_core_plugin_preference_install_external_dependencies", null) == null) {
            preferenceStore.put("mule_core_plugin_preference_install_external_dependencies", MuleStudioPreferencePage.ActionDialogState.PROMPT.name());
        }
    }

    private String getDefaultBuildCommandLine() {
        StringBuilder defaultCommandLine = new StringBuilder("mvn clean package");
        List<DefaultBuildCommandLineExtension> extensions = DefaultBuildCommandLineExtension.getExtensions();
        for (DefaultBuildCommandLineExtension extension : extensions) {
            defaultCommandLine.append(" ").append(extension.getCommandLineExtension());
        }
        return defaultCommandLine.toString();
    }

    public String getDefaultMavenInstallationHome() {
        String mavenHome = null;
        Map<String, String> environment = System.getenv();
        String m2homeVariable = environment.get(ENV_VARIABLE_M2_HOME);
        String m2variable = environment.get(ENV_VARIABLE_M2);
        if (m2homeVariable != null && new File(m2homeVariable).exists()) {
            mavenHome = new File(m2homeVariable).getAbsolutePath();
        } else if (m2variable != null && new File(m2variable).exists()) {
            mavenHome = new File(m2variable).getParent();
        } else {
            MavenBinarySearcher searcher = MavenBinarySearcher.newInstance();
            if (searcher != null) {
                mavenHome = searcher.search();
            }
        }
        return mavenHome;
    }
}

