/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.mule.tooling.maven.runner.MavenRunnerConfiguration;

public class MavenPreferences
implements MavenRunnerConfiguration {
    private final IPreferenceStore preferenceStore;

    private MavenPreferences(IPreferenceStore preferenceStore) {
        this.preferenceStore = preferenceStore;
    }

    public static MavenPreferences newInstance(IPreferenceStore preferenceStore) {
        return new MavenPreferences(preferenceStore);
    }

    public boolean isDontWarnAgainIfNoInstallationFoundChecked() {
        return this.preferenceStore.getBoolean("mule_core_plugin_preference_dont_warn_no_installation_found");
    }

    public boolean isGlobalMavenSupportEnabled() {
        return true;
    }

    public String getMavenInstallationHome() {
        return this.preferenceStore.getString("mule_core_plugin_preference_maven_path");
    }

    public void setMavenInstallationHome(String mavenHome) {
        this.preferenceStore.setValue("mule_core_plugin_preference_maven_path", mavenHome);
    }

    public String getMavenOpts() {
        return this.preferenceStore.getString("mule_core_plugin_preference_maven_opts");
    }

    public String getDefaultGroupId() {
        return this.preferenceStore.getString("mule_core_plugin_preference_maven_default_groupid");
    }

    public String getBaseCommandline() {
        return this.preferenceStore.getString("mule_core_plugin_preference_maven_base_cmdline").trim();
    }

    public void setDisplayRuntimeVersionWarning(boolean toggleState) {
        this.preferenceStore.setValue("mule_core_plugin_preference_maven_runtime_version_warning", toggleState);
    }

    public boolean isDisplayRuntimeVersionWarning() {
        return this.preferenceStore.getBoolean("mule_core_plugin_preference_maven_runtime_version_warning");
    }

    public void setDisplayInstallExternalDependencies(String value) {
        this.preferenceStore.setValue("mule_core_plugin_preference_install_external_dependencies", value);
    }

    public String getDisplayInstallExternalDependencies() {
        return this.preferenceStore.getString("mule_core_plugin_preference_install_external_dependencies");
    }

    public boolean isExternalInstallation() {
        return !this.preferenceStore.getBoolean("mule_core_plugin_preference_maven_embedded");
    }

    public String getMavenLocalRepository() {
        return this.preferenceStore.getString("mule_core_plugin_preference_maven_override_m2_repo_path");
    }

    public String toString() {
        return "MavenPreferences [isDontWarnAgainIfNoInstallationFoundChecked()=" + this.isDontWarnAgainIfNoInstallationFoundChecked() + ", isGlobalMavenSupportEnabled()=" + this.isGlobalMavenSupportEnabled() + ", getMavenInstallationHome()=" + this.getMavenInstallationHome() + ", getMavenOpts()=" + this.getMavenOpts() + ", getDefaultGroupId()=" + this.getDefaultGroupId() + ", getBaseCommandline()=" + this.getBaseCommandline() + ", isDisplayRuntimeVersionWarning()=" + this.isDisplayRuntimeVersionWarning() + ", isExternalInstallation()=" + this.isExternalInstallation() + "]";
    }
}

