/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.preferences;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.mule.tooling.maven.ui.MavenConstants;
import org.mule.tooling.maven.ui.MavenUIPlugin;
import org.mule.tooling.maven.ui.preferences.FieldEditorListener;
import org.mule.tooling.maven.ui.preferences.ObservableBooleanFieldEditor;
import org.mule.tooling.maven.ui.preferences.ObservableDirectoryFieldEditor;
import org.mule.tooling.maven.ui.preferences.ObservableFileFieldEditor;
import org.mule.tooling.maven.ui.preferences.TestMavenComponent;
import org.mule.tooling.ui.preferences.MuleStudioPreferencePage;
import org.mule.tooling.utils.Pair;

public class MavenPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
FieldEditorListener {
    private static final String APPLY_THE_CHANGES_MESSAGE = "This page contains unsaved modifications. Do you want to apply the changes so that other related pages can be updated?";
    private static final String MAVEN_PREFERENCES = "Maven Preferences";
    private static final String LOCAL_REPOSITORY_ERROR_MESSAGE = "Value must point to a valid folder";
    private static final String MAVEN_INSTALLATION_ERROR_MESSAGE = "Value must point to the root of a Maven installation";
    private static final String PAGE_TITLE = "Set the preferences for using Maven in Studio";
    private Pair<Integer, String> discardButton = new Pair((Object)0, (Object)"Discard");
    private Pair<Integer, String> applyButton = new Pair((Object)1, (Object)"Apply");
    public static final Map<String, String> LABELS = new HashMap<String, String>();
    private ObservableDirectoryFieldEditor mavenHomeFieldEditor;
    private TestMavenComponent testMavenComponent;
    private BooleanFieldEditor useEmbeddedFieldEditor;
    private DirectoryFieldEditor mavenLocalRepo;
    private ObservableBooleanFieldEditor overrideMavenLocalRepo;
    private BooleanFieldEditor overrideSettingsSecurityEditor;
    private ObservableFileFieldEditor mavenSettingsSecurityPathEditor;
    private boolean unsavedChanges;
    private RadioGroupFieldEditor useInstallExternalDependencies;

    static {
        LABELS.put("mule_core_plugin_preference_maven_embedded", "Use embedded Maven installation (Maven " + MavenConstants.MavenConstants_EmbeddedMavenVersion + ")");
        LABELS.put("mule_core_plugin_preference_maven_override_m2_repo", "Override maven local repository location");
        LABELS.put("mule_core_plugin_preference_maven_override_m2_repo_path", "Maven local repository");
        LABELS.put("mule_core_plugin_preference_maven_path", "Maven installation home directory");
        LABELS.put("mule_core_plugin_preference_maven_opts", "MAVEN_OPTS environment variable");
        LABELS.put("mule_core_plugin_preference_maven_base_cmdline", "Base command line for builds");
        LABELS.put("mule_core_plugin_preference_maven_default_groupid", "Default groupId for new projects");
        LABELS.put("mule_core_plugin_preference_maven_runtime_version_warning", "Display runtime version not available warnings");
        LABELS.put("mule_core_plugin_preference_maven_override_settings_security", "Override settings security path");
        LABELS.put("mule_core_plugin_preference_maven_override_settings_security_path", "Path to settings_security.xml");
        LABELS.put("mule_core_plugin_preference_install_external_dependencies", "When importing include project modules and third party dependencies");
    }

    public MavenPreferencePage() {
        super(1);
    }

    public void init(IWorkbench arg0) {
        this.setPreferenceStore(MavenUIPlugin.getDefault().getPreferenceStore());
        this.setDescription(PAGE_TITLE);
    }

    protected void createFieldEditors() {
        BooleanFieldEditor runtimeVersionNotAvailableEditor = new BooleanFieldEditor("mule_core_plugin_preference_maven_runtime_version_warning", LABELS.get("mule_core_plugin_preference_maven_runtime_version_warning"), this.getFieldEditorParent());
        this.useInstallExternalDependencies = new RadioGroupFieldEditor("mule_core_plugin_preference_install_external_dependencies", LABELS.get("mule_core_plugin_preference_install_external_dependencies"), 3, (String[][])new String[][]{{"Prompt", MuleStudioPreferencePage.ActionDialogState.PROMPT.name()}, {"Always", MuleStudioPreferencePage.ActionDialogState.ALWAYS.name()}, {"Never", MuleStudioPreferencePage.ActionDialogState.NEVER.name()}}, this.getFieldEditorParent(), true);
        this.useEmbeddedFieldEditor = new ObservableBooleanFieldEditor("mule_core_plugin_preference_maven_embedded", LABELS.get("mule_core_plugin_preference_maven_embedded"), this.getFieldEditorParent(), this);
        this.mavenHomeFieldEditor = new ObservableDirectoryFieldEditor("mule_core_plugin_preference_maven_path", LABELS.get("mule_core_plugin_preference_maven_path"), this.getFieldEditorParent(), this::validateMavenHome, this);
        this.mavenHomeFieldEditor.setErrorMessage(MAVEN_INSTALLATION_ERROR_MESSAGE);
        String[] extensions = new String[]{"*.xml"};
        this.overrideSettingsSecurityEditor = new ObservableBooleanFieldEditor("mule_core_plugin_preference_maven_override_settings_security", LABELS.get("mule_core_plugin_preference_maven_override_settings_security"), this.getFieldEditorParent(), this);
        this.mavenSettingsSecurityPathEditor = new ObservableFileFieldEditor("mule_core_plugin_preference_maven_override_settings_security_path", LABELS.get("mule_core_plugin_preference_maven_override_settings_security_path"), this.getFieldEditorParent(), this::validateSettingsSecurityFile, this);
        this.mavenSettingsSecurityPathEditor.setFileExtensions(extensions);
        this.overrideMavenLocalRepo = new ObservableBooleanFieldEditor("mule_core_plugin_preference_maven_override_m2_repo", LABELS.get("mule_core_plugin_preference_maven_override_m2_repo"), this.getFieldEditorParent(), this);
        this.mavenLocalRepo = new ObservableDirectoryFieldEditor("mule_core_plugin_preference_maven_override_m2_repo_path", LABELS.get("mule_core_plugin_preference_maven_override_m2_repo_path"), this.getFieldEditorParent(), this::validateLocalRepository, this);
        this.mavenLocalRepo.setErrorMessage(LOCAL_REPOSITORY_ERROR_MESSAGE);
        StringFieldEditor mavenOptsFieldEditor = new StringFieldEditor("mule_core_plugin_preference_maven_opts", LABELS.get("mule_core_plugin_preference_maven_opts"), this.getFieldEditorParent());
        StringFieldEditor defaultCmdlineFieldEditor = new StringFieldEditor("mule_core_plugin_preference_maven_base_cmdline", LABELS.get("mule_core_plugin_preference_maven_base_cmdline"), this.getFieldEditorParent());
        this.addField((FieldEditor)runtimeVersionNotAvailableEditor);
        this.addField((FieldEditor)this.useInstallExternalDependencies);
        this.addField((FieldEditor)this.useEmbeddedFieldEditor);
        this.addField((FieldEditor)this.mavenHomeFieldEditor);
        this.addField((FieldEditor)mavenOptsFieldEditor);
        this.addField((FieldEditor)this.overrideMavenLocalRepo);
        this.addField((FieldEditor)this.mavenLocalRepo);
        this.addField((FieldEditor)defaultCmdlineFieldEditor);
        this.addField((FieldEditor)this.overrideSettingsSecurityEditor);
        this.addField((FieldEditor)this.mavenSettingsSecurityPathEditor);
        this.testMavenComponent = new TestMavenComponent(this.getFieldEditorParent(), new Point(3, -1));
    }

    private boolean validateSettingsSecurityFile(ObservableFileFieldEditor fieldEditor, Text textControl) {
        return this.validateLocalPath(textControl);
    }

    private boolean validateMavenHome(ObservableDirectoryFieldEditor fieldEditor, Text textControl) {
        String text = textControl.getText();
        if (textControl.isEnabled() && !text.isEmpty()) {
            return MavenUIPlugin.getDefault().isMavenBinaryValid(text);
        }
        return true;
    }

    private boolean validateLocalRepository(ObservableDirectoryFieldEditor fieldEditor, Text textControl) {
        return this.validateLocalPath(textControl);
    }

    private boolean validateLocalPath(Text textControl) {
        String repositoryPath = textControl.getText();
        if (textControl.isEnabled()) {
            return repositoryPath.isEmpty() ? false : new File(repositoryPath).exists();
        }
        return true;
    }

    protected void initialize() {
        super.initialize();
        String mavenHome = this.getPreferenceStore().getString("mule_core_plugin_preference_maven_path");
        boolean useEmbedded = this.getPreferenceStore().getBoolean("mule_core_plugin_preference_maven_embedded");
        this.mavenHomeValueChanged(useEmbedded, mavenHome, MavenUIPlugin.getDefault().isMavenBinaryValid(mavenHome));
        this.mavenHomeFieldEditor.setEnabled(!useEmbedded, this.getFieldEditorParent());
        boolean mavenLocalRepoOverriden = this.getPreferenceStore().getBoolean("mule_core_plugin_preference_maven_override_m2_repo");
        this.mavenLocalRepo.setEnabled(mavenLocalRepoOverriden, this.getFieldEditorParent());
        this.mavenSettingsSecurityPathEditor.setEnabled(this.getPreferenceStore().getBoolean("mule_core_plugin_preference_maven_override_settings_security"), this.getFieldEditorParent());
        this.unsavedChanges = false;
    }

    public void mavenHomeValueChanged(boolean useEmbedded, String currentMavenHome, boolean isValid) {
        this.testMavenComponent.setEnabled(isValid || useEmbedded);
        this.testMavenComponent.setMavenHome(useEmbedded, isValid ? currentMavenHome : "");
    }

    public boolean performOk() {
        boolean performOk = super.performOk();
        this.unsavedChanges = false;
        String mavenHome = this.mavenHomeFieldEditor.getStringValue();
        if (!this.useEmbeddedFieldEditor.getBooleanValue() && !MavenUIPlugin.getDefault().isMavenBinaryValid(mavenHome)) {
            MavenUIPlugin.getDefault().warnUserMavenNotFound(true, mavenHome);
        }
        return performOk;
    }

    public void setVisible(boolean visible) {
        if (!visible && this.unsavedChanges) {
            this.unsavedChanges = false;
            MessageDialog dialog = new MessageDialog(this.getShell(), MAVEN_PREFERENCES, null, APPLY_THE_CHANGES_MESSAGE, 3, new String[]{(String)this.discardButton.getRight(), (String)this.applyButton.getRight()}, ((Integer)this.applyButton.getLeft()).intValue());
            if (dialog.open() == ((Integer)this.applyButton.getLeft()).intValue()) {
                this.performOk();
            } else {
                this.initialize();
            }
        }
        super.setVisible(visible);
    }

    @Override
    public void valueChanged(String preference, Object arg) {
        this.unsavedChanges = true;
        switch (preference) {
            case "mule_core_plugin_preference_maven_path": {
                String currentValue = (String)arg;
                this.mavenHomeValueChanged(this.useEmbeddedFieldEditor.getBooleanValue(), currentValue, MavenUIPlugin.getDefault().isMavenBinaryValid(currentValue));
                break;
            }
            case "mule_core_plugin_preference_maven_embedded": {
                boolean useEmbedded = (Boolean)arg;
                this.mavenHomeFieldEditor.setEnabled(!useEmbedded, this.getFieldEditorParent());
                String currentMavenHome = this.mavenHomeFieldEditor.getCurrentValue();
                this.mavenHomeValueChanged(useEmbedded, currentMavenHome, MavenUIPlugin.getDefault().isMavenBinaryValid(currentMavenHome));
                break;
            }
            case "mule_core_plugin_preference_maven_override_m2_repo": {
                boolean overrideLocalRepository = (Boolean)arg;
                this.mavenLocalRepo.setEnabled(overrideLocalRepository, this.getFieldEditorParent());
                break;
            }
            case "mule_core_plugin_preference_maven_override_settings_security": {
                boolean overrideSettingsSecurity = (Boolean)arg;
                this.mavenSettingsSecurityPathEditor.setEnabled(overrideSettingsSecurity, this.getFieldEditorParent());
            }
        }
        this.checkState();
    }
}

