/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.preferences;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.mule.tooling.core.m2.internal.MavenCore;
import org.mule.tooling.maven.ui.preferences.ServersSettingsPage;
import org.xml.sax.SAXException;

public class GlobalSettingsPage
extends ServersSettingsPage {
    private static final String CHANGES_IN_GLOBAL_SETTINGS_AFFECT_OTHERS = "Any changes made to the global settings may affect other users";
    private static final int WARNING_DIALOG_STYLE = 2;
    private static final String NOT_WRITE_PERMISSIONS = "You don't have write permissions for this file.";
    private static final String CANNOT_EDIT_GLOBAL_SETTINGS_USING_EMBEDDED_MAVEN = "You cannot edit global settings file when using an embedded Maven installation.";
    private static final String PAGE_INTRO = "Manage the servers used in the global settings.";
    private static final String OVERRIDE_GLOBAL_SETTINGS_PATH_LABEL = "Override global settings path";
    private static final String PATH_TO_GLOBAL_SETTINGS_XML_LABEL = "Path to global settings.xml";
    private IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("mule_core_plugin_preference_maven_embedded".equals(event.getProperty())) {
                GlobalSettingsPage.this.addButton.setEnabled(GlobalSettingsPage.this.calculateEditButtonsEnabled(GlobalSettingsPage.this.overrideCheckbox));
                GlobalSettingsPage.this.setWarningMessage(GlobalSettingsPage.this.overrideCheckbox);
                GlobalSettingsPage.this.getAndShowServers();
            }
        }
    };

    public GlobalSettingsPage() throws SAXException, IOException {
        super(PAGE_INTRO, "mule_core_plugin_preference_maven_override_global_settings", OVERRIDE_GLOBAL_SETTINGS_PATH_LABEL, "mule_core_plugin_preference_maven_override_global_settings_path", PATH_TO_GLOBAL_SETTINGS_XML_LABEL);
    }

    @Override
    Optional<File> getDefaultFile() {
        return MavenCore.getGlobalSettingsFile();
    }

    @Override
    boolean calculateEditButtonsEnabled(boolean overrideCheckbox) {
        boolean useEmbeddedMavenCheckbox = this.preferenceStore.getBoolean("mule_core_plugin_preference_maven_embedded");
        boolean writePermission = this.checkSettingsFileHasWritePermission();
        return writePermission && (!useEmbeddedMavenCheckbox || overrideCheckbox);
    }

    public void dispose() {
        this.preferenceStore.removePropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.addButton.setEnabled(this.calculateEditButtonsEnabled(this.overrideCheckbox));
            this.setWarningMessage(this.overrideCheckbox);
            this.getAndShowServers();
        }
    }

    private void setWarningMessage(boolean overrideCheckbox) {
        boolean fileHasPermission = this.checkSettingsFileHasWritePermission();
        if (this.preferenceStore.getBoolean("mule_core_plugin_preference_maven_embedded") && !overrideCheckbox) {
            this.setMessage(CANNOT_EDIT_GLOBAL_SETTINGS_USING_EMBEDDED_MAVEN, 2);
        } else if (!fileHasPermission) {
            this.setMessage(NOT_WRITE_PERMISSIONS, 2);
        } else {
            this.setMessage(CHANGES_IN_GLOBAL_SETTINGS_AFFECT_OTHERS, 2);
        }
    }

    private boolean checkSettingsFileHasWritePermission() {
        Optional<File> settings = this.getSelectedSettingsFile();
        return settings.isPresent() ? settings.get().canWrite() : false;
    }

    @Override
    void initPreferenceListeners(IPreferenceStore preferenceStore) {
        preferenceStore.addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    public void valueChanged(String preference, Object arg) {
        super.valueChanged(preference, arg);
        if (preference.equals(this.overrideCheckboxId)) {
            this.setWarningMessage((Boolean)arg);
            this.addButton.setEnabled(this.calculateEditButtonsEnabled((Boolean)arg));
        }
        if (preference.equals(this.settingsFilePathId)) {
            this.setWarningMessage(true);
            this.addButton.setEnabled(this.calculateEditButtonsEnabled(true));
        }
    }
}

