/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.launch;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.function.BiFunction;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.WordUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.deployer.DefaultPackagingRequest;
import org.mule.tooling.core.deployer.DeploymentHelper;
import org.mule.tooling.core.deployer.DeploymentStrategy;
import org.mule.tooling.core.deployer.MuleApplicationDeployment;
import org.mule.tooling.core.deployer.PackagingRequest;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.packageManager.BaseExportDelegate;
import org.mule.tooling.maven.MavenMuleProjectDecorator;
import org.mule.tooling.maven.cmdline.MavenCommandLine;
import org.mule.tooling.maven.export.MavenExportManager;
import org.mule.tooling.maven.ui.MavenUIPlugin;
import org.mule.tooling.maven.ui.launch.MavenBuildJob;
import org.mule.tooling.maven.ui.utils.MavenUiUtils;
import org.mule.tooling.maven.utils.MavenCompilerPluginUtils;
import org.mule.tooling.maven.utils.MavenUtils;
import org.mule.tooling.utils.ObjectHolder;

public class MavenDeploymentStrategy
implements DeploymentStrategy {
    public static final String SNAPSHOT_UPDATES_ARG = "-U";
    private static final String NOT_SNAPSHOT_UPDATES_ARG = "-nsu";
    protected static final IStatus FAIL_STATUS = new Status(8, "org.mule.tooling.maven.ui", "status to indicate a deployment failure (development only, not intended to propagate to the user)");
    public static final String MAVEN_COMMAND_LINE_ARGUMENTS = "maven.command.line";
    public static final String MAVEN_SNAPSHOT_UPDATES = "maven.snapshot.updates";
    protected static final int DEFAULT_LIST_SIZE = 5;
    private static final String REFRESH_DESCRIPTOR_MAVEN_PHASE = "process-classes";
    private final BiFunction<IProject, MavenCommandLine, Job> buildJobProvider;
    private BiFunction<List<File>, String, File> onMultipleResults;

    public MavenDeploymentStrategy() {
        this(MavenDeploymentStrategy.generateBuildJobProvider(true), MavenDeploymentStrategy::promptFromCandidates);
    }

    public MavenDeploymentStrategy(BiFunction<IProject, MavenCommandLine, Job> buildJobProvider, BiFunction<List<File>, String, File> onMultipleResults) {
        this.buildJobProvider = buildJobProvider;
        this.onMultipleResults = onMultipleResults;
    }

    private static BiFunction<IProject, MavenCommandLine, Job> generateBuildJobProvider(boolean showingConsole) {
        return (project, commandline) -> {
            IMuleProject muleProject = MuleRuntime.create((IProject)project);
            return new MavenBuildJob(MavenUiUtils.getJobTitle(muleProject, commandline), (MavenCommandLine)commandline, muleProject, MavenMuleProjectDecorator.decorate((IMuleProject)muleProject).getPomFile(), (PackagingRequest)DefaultPackagingRequest.builder((IMuleProject)muleProject).build(), showingConsole);
        };
    }

    public boolean appliesTo(IMuleProject muleProject) {
        return true;
    }

    public boolean deployToEmbeddedInstance(PackagingRequest request) throws CoreException {
        boolean packageSuccessful;
        File resultingJarFile;
        IMuleProject muleProject = request.getProject();
        if (muleProject == null) {
            resultingJarFile = request.getOption("maven.export.artifact_file").map(File.class::cast).orElseThrow(() -> new IllegalArgumentException("an artifact file should be provided for a package request with missing project"));
        } else {
            MavenCompilerPluginUtils.checkAndUpdateJavaCompilationTarget((IMuleProject)muleProject);
            MavenCommandLine commandline = MavenDeploymentStrategy.getCommandLine(request);
            MuleApplicationDeployment.updateDeploymentDescriptor((IMuleProject)muleProject);
            resultingJarFile = this.packageJarFile(request, commandline);
        }
        boolean bl = packageSuccessful = resultingJarFile != null;
        if (packageSuccessful) {
            try {
                File destinationMuleFolder = (File)request.getOutputFile().orElseThrow(() -> new IllegalArgumentException("output file is mandatory for packaging requests used in deployment strategies"));
                FileUtils.copyFile((File)resultingJarFile, (File)new File(destinationMuleFolder, muleProject == null ? resultingJarFile.getName() : BaseExportDelegate.getDefaultApplicationJarName((IMuleProject)muleProject)));
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.mule.tooling.maven.ui", "Unable to copy project zip file to the embedded Mule instance. Project: " + String.valueOf(muleProject), (Throwable)e));
            }
        } else {
            MuleCorePlugin.logError((String)"Unable to find result application jar file", (Throwable)new RuntimeException());
        }
        return packageSuccessful;
    }

    public static MavenCommandLine getCommandLine(PackagingRequest request) {
        String cmdLineString = request.getOption(MAVEN_COMMAND_LINE_ARGUMENTS).map(cmdLine -> " " + ((String)cmdLine).trim()).orElse("");
        StringBuilder baseCommandlineBuilder = new StringBuilder(MavenUIPlugin.getDefault().getPreferences().getBaseCommandline());
        request.getOption(MAVEN_SNAPSHOT_UPDATES).ifPresent(update -> {
            if (((Boolean)update).booleanValue()) {
                if (baseCommandlineBuilder.toString().contains(NOT_SNAPSHOT_UPDATES_ARG)) {
                    int start = baseCommandlineBuilder.indexOf(NOT_SNAPSHOT_UPDATES_ARG);
                    baseCommandlineBuilder.replace(start, start + NOT_SNAPSHOT_UPDATES_ARG.length(), SNAPSHOT_UPDATES_ARG);
                } else {
                    baseCommandlineBuilder.append(" ").append(SNAPSHOT_UPDATES_ARG);
                }
            }
        });
        return MavenCommandLine.fromString((String)(baseCommandlineBuilder.toString() + cmdLineString));
    }

    private MavenCommandLine getMavenCompileCommandLine(MavenCommandLine originalCommandLine) {
        List arguments = originalCommandLine.getArgumentsList();
        for (String goal : originalCommandLine.getGoals()) {
            arguments.remove(goal);
        }
        StringBuilder compileCommandLine = new StringBuilder(String.format("mvn %s ", REFRESH_DESCRIPTOR_MAVEN_PHASE));
        for (String argument : arguments) {
            compileCommandLine.append(argument);
            compileCommandLine.append(" ");
        }
        return MavenCommandLine.fromString((String)compileCommandLine.toString());
    }

    private void generateProcessClassesJob(IMuleProject muleProject, MavenCommandLine commandline) {
        Job buildCompileJob = MavenDeploymentStrategy.generateBuildJobProvider(false).apply(muleProject.getProject(), commandline);
        buildCompileJob.setUser(false);
        buildCompileJob.setPriority(30);
        MuleApplicationDeployment.storeProcessClassesJob((IProject)muleProject.getProject(), (Job)buildCompileJob);
    }

    public File packageJarFile(PackagingRequest request) {
        MavenCommandLine commandline = MavenDeploymentStrategy.getCommandLine(request);
        return this.packageJarFile(request, commandline);
    }

    private File packageJarFile(PackagingRequest request, MavenCommandLine commandline) {
        IMuleProject muleProject = request.getProject();
        if (!MavenUtils.isMavenBased((IMuleProject)muleProject)) {
            throw new IllegalStateException("project " + String.valueOf(muleProject) + " is not maven based");
        }
        Job buildJob = this.buildJobProvider.apply(muleProject.getProject(), commandline);
        buildJob.setUser(false);
        buildJob.setPriority(30);
        buildJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        buildJob.schedule();
        this.safeJoin(buildJob);
        this.generateProcessClassesJob(muleProject, this.getMavenCompileCommandLine(commandline));
        return buildJob.getResult().isOK() ? this.getResultingJarFile(request, muleProject, commandline) : null;
    }

    private File getResultingJarFile(PackagingRequest request, IMuleProject muleProject, MavenCommandLine commandline) {
        DeploymentHelper deploymentHelper = new DeploymentHelper(muleProject);
        Properties runProperties = new Properties();
        commandline.getProperties().forEach(p -> {
            Object object = runProperties.setProperty(p.getKey(), p.getValue() != null ? p.getValue() : Boolean.TRUE.toString());
        });
        return MavenExportManager.findResultFile((PackagingRequest)request, (File)deploymentHelper.getTargetFolder(), this.onMultipleResults, (Properties)runProperties);
    }

    static File promptFromCandidates(final List<File> candidateFiles, final String expectedZipFileName) {
        final ObjectHolder file = new ObjectHolder();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ElementListSelectionDialog selectionDialog = new ElementListSelectionDialog(null, (ILabelProvider)new FileLabelProvider());
                selectionDialog.setElements(candidateFiles.toArray());
                selectionDialog.setTitle("Select result file to deploy");
                selectionDialog.setMessage(WordUtils.wrap((String)("The final name of the project (" + expectedZipFileName + ") cannot be fully resolved, and multiple candidate files were found to select as the result of the Maven build."), (int)100) + "\nPlease select the file to deploy to the runtime:");
                selectionDialog.setBlockOnOpen(true);
                selectionDialog.setMultipleSelection(false);
                selectionDialog.setHelpAvailable(false);
                selectionDialog.setSize(25, Math.max(candidateFiles.size() + 1, 5));
                int result = selectionDialog.open();
                file.set(result == 0 ? (File)selectionDialog.getFirstResult() : null);
            }
        });
        return (File)file.get();
    }

    private void safeJoin(Job buildJob) {
        try {
            buildJob.join();
        }
        catch (InterruptedException interruptedException) {}
    }

    public static void generateDefaultProcessClassesJob(IMuleProject muleProject) {
        MavenDeploymentStrategy deploymentStrategy = new MavenDeploymentStrategy();
        deploymentStrategy.generateProcessClassesJob(muleProject, MavenCommandLine.fromString((String)"mvn process-classes"));
    }

    private static class FileLabelProvider
    extends LabelProvider {
        private FileLabelProvider() {
        }

        public String getText(Object element) {
            return ((File)element).getName();
        }
    }
}

