/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.launch;

import java.io.File;
import java.io.PipedOutputStream;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.mule.tooling.core.deployer.PackagingRequest;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.maven.cmdline.MavenCommandLine;
import org.mule.tooling.maven.export.MavenExportManager;
import org.mule.tooling.maven.runner.MavenExecutionException;
import org.mule.tooling.maven.ui.actions.BaseStudioGoalRunner;
import org.mule.tooling.maven.ui.actions.StudioGoalRunner;
import org.mule.tooling.maven.utils.MavenUtils;

public class MavenBuildJob
extends WorkspaceJob {
    private final StudioGoalRunner goalRunner;
    private final File pomFileToDeploy;
    private final IMuleProject muleProject;

    public MavenBuildJob(String name, MavenCommandLine commandline, IMuleProject muleProject, File pomFileToDeploy, PackagingRequest packagingRequest) {
        this(name, commandline, muleProject, pomFileToDeploy, packagingRequest, true);
    }

    public MavenBuildJob(String name, MavenCommandLine commandline, IMuleProject muleProject, File pomFileToDeploy, PackagingRequest packagingRequest, boolean showConsole) {
        super(name);
        this.pomFileToDeploy = pomFileToDeploy;
        this.muleProject = muleProject;
        this.goalRunner = new BaseStudioGoalRunner(muleProject, MavenUtils.getCommandLine((String)commandline.getCommand(), (PackagingRequest)packagingRequest), showConsole);
    }

    protected void canceling() {
        this.goalRunner.cancelBuild();
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        try {
            MavenExportManager.installDomainProjectIfNecessary((IMuleProject)this.muleProject, (PipedOutputStream)new PipedOutputStream());
        }
        catch (InterruptedException | MavenExecutionException e) {
            throw new CoreException((IStatus)new Status(4, "org.mule.tooling.maven.ui", "There was a problem installing the domain associated with project " + this.muleProject.getLabel(), e));
        }
        int result = this.goalRunner.run(this.pomFileToDeploy, monitor);
        switch (result) {
            case 0: {
                return Status.OK_STATUS;
            }
            case -31: {
                return new Status(8, "org.mule.tooling.maven.ui", "User cancelled running build on project " + this.muleProject.getName());
            }
        }
        return new Status(4, "org.mule.tooling.maven.ui", "There was an error running build on project " + this.muleProject.getName());
    }
}

