/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.editors;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.maven.ui.IPublishToExchangeEditorValidator;
import org.mule.tooling.maven.ui.editors.AssetMetadataEditorConfiguration;
import org.mule.tooling.maven.ui.editors.DynamicContentEditor;
import org.mule.tooling.ui.widgets.dynamic.table.DynamicContent;
import org.mule.tooling.ui.widgets.dynamic.table.TablePersistenceStrategy;

public class TextEditor
extends DynamicContentEditor
implements DynamicContent,
IPublishToExchangeEditorValidator {
    private Text valueText;
    private String selectedKey;
    private String currentValue = "";

    public void createControls(Composite parent) {
        Composite editorWrapper = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(editorWrapper);
        GridDataFactory.fillDefaults().grab(true, false).indent(23, 0).applyTo((Control)editorWrapper);
        this.valueText = new Text(editorWrapper, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.valueText);
        this.valueText.addModifyListener(event -> {
            this.currentValue = this.valueText.getText();
            this.notifyListeners();
        });
    }

    public TablePersistenceStrategy<AssetMetadataEditorConfiguration> getPersistenceStrategy() {
        return new TextPersistenceStrategy();
    }

    public void updateValue() {
        this.valueText.setText(this.currentValue);
    }

    @Override
    public boolean isValid() {
        return !this.valueText.getText().isBlank();
    }

    private class TextPersistenceStrategy
    implements TablePersistenceStrategy<AssetMetadataEditorConfiguration> {
        private TextPersistenceStrategy() {
        }

        public AssetMetadataEditorConfiguration save() {
            return new AssetMetadataEditorConfiguration(TextEditor.this.selectedKey, TextEditor.this.currentValue);
        }

        public void load(AssetMetadataEditorConfiguration parameters) {
            TextEditor.this.selectedKey = parameters.getId();
            TextEditor.this.currentValue = parameters.getFirstValue();
            TextEditor.this.updateValue();
        }
    }
}

