/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.editors;

import java.util.regex.Pattern;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.maven.ui.IPublishToExchangeEditorValidator;
import org.mule.tooling.maven.ui.editors.AssetMetadataEditorConfiguration;
import org.mule.tooling.maven.ui.editors.DynamicContentEditor;
import org.mule.tooling.ui.widgets.WidgetsImages;
import org.mule.tooling.ui.widgets.dynamic.table.DynamicContent;
import org.mule.tooling.ui.widgets.dynamic.table.TablePersistenceStrategy;

public class NumberEditor
extends DynamicContentEditor
implements DynamicContent,
IPublishToExchangeEditorValidator {
    private Text valueText;
    private Label errorImg;
    private String selectedKey;
    private String currentValue = "";
    private static final Pattern VALID_NUMBER_PATTERN = Pattern.compile("-?[0-9]{1,10}");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("-?[0-9]*");

    public void createControls(Composite parent) {
        Composite editorWrapper = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(editorWrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)editorWrapper);
        Composite textComposite = new Composite(editorWrapper, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(textComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)textComposite);
        this.errorImg = new Label(textComposite, 1);
        this.errorImg.setVisible(false);
        this.errorImg.setImage(WidgetsImages.getImage((String)"icons/requirements/error.png"));
        this.errorImg.setToolTipText("Invalid number input");
        this.valueText = new Text(textComposite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.valueText);
        this.valueText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String oldValue = NumberEditor.this.valueText.getText();
                String newValue = oldValue.substring(0, e.start) + e.text + oldValue.substring(e.end);
                if (!newValue.isEmpty() && !NUMBER_PATTERN.matcher(newValue).matches()) {
                    e.doit = false;
                }
            }
        });
        this.valueText.addModifyListener(event -> {
            this.currentValue = this.valueText.getText();
            this.notifyListeners();
        });
    }

    public TablePersistenceStrategy<AssetMetadataEditorConfiguration> getPersistenceStrategy() {
        return new NumberPersistenceStrategy();
    }

    public void updateValue() {
        this.valueText.setText(this.currentValue);
    }

    @Override
    public boolean isValid() {
        String text = this.valueText.getText();
        boolean isValid = !text.isBlank() && VALID_NUMBER_PATTERN.matcher(text).matches();
        this.errorImg.setVisible(!isValid);
        return isValid;
    }

    private class NumberPersistenceStrategy
    implements TablePersistenceStrategy<AssetMetadataEditorConfiguration> {
        private NumberPersistenceStrategy() {
        }

        public AssetMetadataEditorConfiguration save() {
            return new AssetMetadataEditorConfiguration(NumberEditor.this.selectedKey, NumberEditor.this.currentValue);
        }

        public void load(AssetMetadataEditorConfiguration parameters) {
            NumberEditor.this.selectedKey = parameters.getId();
            NumberEditor.this.currentValue = parameters.getFirstValue();
            NumberEditor.this.updateValue();
        }
    }
}

