/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.editors;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.mule.tooling.maven.ui.IPublishToExchangeEditorValidator;
import org.mule.tooling.maven.ui.editors.AssetMetadataEditorConfiguration;
import org.mule.tooling.maven.ui.editors.DynamicContentEditor;
import org.mule.tooling.ui.widgets.ChipsContainer;
import org.mule.tooling.ui.widgets.dynamic.table.DynamicContent;
import org.mule.tooling.ui.widgets.dynamic.table.TablePersistenceStrategy;

public class MultipleValuesEditor
extends DynamicContentEditor
implements DynamicContent,
IPublishToExchangeEditorValidator {
    private List<String> acceptedValues;
    private ChipsContainer chipsContainer;
    private String selectedKey;
    private List<String> selectedValues = new ArrayList<String>();
    private boolean useFixedValues;
    private Pattern inputRegex;
    private Pattern validationRegex;
    private String valueTypeName = "";

    public MultipleValuesEditor(List<String> acceptedValues) {
        Objects.requireNonNull(acceptedValues, "The acceptedValues parameter can't be null");
        this.acceptedValues = acceptedValues;
        this.useFixedValues = true;
    }

    public MultipleValuesEditor(Pattern inputRegex, Pattern validationRegex, String valueTypeName) throws PatternSyntaxException {
        this.inputRegex = inputRegex;
        this.validationRegex = validationRegex;
        this.valueTypeName = valueTypeName;
        this.useFixedValues = false;
    }

    public void createControls(Composite parent) {
        Composite editorWrapper = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(editorWrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)editorWrapper);
        this.chipsContainer = this.useFixedValues ? new ChipsContainer(editorWrapper, this.acceptedValues) : new ChipsContainer(editorWrapper, this.valueTypeName, false, this.inputRegex, this.validationRegex);
        this.chipsContainer.setMaxVisibleTextLength(Integer.valueOf(15));
        this.chipsContainer.allowRepeatedElements(false);
        this.chipsContainer.addChipsContainerStateEventListener(this::notifyListeners);
        GridDataFactory.fillDefaults().grab(true, false).indent(23, 0).applyTo((Control)this.chipsContainer);
    }

    public TablePersistenceStrategy<AssetMetadataEditorConfiguration> getPersistenceStrategy() {
        return new MultipleValuesPersistenceStrategy();
    }

    @Override
    public boolean isValid() {
        List chipsContents = this.chipsContainer.getChipsContents();
        if (chipsContents.isEmpty()) {
            return false;
        }
        if (this.useFixedValues) {
            return this.acceptedValues.containsAll(chipsContents);
        }
        return chipsContents.stream().allMatch(this.validationRegex.asMatchPredicate());
    }

    private class MultipleValuesPersistenceStrategy
    implements TablePersistenceStrategy<AssetMetadataEditorConfiguration> {
        private MultipleValuesPersistenceStrategy() {
        }

        public AssetMetadataEditorConfiguration save() {
            return new AssetMetadataEditorConfiguration(MultipleValuesEditor.this.selectedKey, MultipleValuesEditor.this.chipsContainer.getChipsContents());
        }

        public void load(AssetMetadataEditorConfiguration parameters) {
            MultipleValuesEditor.this.selectedKey = parameters.getId();
            MultipleValuesEditor.this.selectedValues = parameters.getValues();
            MultipleValuesEditor.this.selectedValues.forEach(value -> MultipleValuesEditor.this.chipsContainer.createNewChip(value));
        }
    }
}

