/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.editors;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.regex.Pattern;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.maven.ui.IPublishToExchangeEditorValidator;
import org.mule.tooling.maven.ui.editors.AssetMetadataEditorConfiguration;
import org.mule.tooling.maven.ui.editors.DynamicContentEditor;
import org.mule.tooling.ui.widgets.WidgetsImages;
import org.mule.tooling.ui.widgets.dynamic.table.DynamicContent;
import org.mule.tooling.ui.widgets.dynamic.table.TablePersistenceStrategy;

public class DateEditor
extends DynamicContentEditor
implements DynamicContent,
IPublishToExchangeEditorValidator {
    private Text valueText;
    private Label errorImg;
    private String selectedKey;
    private String currentValue = "";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd");
    private static final Pattern COMPLETE_DATE_PATTERN = Pattern.compile("\\d{4}/\\d{2}/\\d{2}");
    private static final String INVALID_DATE_FORMAT_ERROR = "Invalid date format, use YYYY/MM/DD instead";
    private static final String INVALID_DATE_ERROR = "Input date is invalid";

    public void createControls(Composite parent) {
        Composite editorWrapper = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(editorWrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)editorWrapper);
        Composite textComposite = new Composite(editorWrapper, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(textComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)textComposite);
        this.errorImg = new Label(textComposite, 1);
        this.errorImg.setVisible(false);
        this.errorImg.setImage(WidgetsImages.getImage((String)"icons/requirements/error.png"));
        this.errorImg.setToolTipText(INVALID_DATE_FORMAT_ERROR);
        this.valueText = new Text(textComposite, 2048);
        this.valueText.setMessage("YYYY/MM/DD");
        this.valueText.setToolTipText("Enter a date in YYYY/MM/DD format");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.valueText);
        this.addValueTextListeners();
        DATE_FORMAT.setLenient(false);
    }

    private void addValueTextListeners() {
        this.valueText.addModifyListener(event -> {
            this.currentValue = this.valueText.getText();
            this.notifyListeners();
        });
    }

    public TablePersistenceStrategy<AssetMetadataEditorConfiguration> getPersistenceStrategy() {
        return new DatePersistenceStrategy();
    }

    public void updateValue() {
        this.valueText.setText(this.currentValue);
    }

    @Override
    public boolean isValid() {
        String date = this.valueText.getText();
        if (COMPLETE_DATE_PATTERN.matcher(date).matches()) {
            try {
                DATE_FORMAT.parse(date);
                this.errorImg.setVisible(false);
                return true;
            }
            catch (ParseException parseException) {
                this.errorImg.setVisible(true);
                this.errorImg.setToolTipText(INVALID_DATE_ERROR);
                return false;
            }
        }
        this.errorImg.setToolTipText(INVALID_DATE_FORMAT_ERROR);
        this.errorImg.setVisible(true);
        return false;
    }

    private class DatePersistenceStrategy
    implements TablePersistenceStrategy<AssetMetadataEditorConfiguration> {
        private DatePersistenceStrategy() {
        }

        public AssetMetadataEditorConfiguration save() {
            return new AssetMetadataEditorConfiguration(DateEditor.this.selectedKey, DateEditor.this.currentValue);
        }

        public void load(AssetMetadataEditorConfiguration parameters) {
            DateEditor.this.selectedKey = parameters.getId();
            DateEditor.this.currentValue = parameters.getFirstValue();
            DateEditor.this.updateValue();
        }
    }
}

