/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.dependency;

import java.text.MessageFormat;
import java.util.Optional;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.core.dependencymanagement.BaseRequirementManager;
import org.mule.tooling.core.dependencymanagement.RequirementDependencyManager;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.maven.MavenMuleProjectDecorator;
import org.mule.tooling.maven.ui.dependency.AddMavenDependencyWizard;
import org.mule.tooling.maven.ui.dependency.MavenDependencyWizardDialog;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.module.Requirement;

public class MavenRequirementManager
extends BaseRequirementManager {
    private static final String ADD_ACTION_ID = "ADD_MAVEN_DEPENDENCY";
    private static final String ADD_ACTION_LABEL = "Add Maven dependency";
    private static final String MODIFY_ACTION_ID = "MODIFY_MAVEN_DEPENDENCY";
    private static final String MODIFY_ACTION_LABEL = "Modify Maven dependency";

    public MavenRequirementManager() {
        super(ADD_ACTION_ID, ADD_ACTION_LABEL, MODIFY_ACTION_ID, MODIFY_ACTION_LABEL);
    }

    public boolean applies(RequirementDependencyManager.Action action, IMuleProject muleProject, Requirement requirement) {
        return true;
    }

    public Optional<MavenDependency> run(RequirementDependencyManager.Action action, Shell activeShell, IMuleProject muleProject, IMessageFlowNode node, Requirement requirement, Optional<String> data) {
        AddMavenDependencyWizard addDependencyWizard;
        if (!MavenMuleProjectDecorator.decorate((IMuleProject)muleProject).isPomWellFormed()) {
            MessageDialog.openWarning((Shell)activeShell, (String)this.getLabel(action), (String)MessageFormat.format("The pom.xml file for project {0} is currently invalid. Fix the existing problems and try again.", muleProject.getName()));
            return Optional.empty();
        }
        Optional<MavenDependency> initialDependency = this.getInitialDependency(action, muleProject, requirement, data);
        int result = initialDependency.map(arg_0 -> MavenRequirementManager.lambda$0(activeShell, addDependencyWizard = AddMavenDependencyWizard.forSharedDependency(muleProject), arg_0)).orElseGet(() -> new MavenDependencyWizardDialog(activeShell, addDependencyWizard)).open();
        return result == 0 ? Optional.of(addDependencyWizard.getDependency()) : Optional.empty();
    }

    private Optional<MavenDependency> getInitialDependency(RequirementDependencyManager.Action action, IMuleProject muleProject, Requirement requirement, Optional<String> data) {
        Optional<MavenDependency> initialDependency = RequirementDependencyManager.Action.ADD.equals((Object)action) ? this.getSuggestedDependency(muleProject, requirement) : data.map(d -> this.getDependencyFromData((String)d)).map(dep -> this.findDependencyInProject(muleProject, (MavenDependency)dep));
        return initialDependency;
    }

    private static /* synthetic */ MavenDependencyWizardDialog lambda$0(Shell shell, AddMavenDependencyWizard addMavenDependencyWizard, MavenDependency dep) {
        return new MavenDependencyWizardDialog(shell, addMavenDependencyWizard, dep);
    }
}

