/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.dependency;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.maven.ui.dependency.AddMavenDependencyWizard;

public class MavenDependencyWizardDialog
extends WizardDialog {
    private MavenDependency dependency;
    private AddMavenDependencyWizard dependencyWizard;
    private Button removeButton;

    public MavenDependencyWizardDialog(Shell parentShell, AddMavenDependencyWizard newWizard) {
        this(parentShell, newWizard, null);
    }

    public MavenDependencyWizardDialog(Shell parentShell, AddMavenDependencyWizard newWizard, MavenDependency dependency) {
        super(parentShell, (IWizard)newWizard);
        this.dependency = dependency;
        this.dependencyWizard = newWizard;
        newWizard.setInitialMavenDependency(dependency);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        if (this.dependency != null) {
            this.createRemoveButton(parent);
        }
    }

    protected void finishPressed() {
        if (this.removeButton != null) {
            this.removeButton.setEnabled(false);
        }
        super.finishPressed();
        if (this.removeButton != null && !this.removeButton.isDisposed()) {
            this.removeButton.setEnabled(true);
        }
    }

    private Button createRemoveButton(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        this.removeButton = new Button(parent, 8);
        this.removeButton.setText("Remove dependency");
        this.setButtonLayoutData(this.removeButton);
        this.removeButton.setFont(parent.getFont());
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MavenDependencyWizardDialog.this.removeButton.setEnabled(false);
                if (MavenDependencyWizardDialog.this.dependencyWizard.performRemove()) {
                    MavenDependencyWizardDialog.this.close();
                } else {
                    MavenDependencyWizardDialog.this.removeButton.setEnabled(true);
                }
            }
        });
        return this.removeButton;
    }
}

