/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.dependency;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.statushandlers.StatusManager;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.m2.DependencyResolutionConfiguration;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.dependency.PojoMavenDependencyBuilder;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.runner.ArtifactResolvingRunnerFactory;
import org.mule.tooling.core.module.runner.DependenciesCallback;
import org.mule.tooling.maven.MavenMuleProjectDecorator;
import org.mule.tooling.maven.ui.MavenUIPlugin;
import org.mule.tooling.maven.ui.dependency.AddMavenDependencyPage;
import org.mule.tooling.utils.ObjectHolder;

public class AddMavenDependencyWizard
extends Wizard {
    private static final String SHELL_TITLE = "Maven dependency";
    private static final String DIALOG_TITLE = "Pick a Maven dependency";
    private AddMavenDependencyPage addDependencyPage;
    private IMuleProject muleProject;
    private MavenDependency initialDependency;
    private boolean sharedDependency;

    public static AddMavenDependencyWizard forStandardDependency(IMuleProject muleProject) {
        return new AddMavenDependencyWizard(muleProject, false);
    }

    public static AddMavenDependencyWizard forSharedDependency(IMuleProject muleProject) {
        return new AddMavenDependencyWizard(muleProject, true);
    }

    public void setInitialMavenDependency(MavenDependency mavenDependency) {
        this.initialDependency = mavenDependency;
    }

    public AddMavenDependencyWizard(IMuleProject muleProject, boolean sharedDependency) {
        this.muleProject = muleProject;
        this.sharedDependency = sharedDependency;
        this.setNeedsProgressMonitor(true);
    }

    public boolean performRemove() {
        boolean confirm = MessageDialog.openConfirm((Shell)this.getShell(), (String)DIALOG_TITLE, (String)("Are you sure you want to remove " + MavenUtils.getGAV((MavenDependency)this.initialDependency) + " from the project?"));
        if (confirm) {
            IProject project = this.muleProject.getProject();
            this.executeInContainer(project, new AddRemoveDependencyToProjectRunnable((ObjectHolder<IStatus>)new ObjectHolder(), this.initialDependency, this.muleProject, AddRemoveAction.REMOVE));
        }
        return confirm;
    }

    public boolean performFinish() {
        IProject project = this.muleProject.getProject();
        if (this.initialDependency != null) {
            this.executeInContainer(project, new AddRemoveDependencyToProjectRunnable((ObjectHolder<IStatus>)new ObjectHolder(), this.initialDependency, this.muleProject, AddRemoveAction.REMOVE));
        }
        MavenDependency dependency = this.getDependency();
        ObjectHolder resultHolder = new ObjectHolder();
        boolean buildPathHealthy = this.executeInContainerCheckingBuildPath(dependency, project, (ObjectHolder<IStatus>)resultHolder);
        boolean resultOk = ((IStatus)resultHolder.get()).isOK();
        if (!resultOk || !buildPathHealthy) {
            return this.handleFailure((IStatus)resultHolder.get(), dependency, project);
        }
        return resultOk;
    }

    public MavenDependency getDependency() {
        MavenDependency dependency = this.addDependencyPage.getDependency();
        return ((PojoMavenDependencyBuilder)PojoMavenDependencyBuilder.copyFrom((MavenDependency)dependency).beingShared(this.sharedDependency)).build();
    }

    private boolean executeInContainerCheckingBuildPath(MavenDependency dependency, IProject project, ObjectHolder<IStatus> resultHolder) {
        int originalBuildPathErrors = this.getBuildPathErrorsCount(project);
        this.executeInContainer(project, new AddRemoveDependencyToProjectRunnable(resultHolder, dependency, this.muleProject, AddRemoveAction.ADD));
        int newBuildPathErrors = this.getBuildPathErrorsCount(project);
        return newBuildPathErrors - originalBuildPathErrors <= 0;
    }

    private boolean handleFailure(IStatus result, MavenDependency dependency, IProject project) {
        if (result == Status.CANCEL_STATUS) {
            return false;
        }
        StatusManager.getManager().handle(result, 2);
        return false;
    }

    private int getBuildPathErrorsCount(IProject project) {
        try {
            IMarker[] findMarkers = project.findMarkers("org.eclipse.jdt.core.buildpath_problem", true, 0);
            return findMarkers.length;
        }
        catch (CoreException e) {
            MavenUIPlugin.getDefault().logError("There was a problem retrieving build path markers from project: " + project.getName(), e);
            return 0;
        }
    }

    private void executeInContainer(IProject project, AddRemoveDependencyToProjectRunnable runnable) {
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)runnable);
        }
        catch (InterruptedException | InvocationTargetException e) {
            MavenUIPlugin.getDefault().logError("There was a problem modifying the project dependencies for " + project.getName(), e);
        }
    }

    public void addPages() {
        super.addPages();
        this.addDependencyPage = new AddMavenDependencyPage(this.muleProject, "org.mule.tooling.maven.ui.dependency.addDependency", DIALOG_TITLE, null);
        if (this.initialDependency != null) {
            this.addDependencyPage.setDependency(this.initialDependency);
        }
        this.addPage((IWizardPage)this.addDependencyPage);
        this.setWindowTitle(SHELL_TITLE);
    }

    public static IStatus toMultiStatus(Map<MavenDependency, List<Exception>> exceptions) {
        MultiStatus multiStatus = new MultiStatus("org.mule.tooling.maven.ui", 0, "Problems downloading dependencies", null);
        Set<Map.Entry<MavenDependency, List<Exception>>> entrySet = exceptions.entrySet();
        for (Map.Entry<MavenDependency, List<Exception>> entry : entrySet) {
            List<Exception> entryExceptions = entry.getValue();
            Status status = entryExceptions.isEmpty() ? new Status(4, "org.mule.tooling.maven.ui", "Failed to download " + MavenUtils.getGAV((MavenDependency)entry.getKey())) : new Status(4, "org.mule.tooling.maven.ui", "Failed to download " + MavenUtils.getGAV((MavenDependency)entry.getKey()), (Throwable)entryExceptions.get(0));
            multiStatus.add((IStatus)status);
        }
        return multiStatus;
    }

    private static enum AddRemoveAction {
        ADD,
        REMOVE;

    }

    private static final class AddRemoveDependencyToProjectRunnable
    implements IRunnableWithProgress {
        private final ObjectHolder<IStatus> resultHolder;
        private final MavenDependency dependency;
        private final IMuleProject muleProject;
        private AddRemoveAction action;

        private AddRemoveDependencyToProjectRunnable(ObjectHolder<IStatus> resultHolder, MavenDependency dependency, IMuleProject muleProject, AddRemoveAction action) {
            this.resultHolder = resultHolder;
            this.dependency = dependency;
            this.muleProject = muleProject;
            this.action = action;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask((this.action.equals((Object)AddRemoveAction.ADD) ? "Adding" : "Removing") + " dependency", 100);
            try {
                ArtifactResolvingRunnerFactory.syncInstance().runResolvingDependencies(this.muleProject, Arrays.asList(this.dependency), DependenciesCallback.builder().onSuccess(resolvedFiles -> {
                    IStatus result;
                    if (resolvedFiles.get(this.dependency) != null) {
                        MavenMuleProjectDecorator decorate = MavenMuleProjectDecorator.decorate((IMuleProject)this.muleProject);
                        if (this.action.equals((Object)AddRemoveAction.ADD)) {
                            decorate.addDependency(this.dependency);
                            AnalyticsRecordsFactory.single((String)Events.ADD_MAVEN_DEPENDENCY_WIZARD, (String[])new String[]{"dependency", MavenUtils.getGAV((MavenDependency)this.dependency)}).track();
                        } else {
                            decorate.removeDependency(this.dependency);
                        }
                        result = Status.OK_STATUS;
                    } else {
                        result = Status.CANCEL_STATUS;
                    }
                    this.resultHolder.set((Object)result);
                }).onError(exceptions -> {
                    Object object = this.resultHolder.set((Object)AddMavenDependencyWizard.toMultiStatus(exceptions));
                }).build(), DependencyResolutionConfiguration.createDefault().includeProvidedScope(), (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)100));
            }
            finally {
                monitor.done();
            }
        }
    }
}

