/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.dependency;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.query.MavenQueryResult;
import org.mule.tooling.core.m2.query.MavenSearchEngine;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.maven.MavenMuleProjectDecorator;
import org.mule.tooling.maven.MavenPlugin;
import org.mule.tooling.maven.utils.MavenUtils;
import org.mule.tooling.ui.m2.dependency.MavenDependencyPicker;
import org.mule.tooling.ui.m2.dependency.MavenDependencyPickerListener;

public class AddMavenDependencyPage
extends WizardPage {
    private static final String DIALOG_MESSAGE = "Pick a Maven dependency to add to the project";
    private MavenDependencyPicker mavenDependencyPicker;
    private MavenDependency mavenDependency;
    private MavenMuleProjectDecorator muleProject;

    protected AddMavenDependencyPage(IMuleProject muleProject, String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.muleProject = MavenMuleProjectDecorator.decorate((IMuleProject)muleProject);
    }

    public void createControl(Composite parent) {
        this.setMessage(DIALOG_MESSAGE);
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        this.mavenDependencyPicker = MavenDependencyPicker.create(this.getSearchEngines(), (IRunnableContext)this.getWizard().getContainer());
        Control pickerControl = this.mavenDependencyPicker.createControl(composite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo(pickerControl);
        if (this.mavenDependency != null) {
            this.mavenDependencyPicker.setDependency(this.mavenDependency);
        }
        this.mavenDependencyPicker.addListener(new MavenDependencyPickerListener(){

            public void dependencyChanged(MavenDependency dependency) {
                AddMavenDependencyPage.this.dependencyChanged(dependency);
            }

            public void onQueryChanged(String queryArgument) {
                AddMavenDependencyPage.this.setMessage(AddMavenDependencyPage.DIALOG_MESSAGE);
            }

            public void onQueryFailed(MavenQueryResult result) {
                AddMavenDependencyPage.this.setMessage(result.getFailureMessage(), 3);
            }
        });
        this.setControl((Control)composite);
    }

    private Optional<List<MavenSearchEngine>> getSearchEngines() {
        return Optional.ofNullable(Arrays.asList(MavenPlugin.getMavenCentralEngine()));
    }

    public MavenDependency getDependency() {
        return this.mavenDependencyPicker.getDependency();
    }

    public void setDependency(MavenDependency mavenDependency) {
        this.mavenDependency = mavenDependency;
    }

    private void dependencyChanged(MavenDependency dependency) {
        if (this.mavenDependency == null || !this.equalGA(dependency, this.mavenDependency)) {
            boolean hasDependency = this.muleProject.hasDependency(dependency, false);
            if (hasDependency) {
                this.setMessage("A dependency with the same group and artifact id already exists in the project (" + MavenUtils.getGavString((MavenDependency)this.muleProject.getDependency(dependency, false)) + ")", 2);
            } else {
                this.setMessage(DIALOG_MESSAGE);
            }
        } else {
            this.setMessage(DIALOG_MESSAGE);
        }
    }

    private boolean equalGA(MavenDependency dependency, MavenDependency mavenDependency) {
        if (dependency.getGroupId() != null && mavenDependency.getGroupId() != null) {
            if (!dependency.getGroupId().equals(mavenDependency.getGroupId())) {
                return false;
            }
        } else {
            if (dependency.getGroupId() == null ^ mavenDependency.getGroupId() == null) {
                return false;
            }
            if (dependency.getArtifactId() != null && mavenDependency.getArtifactId() != null ? !dependency.getArtifactId().equals(mavenDependency.getArtifactId()) : dependency.getArtifactId() == null ^ mavenDependency.getArtifactId() == null) {
                return false;
            }
        }
        return true;
    }
}

