/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.command;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.maven.ui.actions.PopulateRepoAction;
import org.mule.tooling.maven.ui.command.MavenAbstractHandler;
import org.mule.tooling.ui.utils.UiUtils;

public class PopulateRepository
extends MavenAbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IMuleProject muleProject = UiUtils.getSelectedMuleProjectInPackageExplorer();
        boolean userWantsToPopulate = this.promptToUser("Manually populating the M2 repository is for troubleshooting purposes only. Are you sure you want to proceed?");
        if (muleProject != null && userWantsToPopulate) {
            this.doPopulateRepository(muleProject);
        }
        return null;
    }

    private void doPopulateRepository(final IMuleProject muleProject) {
        WorkspaceJob updateJob = new WorkspaceJob("Populating local Maven repository"){

            public IStatus runInWorkspace(IProgressMonitor monitor1) throws CoreException {
                PopulateRepoAction.get(true).execute(muleProject, monitor1);
                return Status.OK_STATUS;
            }
        };
        updateJob.setUser(false);
        updateJob.setPriority(50);
        updateJob.schedule();
    }
}

