/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.command;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.maven.ui.MuleModuleNotificationPopup;
import org.mule.tooling.maven.ui.WorkspaceModuleDependencyController;
import org.mule.tooling.maven.ui.dependency.MuleModuleToUpdate;
import org.mule.tooling.maven.ui.exceptions.UnableToCheckForUpdatesException;
import org.mule.tooling.maven.ui.preferences.NotificationsPreferences;
import org.mule.tooling.maven.ui.utils.MavenUiUtils;

public class MuleDependenciesUpdatesChecker
extends Job {
    public static final String JOB_NAME = "Periodic Mule Modules updates check";

    public MuleDependenciesUpdatesChecker() {
        super(JOB_NAME);
        this.setSystem(true);
    }

    private boolean shouldCheckForUpdatesAfterTimeElapsed() {
        return NotificationsPreferences.areNotificationsEnabled() && NotificationsPreferences.isCheckAfterTimeElapsedEnabled();
    }

    private List<MuleModuleToUpdate> checkForUpdates() throws UnableToCheckForUpdatesException {
        try {
            return WorkspaceModuleDependencyController.getInstance().getAvailableMuleModulesUpdates((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            MuleCorePlugin.logError((String)"Mule projects modules couldn't be collected", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private void showNotification(List<MuleModuleToUpdate> modules) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(() -> {
            if (!display.isDisposed()) {
                new MuleModuleNotificationPopup(modules).open();
            }
        });
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            List<MuleModuleToUpdate> updates = this.checkForUpdates();
            if (!updates.isEmpty()) {
                this.showNotification(updates);
            }
            if (this.shouldCheckForUpdatesAfterTimeElapsed()) {
                this.schedule(MavenUiUtils.computeDelay(NotificationsPreferences.daysUntilNextCheckForUpdates()));
            }
        }
        catch (UnableToCheckForUpdatesException e) {
            this.schedule(TimeUnit.HOURS.toMillis(1L));
            MuleCorePlugin.logError((String)"There was a problem checking for Mule modules updates from Exchange. Trying again in one hour.", (Throwable)e);
        }
        return Status.OK_STATUS;
    }
}

