/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.actions;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.maven.ui.actions.MavenProjectLifecycleAction;

public class ProjectLifecycleActionPipeline {
    private static final int PROGRESS_SCALE = 100;
    private final String taskName;
    private final List<MavenProjectLifecycleAction> actions;

    public ProjectLifecycleActionPipeline(String taskName, List<MavenProjectLifecycleAction> actions) {
        this.taskName = taskName;
        this.actions = actions;
    }

    public static ProjectLifecycleActionPipeline create(String taskName, MavenProjectLifecycleAction ... actions) {
        return new ProjectLifecycleActionPipeline(taskName, Arrays.asList(actions));
    }

    public boolean execute(IMuleProject muleProject, IProgressMonitor monitor) {
        if (monitor.isCanceled() || this.actions.isEmpty()) {
            return this.actions.isEmpty();
        }
        int size = this.actions.size();
        monitor.beginTask(this.taskName, size * 100);
        try {
            boolean success = false;
            for (MavenProjectLifecycleAction action : this.actions) {
                boolean bl = success = action.checkedExecute(muleProject, (IProgressMonitor)new SubProgressMonitor(monitor, 100)) && !monitor.isCanceled();
                if (!success) break;
            }
            boolean bl = success;
            return bl;
        }
        finally {
            monitor.done();
        }
    }
}

