/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.actions;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.m2.MavenResourceUtils;
import org.mule.tooling.core.m2.dependency.ExternalModuleMavenDependency;
import org.mule.tooling.core.m2.dependency.JarFileMavenDependency;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.dependency.PojoMavenDependency;
import org.mule.tooling.core.m2.dependency.PojoMavenDependencyBuilder;
import org.mule.tooling.core.m2.dependency.inspect.DefaultMavenJarfileInspector;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.utils.IMavenModel;
import org.mule.tooling.maven.ui.MavenUIPlugin;
import org.mule.tooling.maven.ui.actions.AddDependenciesAction;
import org.mule.tooling.maven.ui.actions.MavenProjectLifecycleAction;
import org.mule.tooling.maven.ui.mavenize.MavenizeAction;
import org.mule.tooling.maven.ui.mavenize.MavenizeActionExtensionManager;
import org.mule.tooling.model.project.MuleExtension;

public class MavenizeProjectAction
extends MavenProjectLifecycleAction {
    private static final String CONTRIB_EXCEPTION_MESSAGE = "There was a problem executing a third-party Mavenize contribution: \"{0}\"";
    private static final String DEFAULT_VERSION = "1.0.0-SNAPSHOT";

    public static MavenizeProjectAction get() {
        return new MavenizeProjectAction();
    }

    @Override
    protected boolean doExecute(IMuleProject muleProject, IProgressMonitor monitor) {
        String defaultGroupId = MavenUIPlugin.getDefault().getPreferences().getDefaultGroupId();
        PojoMavenModel mavenModel = new PojoMavenModel(defaultGroupId, muleProject.getName(), DEFAULT_VERSION);
        PojoMavenDependency dep = ((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)PojoMavenDependencyBuilder.newInstance().withGroupId(defaultGroupId)).withArtifactId(muleProject.getName())).withVersion(DEFAULT_VERSION)).build();
        try {
            boolean result = true;
            Set<MavenDependency> newDependencies = this.getNewDependencies(muleProject);
            List<MavenizeAction> mavenizeActions = this.promptToUser(muleProject, mavenModel, newDependencies, this.getApplicableMavenizeActions(muleProject));
            if (mavenizeActions != null) {
                MavenResourceUtils.createPomFile((MuleProjectKind)muleProject.getKind(), (IJavaProject)muleProject.getJavaProject(), (IServerDefinition)muleProject.getServerDefinition(), (MavenDependency)dep);
                for (MavenizeAction mavenizeAction : mavenizeActions) {
                    result &= this.executeMavenizeAction(mavenizeAction, muleProject, mavenModel);
                }
            }
            return result;
        }
        catch (IOException e) {
            MavenUIPlugin.getDefault().logError("There was an error mavenizing project: " + muleProject.getName(), e);
            return false;
        }
        catch (CoreException e) {
            MavenUIPlugin.getDefault().logError("There was an error mavenizing project: " + muleProject.getName(), e);
            return false;
        }
    }

    private List<MavenizeAction> promptToUser(IMuleProject muleProject, IMavenModel mavenModel, Set<MavenDependency> newDependencies, List<MavenizeAction> mavenizeActions) {
        if (newDependencies.size() + mavenizeActions.size() > 0) {
            CheckedTreeSelectionDialog selectionDialog = this.createDependenciesSelectionDialog(muleProject, mavenModel, newDependencies, mavenizeActions);
            selectionDialog.setTitle("Mavenizing project " + muleProject.getName());
            int dialogReturn = selectionDialog.open();
            if (dialogReturn == 0) {
                Object[] result = selectionDialog.getResult();
                ArrayList<MavenizeAction> actions = new ArrayList<MavenizeAction>(result.length);
                ArrayList<MavenDependency> dependencies = new ArrayList<MavenDependency>(result.length);
                Object[] objectArray = result;
                int n = result.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof MavenizeAction) {
                        actions.add((MavenizeAction)object);
                    } else if (object instanceof MavenDependency) {
                        dependencies.add((MavenDependency)object);
                    }
                    ++n2;
                }
                actions.add(new AddDependenciesAction(dependencies));
                return actions;
            }
            return null;
        }
        return Collections.emptyList();
    }

    private boolean executeMavenizeAction(MavenizeAction mavenizeAction, IMuleProject muleProject, IMavenModel mavenModel) {
        try {
            return mavenizeAction.execute(muleProject, mavenModel);
        }
        catch (Throwable e) {
            String message = MessageFormat.format(CONTRIB_EXCEPTION_MESSAGE, mavenizeAction.getDescription(muleProject, mavenModel));
            MavenUIPlugin.getDefault().logError(message, e);
            return false;
        }
    }

    private List<MavenizeAction> getApplicableMavenizeActions(IMuleProject muleProject) {
        ArrayList<MavenizeAction> mavenizeActions = new ArrayList<MavenizeAction>();
        for (MavenizeAction mavenizeActionExtension : MavenizeActionExtensionManager.getInstance().getMavenizeActions()) {
            if (!mavenizeActionExtension.applies(muleProject)) continue;
            mavenizeActions.add(mavenizeActionExtension);
        }
        return mavenizeActions;
    }

    private Set<MavenDependency> getNewDependencies(IMuleProject muleProject) throws CoreException, IOException {
        Set<MavenDependency> mavenizedMuleExtensions = this.getMavenizedMuleExtensions(muleProject);
        Set<MavenDependency> mavenizedClasspathLibs = this.getMavenizedClasspathLibs(muleProject);
        Sets.SetView unionView = Sets.union(mavenizedClasspathLibs, mavenizedMuleExtensions);
        HashSet newDependencies = Sets.newHashSet((Iterator)unionView.iterator());
        return newDependencies;
    }

    private CheckedTreeSelectionDialog createDependenciesSelectionDialog(IMuleProject muleProject, IMavenModel mavenModel, Set<MavenDependency> newDependencies, List<MavenizeAction> mavenizeActions) {
        ArrayList<MavenizeAction> input = new ArrayList<MavenizeAction>(mavenizeActions);
        input.addAll(newDependencies);
        CheckedTreeSelectionDialog selectionDialog = new CheckedTreeSelectionDialog(null, (ILabelProvider)new MavenDependencyLabelProvider(muleProject, mavenModel), (ITreeContentProvider)new ArrayTreeContentProvider());
        selectionDialog.setMessage("Select which of the following actions to perform:");
        selectionDialog.setBlockOnOpen(true);
        Object[] inputArray = input.toArray(new Object[input.size()]);
        selectionDialog.setInput((Object)inputArray);
        selectionDialog.setInitialSelections(inputArray);
        return selectionDialog;
    }

    private Set<MavenDependency> getMavenizedClasspathLibs(IMuleProject projectDecorator) throws CoreException, IOException {
        IClasspathEntry[] rawClasspath = projectDecorator.getJavaProject().getRawClasspath();
        HashSet newDependencies = Sets.newHashSet();
        IClasspathEntry[] iClasspathEntryArray = rawClasspath;
        int n = rawClasspath.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            File fileForClasspathEntry = CoreUtils.getFileForClasspathEntry((IClasspathEntry)entry, (IJavaProject)projectDecorator.getJavaProject());
            if (fileForClasspathEntry != null) {
                Throwable throwable = null;
                Object var10_11 = null;
                try (JarFile jarFile = new JarFile(fileForClasspathEntry);){
                    JarFileMavenDependency dependency;
                    if (DefaultMavenJarfileInspector.hasMavenMetadata((JarFile)jarFile) && this.isValidDependency(dependency = JarFileMavenDependency.from((JarFile)jarFile))) {
                        newDependencies.add(dependency);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            ++n2;
        }
        return newDependencies;
    }

    private Set<MavenDependency> getMavenizedMuleExtensions(IMuleProject projectDecorator) {
        List declaredExtensions = projectDecorator.getDeclaredExtensions();
        HashSet newDependencies = Sets.newHashSetWithExpectedSize((int)declaredExtensions.size());
        Map externalContributionsMappedByUniqueId = MuleCorePlugin.getModuleContributionManager().getExternalContributionsMappedById(projectDecorator.getServerDefinition());
        for (MuleExtension muleExtension : declaredExtensions) {
            ExternalContributionMuleModule module = (ExternalContributionMuleModule)externalContributionsMappedByUniqueId.get(muleExtension.getQualifier());
            if (module == null || !MavenResourceUtils.isMavenBased((ExternalContributionMuleModule)module)) continue;
            ExternalModuleMavenDependency dependency = ExternalModuleMavenDependency.from((ExternalContributionMuleModule)module);
            newDependencies.add(dependency);
        }
        return newDependencies;
    }

    private boolean isValidDependency(JarFileMavenDependency dependency) {
        if (dependency != null) {
            String groupId = dependency.getGroupId();
            String artifactId = dependency.getArtifactId();
            String version = dependency.getVersion();
            if (groupId != null && artifactId != null && version != null) {
                return !groupId.isEmpty() && !artifactId.isEmpty() && !version.isEmpty();
            }
        }
        return false;
    }

    private class ArrayTreeContentProvider
    implements ITreeContentProvider {
        private ArrayTreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    private class MavenDependencyLabelProvider
    extends LabelProvider {
        private IMuleProject muleProject;
        private IMavenModel mavenModel;

        public MavenDependencyLabelProvider(IMuleProject muleProject, IMavenModel mavenModel) {
            this.muleProject = muleProject;
            this.mavenModel = mavenModel;
        }

        public String getText(Object element) {
            Object description = "";
            if (element instanceof MavenDependency) {
                MavenDependency dependency = (MavenDependency)element;
                description = "Add dependency: " + dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion();
            } else if (element instanceof MavenizeAction) {
                MavenizeAction mavenizeAction = (MavenizeAction)element;
                description = mavenizeAction.getDescription(this.muleProject, this.mavenModel);
            }
            return description;
        }
    }

    private class PojoMavenModel
    implements IMavenModel {
        private String groupId;
        private String artifactId;
        private String version;

        PojoMavenModel(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

