/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.actions;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.utils.VMUtils;
import org.mule.tooling.maven.cmdline.MavenCommandLine;
import org.mule.tooling.maven.runner.DefaultMavenRunnerConfiguration;
import org.mule.tooling.maven.runner.MavenRunner;
import org.mule.tooling.maven.runner.MavenRunnerBuilder;
import org.mule.tooling.maven.runner.MavenRunnerCallback;
import org.mule.tooling.maven.runner.MavenRunnerConfiguration;
import org.mule.tooling.maven.runner.SyncGetResultCallback;

public class MavenInstallationTester {
    private String mavenInstallationHome;
    private StringBuilder outputBuilder;
    private boolean embedded;

    public MavenInstallationTester(boolean embedded, String newMavenInstallationHome) {
        this.embedded = embedded;
        this.mavenInstallationHome = newMavenInstallationHome;
        this.outputBuilder = new StringBuilder();
    }

    private String getJavaHome() {
        String javaHome = VMUtils.getJdkJavaHome();
        if (javaHome != null) {
            return javaHome;
        }
        MuleCorePlugin.logWarning((String)"No valid home for JDK found. Maven may not work if using a JRE.", null);
        return VMUtils.getDefaultJvmHome(null);
    }

    public int test(SyncGetResultCallback callback) {
        MavenRunnerBuilder builder = MavenRunnerBuilder.with((MavenRunnerConfiguration)new DefaultMavenRunnerConfiguration(!this.embedded, this.mavenInstallationHome, ""));
        if (!this.embedded) {
            String javaHome = this.getJavaHome();
            if (StringUtils.isNotEmpty((String)javaHome)) {
                if (!VMUtils.isJdkJavaHome((String)javaHome)) {
                    this.outputBuilder.append(MessageFormat.format("WARNING: Java home located in {0} is not a JDK and therefore not suitable for compiling using Maven.\n", javaHome));
                }
                builder.setJavaHome(javaHome);
            } else {
                this.outputBuilder.append("ERROR: No valid Java installation found");
                callback.finished(-1);
                return -1;
            }
        }
        MavenRunner mavenRunner = builder.build();
        int result = 0;
        try {
            result = this.runMvnVersion(mavenRunner, this.outputBuilder, callback);
            return result;
        }
        catch (Exception e) {
            String message = "Could not validate maven installation. Error occured while executing maven test command.";
            MuleCorePlugin.logWarning((String)message, (Throwable)e);
            this.outputBuilder.append(message);
            this.outputBuilder.append("\n");
            this.appendStackTraceToOutput(e);
            callback.finished(-1);
            return -1;
        }
    }

    private void appendStackTraceToOutput(Exception e) {
        PrintStream printStream = null;
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            printStream = new PrintStream(outputStream);
            e.printStackTrace(printStream);
            this.outputBuilder.append(outputStream.toString());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(printStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)printStream);
    }

    private int runMvnVersion(MavenRunner mavenRunner, StringBuilder stringBuilder, SyncGetResultCallback callback) throws IOException, InterruptedException {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        callback = callback == null ? new SyncGetResultCallback() : callback;
        mavenRunner.runBare(MavenCommandLine.fromString((String)"mvn --version"), (MavenRunnerCallback)callback, (OutputStream)byteOutputStream);
        int result = callback.getResult();
        stringBuilder.append(byteOutputStream.toString());
        return result;
    }

    public String getOutput() {
        return this.outputBuilder.toString();
    }
}

