/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.actions;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.mule.tooling.core.deployer.DefaultPackagingRequest;
import org.mule.tooling.core.deployer.PackagingRequest;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.maven.MavenMuleProjectDecorator;
import org.mule.tooling.maven.cmdline.MavenCommandLine;
import org.mule.tooling.maven.ui.MavenUIPlugin;
import org.mule.tooling.maven.ui.actions.MavenProjectLifecycleAction;
import org.mule.tooling.maven.ui.launch.MavenBuildJob;
import org.mule.tooling.maven.ui.utils.MavenUiUtils;
import org.mule.tooling.maven.utils.MavenOutputToMonitorRedirectorThread;
import org.mule.tooling.maven.utils.OutputRedirectorThread;
import org.mule.tooling.maven.utils.RunnableUtils;
import org.mule.tooling.ui.utils.UiUtils;

public class InstallProjectAction
extends MavenProjectLifecycleAction {
    private OutputRedirectorThread redirectOutputToConsoleThread;
    private MavenOutputToMonitorRedirectorThread redirectOutputToMonitorThread;

    public static InstallProjectAction get() {
        return new InstallProjectAction();
    }

    @Override
    protected boolean doExecute(IMuleProject muleProject, IProgressMonitor monitor) {
        String jobName = "Installing project " + muleProject.getName();
        MavenCommandLine commandLine = MavenCommandLine.fromString((String)"mvn clean install");
        monitor.beginTask(jobName, 100);
        try {
            PipedOutputStream pipedOutputStream = new PipedOutputStream();
            PipedOutputStream nextOutput = new PipedOutputStream();
            MavenBuildJob mavenBuildJob = new MavenBuildJob(jobName, commandLine, muleProject, MavenMuleProjectDecorator.decorate((IMuleProject)muleProject).getPomFile(), (PackagingRequest)DefaultPackagingRequest.builder((IMuleProject)muleProject).build());
            this.redirectOutputToMonitor(jobName, pipedOutputStream, monitor, 100, nextOutput);
            this.redirectOutputToConsole(nextOutput, (OutputStream)MavenUiUtils.getMessageConsole(muleProject, commandLine).newOutputStream());
            boolean bl = mavenBuildJob.runInWorkspace((IProgressMonitor)new NullProgressMonitor()).isOK();
            return bl;
        }
        catch (CoreException e) {
            MavenUIPlugin.getDefault().logError("There was a problem installing project " + muleProject.getName(), e);
            return false;
        }
        finally {
            monitor.done();
            this.redirectOutputToConsoleThread.interrupt();
            this.redirectOutputToConsoleThread = null;
            this.redirectOutputToMonitorThread.interrupt();
            this.redirectOutputToMonitorThread = null;
        }
    }

    private void redirectOutputToConsole(PipedOutputStream nextOutput, OutputStream consoleStream) {
        PipedInputStream inputStream = null;
        try {
            inputStream = new PipedInputStream(nextOutput);
        }
        catch (IOException e) {
            throw new RuntimeException("IO exception creating piped streams (should not happen)", e);
        }
        this.redirectOutputToConsoleThread = new OutputRedirectorThread((InputStream)inputStream, consoleStream, RunnableUtils.newRunnableClosing((Closeable[])new Closeable[]{inputStream, consoleStream}));
        UiUtils.showConsoleView();
        this.redirectOutputToConsoleThread.start();
    }

    protected void redirectOutputToMonitor(String jobName, PipedOutputStream pipedOutputStream, IProgressMonitor monitor, int taskTicks, PipedOutputStream nextOutput) {
        PipedInputStream sourceStream = null;
        try {
            sourceStream = new PipedInputStream(pipedOutputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("IO exception creating piped streams (should not happen)", e);
        }
        this.redirectOutputToMonitorThread = new MavenOutputToMonitorRedirectorThread(sourceStream, monitor, jobName, (OutputStream)nextOutput);
        this.redirectOutputToMonitorThread.setProgressUpperLimit(taskTicks);
        this.redirectOutputToMonitorThread.start();
    }
}

