/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.actions;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.mule.tooling.core.auth.Organization;
import org.mule.tooling.core.auth.PlatformUrls;
import org.mule.tooling.core.deployer.DefaultPackagingRequest;
import org.mule.tooling.core.deployer.PackagingRequest;
import org.mule.tooling.core.m2.ExchangeMavenFacade;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.maven.MavenMuleProjectDecorator;
import org.mule.tooling.maven.cmdline.MavenCommandLine;
import org.mule.tooling.maven.ui.actions.ResultCallback;
import org.mule.tooling.maven.ui.launch.MavenBuildJob;
import org.mule.tooling.maven.ui.utils.MavenUiUtils;

public class ExchangeMavenDeployer
implements IRunnableWithProgress {
    private static final String DEFAULT_CMDLINE = "mvn -f \"%s\" clean deploy";
    private static final String DEFAULT_DEPLOYMENT = "-DaltDeploymentRepository=" + ExchangeMavenFacade.getCurrentId() + "::default::%s";
    private MavenBuildJob buildJob;
    private MavenMuleProjectDecorator muleMavenProject;
    private Organization org;
    private Optional<File> pomFile;
    private ResultCallback callback;

    public ExchangeMavenDeployer(MavenMuleProjectDecorator decorate, Organization org, Optional<File> pomFile, ResultCallback callback) {
        this.muleMavenProject = decorate;
        this.org = org;
        this.pomFile = pomFile;
        this.callback = callback;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        block6: {
            File pomFileToDeploy = this.pomFile.isPresent() ? this.pomFile.get() : this.muleMavenProject.getPomFile();
            MavenCommandLine commandLine = MavenCommandLine.fromString((String)String.format("mvn -f \"%s\" clean deploy " + DEFAULT_DEPLOYMENT, pomFileToDeploy.getAbsolutePath(), PlatformUrls.getOrganizationBasedMavenFacadeUrl((String)this.org.getId())));
            DefaultPackagingRequest packagingRequest = DefaultPackagingRequest.builder((IMuleProject)this.muleMavenProject.getMuleProject()).attachSources(true).build();
            this.buildJob = new MavenBuildJob(MavenUiUtils.getJobTitle(this.muleMavenProject.getMuleProject(), commandLine), commandLine, this.muleMavenProject.getMuleProject(), pomFileToDeploy, (PackagingRequest)packagingRequest);
            monitor.beginTask("Deploying project to Exchange...", 100);
            try {
                try {
                    IStatus result = this.buildJob.runInWorkspace(monitor);
                    if (result.isOK()) {
                        this.callback.onSuccess();
                        break block6;
                    }
                    this.callback.onFailure();
                }
                catch (CoreException coreException) {
                    this.callback.onFailure();
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
    }
}

