/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.actions;

import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.model.IMuleProject;

public class CheckSnapshotDependencies {
    public static boolean checkSnapshots(IMuleProject project) {
        return !CheckSnapshotDependencies.hasSnapshots(project) || CheckSnapshotDependencies.promptContinueWithSnapshot();
    }

    public static boolean hasSnapshots(IMuleProject project) {
        List dependencies = project.getDeclaredDependencies();
        for (MavenDependency dependency : dependencies) {
            if (!dependency.isSnapshot()) continue;
            return true;
        }
        return false;
    }

    private static boolean promptContinueWithSnapshot() {
        return MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Continue with snapshots?", (String)"Your application contains snapshot dependencies. This is not recommended because a change in the dependency may impact behavior after deployment.");
    }
}

