/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.io.EditingScope;
import org.mule.tooling.core.m2.PomMuleProjectModel;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.model.IMuleApplicationProject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.utils.JobUtils;
import org.mule.tooling.exchange.client.ExternalServiceCallException;
import org.mule.tooling.exchange.client.GraphServiceClient;
import org.mule.tooling.exchange.client.GraphServiceQueryBuilder;
import org.mule.tooling.exchange.client.GraphServiceResponse;
import org.mule.tooling.exchange.preferences.ExchangePreferences;
import org.mule.tooling.maven.ui.dependency.MuleModuleToUpdate;
import org.mule.tooling.maven.ui.exceptions.UnableToCheckForUpdatesException;
import org.mule.tooling.maven.ui.preferences.NotificationsPreferences;
import org.mule.tooling.maven.ui.properties.ModuleDependency;
import org.mule.tooling.ui.properties.IDependency;
import org.mule.tooling.ui.properties.ModuleDependencyManager;
import org.mule.tooling.ui.properties.dependencies.DependencyUtils;

public class WorkspaceModuleDependencyController {
    private static final GraphServiceClient.AssetType[] ASSET_TYPES = new GraphServiceClient.AssetType[]{GraphServiceClient.AssetType.EXTENSION, GraphServiceClient.AssetType.REST_API};
    private static WorkspaceModuleDependencyController instance;

    public static WorkspaceModuleDependencyController getInstance() {
        if (instance == null) {
            instance = new WorkspaceModuleDependencyController();
        }
        return instance;
    }

    private WorkspaceModuleDependencyController() {
    }

    public List<MuleModuleToUpdate> getAvailableMuleModulesUpdates(IProgressMonitor progressBar) throws CoreException, UnableToCheckForUpdatesException {
        Map<String, List<MuleModuleToUpdate>> workspaceModules = this.gatherMuleModulesDependencies();
        List<MuleModuleToUpdate> modulesWithUpdates = new ArrayList<MuleModuleToUpdate>();
        if (!workspaceModules.isEmpty()) {
            MuleCorePlugin.logInfo((String)("Checking updates in Exchange for: " + workspaceModules.keySet().toString()));
            this.completeAvailableVersions(workspaceModules, progressBar);
            if (!progressBar.isCanceled()) {
                List<MuleModuleToUpdate> unfilteredResult = workspaceModules.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
                modulesWithUpdates = this.filterUpToDateModules(unfilteredResult);
                if (modulesWithUpdates.isEmpty()) {
                    MuleCorePlugin.logInfo((String)"Check finished: all Mule Modules are up to date");
                } else {
                    MuleCorePlugin.logInfo((String)"Check finished: there are updates for some Mule Modules");
                }
            } else {
                MuleCorePlugin.logInfo((String)"Checking updates in Exchange canceled.");
            }
        }
        NotificationsPreferences.updateDateOfLastCheckForUpdates();
        JobUtils.rescheduleJob((String)"Periodic Mule Modules updates check", (long)TimeUnit.DAYS.toMillis(NotificationsPreferences.daysUntilNextCheckForUpdates()));
        return modulesWithUpdates;
    }

    private Map<String, List<MuleModuleToUpdate>> gatherMuleModulesDependencies() throws CoreException {
        List muleProjects = MuleRuntime.getMuleApplicationProjects();
        HashMap<String, List<MuleModuleToUpdate>> workspaceModules = new HashMap<String, List<MuleModuleToUpdate>>();
        for (IMuleApplicationProject project : muleProjects) {
            List<IDependency> modulesForSpecificProject = this.getMuleModulesForSpecificProject(project);
            for (IDependency module : modulesForSpecificProject) {
                String moduleGA = MavenUtils.getGA((MavenDependency)module.getDependency());
                MuleModuleToUpdate newMuleModuleToUpdate = new MuleModuleToUpdate(module, (IMuleProject)project);
                workspaceModules.computeIfAbsent(moduleGA, key -> new ArrayList()).add(newMuleModuleToUpdate);
            }
        }
        return workspaceModules;
    }

    private void completeAvailableVersions(Map<String, List<MuleModuleToUpdate>> muleModules, IProgressMonitor progressBar) throws UnableToCheckForUpdatesException {
        boolean couldCheckForUpdates = false;
        for (List<MuleModuleToUpdate> list : muleModules.values()) {
            if (progressBar.isCanceled()) break;
            Set<String> availableVersions = this.getAvailableVersionsForDependency(list.get(0).getMuleModule(), ASSET_TYPES);
            list.forEach(muleModuleToUpdate -> {
                boolean bl = muleModuleToUpdate.getMuleModule().getAvailableVersions().addAll(availableVersions);
            });
            progressBar.worked(100 / muleModules.size());
            if (couldCheckForUpdates || availableVersions.isEmpty()) continue;
            couldCheckForUpdates = true;
        }
        if (!couldCheckForUpdates) {
            throw new UnableToCheckForUpdatesException();
        }
    }

    private Set<String> getAvailableVersionsForDependency(IDependency dependency, GraphServiceClient.AssetType[] assetTypes) {
        HashSet<String> availableVersions = new HashSet<String>();
        try {
            GraphServiceClient graphServiceClient = DependencyUtils.getGraphServiceClient();
            GraphServiceQueryBuilder queryBuilder = GraphServiceQueryBuilder.create().withCoordinates(dependency.getGroupId(), dependency.getArtifactId()).withAssetTypes(assetTypes).includeSnapshots(ExchangePreferences.includeSnapshots()).ignoreAttributes().ignoreDependencies().build();
            GraphServiceResponse searchByCoordinates = graphServiceClient.search(queryBuilder, Optional.empty());
            List assets = searchByCoordinates.getElements();
            DependencyUtils.filterDeprecated((List)assets).forEach(asset -> {
                boolean bl = availableVersions.add(asset.getVersion());
            });
        }
        catch (ExternalServiceCallException e) {
            MuleCorePlugin.logInfo((String)("Failed to retrieve Exchange asset: " + dependency.getGroupId() + ":" + dependency.getArtifactId() + ". " + e.getMessage()));
        }
        return availableVersions;
    }

    private List<MuleModuleToUpdate> filterUpToDateModules(List<MuleModuleToUpdate> moduleList) {
        return moduleList.stream().filter(muleModuleToUpdate -> !muleModuleToUpdate.getMuleModule().getVersion().equals(DependencyUtils.getLatestVersion((IDependency)muleModuleToUpdate.getMuleModule()))).collect(Collectors.toList());
    }

    private List<IDependency> getMuleModulesForSpecificProject(IMuleApplicationProject muleProject) {
        List externalModules = muleProject.getModuleManager(EditingScope.TEST).getExternalModules();
        List dependencies = externalModules.stream().map(module -> new ModuleDependency((ExternalContributionMuleModule)module, DependencyUtils.getOriginalScope((IMuleProject)muleProject, (ExternalContributionMuleModule)module))).collect(Collectors.toList());
        PomMuleProjectModel pomModel = PomMuleProjectModel.create((IFile)muleProject.getMuleProjectDescriptorFile());
        return dependencies.stream().filter(dependency -> pomModel.hasDependencyLocal(dependency.getDependency())).collect(Collectors.toList());
    }

    public void updateMuleModulesToLatestPatchWithinMajorVersion(List<MuleModuleToUpdate> muleModulesToUpdate) {
        this.updateMuleModules(muleModulesToUpdate, DependencyUtils::getLatestVersionWithinMajorVersion);
    }

    public void updateMuleModulesToLatestVersion(List<MuleModuleToUpdate> muleModulesToUpdate) {
        this.updateMuleModules(muleModulesToUpdate, DependencyUtils::getLatestVersion);
    }

    private void updateMuleModules(List<MuleModuleToUpdate> muleModulesToUpdate, Function<IDependency, String> versionProvider) {
        HashMap<IMuleProject, ModuleDependencyManager> managersByProject = new HashMap<IMuleProject, ModuleDependencyManager>();
        for (MuleModuleToUpdate muleModuleToUpdate : muleModulesToUpdate) {
            IDependency module = muleModuleToUpdate.getMuleModule();
            IMuleProject project = muleModuleToUpdate.getProject();
            ModuleDependencyManager dependencyManager = managersByProject.computeIfAbsent(project, key -> new ModuleDependencyManager(project));
            dependencyManager.removeDependencyFromProject(module.getDependency());
            String newVersion = versionProvider.apply(module);
            module.setVersion(newVersion);
            module.setOriginalVersion(newVersion);
            dependencyManager.addDependencyToProject(module.getDependency());
        }
    }

    public List<MuleModuleToUpdate> updateMuleModulesVersionsToDisplay(List<MuleModuleToUpdate> muleModulesToDisplay) {
        return muleModulesToDisplay.stream().map(muleModuleToUpdate -> {
            Set<String> availableVersions = this.getAvailableVersionsForDependency(muleModuleToUpdate.getMuleModule(), ASSET_TYPES);
            MuleModuleToUpdate newMuleModuleToUpdate = new MuleModuleToUpdate(muleModuleToUpdate.getMuleModule(), muleModuleToUpdate.getProject());
            newMuleModuleToUpdate.getMuleModule().getAvailableVersions().addAll(availableVersions);
            return newMuleModuleToUpdate;
        }).collect(Collectors.toList());
    }
}

