/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.auth.AuthUser;
import org.mule.tooling.core.m2.ProjectType;
import org.mule.tooling.exchange.ExchangeAsset;
import org.mule.tooling.exchange.client.internal.ExchangeSchema;
import org.mule.tooling.maven.MavenMuleProjectDecorator;
import org.mule.tooling.maven.ui.CategoriesTypesManager;
import org.mule.tooling.maven.ui.CustomFieldsTypesManager;
import org.mule.tooling.maven.ui.IPublishToExchangeEditorValidator;
import org.mule.tooling.maven.ui.editors.AssetMetadataEditorConfiguration;
import org.mule.tooling.maven.ui.editors.AssetMetadataEditorConfigurationModule;
import org.mule.tooling.ui.widgets.ChipsContainer;
import org.mule.tooling.ui.widgets.dynamic.table.DefaultDynamicTable;
import org.mule.tooling.ui.widgets.dynamic.table.DynamicRow;
import org.mule.tooling.ui.widgets.dynamic.table.TypesManager;

public class PublishToExchangeWizardPageTwo
extends WizardPage {
    private static final String SAVING_CATEGORIES_ERROR = "There was a problem while saving the categories to the pom.xml";
    private static final String SAVING_CUSTOM_FIELDS_ERROR = "There was a problem while saving the custom fields to the pom.xml";
    private static final String INVALID_CATEGORY_WARNING = "The following categories defined in your pom.xml are not valid and won't be published: ";
    private static final String INVALID_CUSTOM_FIELD_WARNING = "The following custom fields defined in your pom.xml are not valid and won't be published: ";
    private static final String PAGE_TITLE = "Publish to Exchange";
    private static final String PUBLISH_TO_EXCHANGE_TITLE = "Add Tags, Categories and Custom Fields to your project. Remember to create your categories and custom fields prior to adding them to your assets.";
    private static final String PUBLISH_TO_EXCHANGE_PAGE_TWO_NAME = "org.mule.tooling.exchange.publish.aditionalinfo";
    private static final String TAGS = "Tags:";
    private static final String TAGS_SEPARATOR = ",";
    private static final String CATEGORIES_TABLE_TITLE = "Categories";
    private static final String CATEGORIES_TABLE_EMPTY_MESSAGE = "Click in the button below to add an existing category from Exchange";
    private static final String ADD_CATEGORY_BUTTON_LABEL = "Add existing category";
    private static final String CATEGORIES_BAD_FORMAT_WARNING_MESSAGE = "Categories defined in the pom.xml have an invalid format and will be overwritten";
    private static final String REMOVE_ALL_CATEGORIES_TITLE = "Remove all categories";
    private static final String REMOVE_ALL_CATEGORIES_QUESTION = "Are you sure you want to remove all categories?";
    private static final String CUSTOM_FIELDS_TABLE_TITLE = "Custom fields";
    private static final String CUSTOM_FIELDS_TABLE_EMPTY_MESSAGE = "Click in the button below to add an existing custom field from Exchange";
    private static final String ADD_CUSTOM_FIELD_BUTTON_LABEL = "Add existing custom field";
    private static final String CUSTOM_FIELDS_BAD_FORMAT_WARNING_MESSAGE = "Custom fields defined in the pom.xml have an invalid format and will be overwritten";
    private static final String REMOVE_ALL_CUSTOM_FIELDS_TITLE = "Remove all custom fields";
    private static final String REMOVE_ALL_CUSTOM_FIELDS_QUESTION = "Are you sure you want to remove all custom fields?";
    private static final String SAVE_CHANGES_IN_YOUR_PROJECT = "Save updated project information to the pom.xml";
    private MavenMuleProjectDecorator mavenDecorator;
    private ExchangeAsset exchangeAsset;
    private ScrolledComposite pageScrolledComposite;
    private Composite pageTwoMainComposite;
    private ChipsContainer chipsContainer;
    private DefaultDynamicTable categoriesTable;
    private DefaultDynamicTable customFieldsTable;
    private Button saveInProjectButton;
    private String statusCustomFieldsMessage;
    private String statusCategoriesMessage;
    private final ObjectMapper assetMetadataEditorConfigurationMapper;

    public PublishToExchangeWizardPageTwo(MavenMuleProjectDecorator mavenDecorator) {
        super(PUBLISH_TO_EXCHANGE_PAGE_TWO_NAME, PAGE_TITLE, null);
        this.mavenDecorator = mavenDecorator;
        this.assetMetadataEditorConfigurationMapper = new ObjectMapper();
        this.assetMetadataEditorConfigurationMapper.registerModule((Module)new AssetMetadataEditorConfigurationModule());
    }

    public void createControl(Composite parent) {
        this.setMessage(PUBLISH_TO_EXCHANGE_TITLE);
        this.pageScrolledComposite = new ScrolledComposite(parent, 768);
        this.pageTwoMainComposite = new Composite((Composite)this.pageScrolledComposite, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.pageTwoMainComposite);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(this.pageTwoMainComposite);
        this.createTagsSection(this.pageTwoMainComposite);
        this.createCategoriesSection(this.pageTwoMainComposite);
        this.createCustomFieldSection(this.pageTwoMainComposite);
        this.createSaveCheckboxSection(this.pageTwoMainComposite);
        this.pageScrolledComposite.setContent((Control)this.pageTwoMainComposite);
        this.pageScrolledComposite.setExpandVertical(true);
        this.pageScrolledComposite.setExpandHorizontal(true);
        this.addListeners();
        this.setControl((Control)this.pageScrolledComposite);
    }

    private void createTagsSection(Composite parent) {
        Group tagsGroup = new Group(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)tagsGroup);
        GridLayoutFactory.fillDefaults().extendedMargins(15, 15, 5, 5).applyTo((Composite)tagsGroup);
        Label tagsLabel = new Label((Composite)tagsGroup, 0);
        tagsLabel.setText(TAGS);
        GridDataFactory.fillDefaults().applyTo((Control)tagsLabel);
        this.chipsContainer = new ChipsContainer((Composite)tagsGroup, "tag", true);
        this.chipsContainer.setMaxVisibleTextLength(Integer.valueOf(15));
        this.chipsContainer.allowRepeatedElements(false);
        GridDataFactory.fillDefaults().grab(true, false).indent(2, 0).applyTo((Control)this.chipsContainer);
    }

    private void createCategoriesSection(Composite parent) {
        Group categoriesGroup = new Group(parent, 0);
        GridDataFactory.fillDefaults().minSize(200, 200).grab(true, true).applyTo((Control)categoriesGroup);
        GridLayoutFactory.fillDefaults().margins(12, 0).applyTo((Composite)categoriesGroup);
        Composite wrapper = new Composite((Composite)categoriesGroup, 0);
        GridLayoutFactory.fillDefaults().applyTo(wrapper);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)wrapper);
        this.categoriesTable = new DefaultDynamicTable(wrapper, MuleCorePlugin.getEventBus());
        this.categoriesTable.setEditorTitle(CATEGORIES_TABLE_TITLE);
        this.categoriesTable.setAddButtonLabel(ADD_CATEGORY_BUTTON_LABEL);
        this.categoriesTable.setEmptyMessage(CATEGORIES_TABLE_EMPTY_MESSAGE);
        this.categoriesTable.setDeleteAllQuestion(REMOVE_ALL_CATEGORIES_QUESTION);
        this.categoriesTable.setDeleteAllTitle(REMOVE_ALL_CATEGORIES_TITLE);
        this.categoriesTable.setUseLeftAlignmentInText(Boolean.TRUE);
        this.categoriesTable.setCreateTitle(true);
        this.categoriesTable.createControls();
        GridLayoutFactory.fillDefaults().extendedMargins(0, 10, 0, 0).applyTo((Composite)this.categoriesTable);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.categoriesTable);
    }

    private void createCustomFieldSection(Composite parent) {
        Group customFieldsGroup = new Group(parent, 0);
        GridDataFactory.fillDefaults().minSize(200, 200).grab(true, true).applyTo((Control)customFieldsGroup);
        GridLayoutFactory.fillDefaults().margins(12, 0).applyTo((Composite)customFieldsGroup);
        Composite wrapper = new Composite((Composite)customFieldsGroup, 0);
        GridLayoutFactory.fillDefaults().applyTo(wrapper);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)wrapper);
        this.customFieldsTable = new DefaultDynamicTable(wrapper, MuleCorePlugin.getEventBus());
        this.customFieldsTable.setEditorTitle(CUSTOM_FIELDS_TABLE_TITLE);
        this.customFieldsTable.setAddButtonLabel(ADD_CUSTOM_FIELD_BUTTON_LABEL);
        this.customFieldsTable.setEmptyMessage(CUSTOM_FIELDS_TABLE_EMPTY_MESSAGE);
        this.customFieldsTable.setDeleteAllQuestion(REMOVE_ALL_CUSTOM_FIELDS_QUESTION);
        this.customFieldsTable.setDeleteAllTitle(REMOVE_ALL_CUSTOM_FIELDS_TITLE);
        this.customFieldsTable.setUseLeftAlignmentInText(Boolean.TRUE);
        this.customFieldsTable.setCreateTitle(true);
        this.customFieldsTable.createControls();
        GridLayoutFactory.fillDefaults().extendedMargins(0, 10, 0, 0).applyTo((Composite)this.customFieldsTable);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.customFieldsTable);
    }

    private void createSaveCheckboxSection(Composite parent) {
        this.saveInProjectButton = new Button(parent, 32);
        this.saveInProjectButton.setText(SAVE_CHANGES_IN_YOUR_PROJECT);
        this.saveInProjectButton.setSelection(true);
    }

    private void addListeners() {
        this.pageScrolledComposite.addListener(11, event -> this.resizePageScrolledComposite());
        this.categoriesTable.addTableContentChangedListener(this::relayoutWizard);
        this.chipsContainer.addChipsContainerStateEventListener(this::relayoutWizard);
        this.customFieldsTable.addTableContentChangedListener(this::relayoutWizard);
    }

    private void relayoutWizard() {
        this.resizePageScrolledComposite();
        if (this.getContainer() != null) {
            this.getContainer().updateButtons();
        }
    }

    private void resizePageScrolledComposite() {
        Point consoleCompositeSize = this.pageTwoMainComposite.computeSize(this.pageScrolledComposite.getSize().x, -1);
        this.pageScrolledComposite.setMinSize(this.pageScrolledComposite.getParent().computeSize(consoleCompositeSize.x, consoleCompositeSize.y));
    }

    public boolean isSaveChangesToPomSelected() {
        return this.saveInProjectButton.getSelection();
    }

    public void performHelp() {
        Program.launch((String)"https://docs.mulesoft.com/studio/latest/export-to-exchange-task");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.refreshContent();
        }
    }

    private void refreshContent() {
        this.resolveTags();
        this.fillCategoriesTable();
        this.fillCustomFieldsTable();
        this.saveInProjectButton.setSelection(true);
    }

    private void resolveTags() {
        this.chipsContainer.clearChips();
        Optional tagsInPom = this.mavenDecorator.getTags();
        if (tagsInPom.isPresent()) {
            String[] splitTags;
            String[] stringArray = splitTags = StringEscapeUtils.unescapeXml((String)this.removeWhiteSpace((String)tagsInPom.get())).split(TAGS_SEPARATOR);
            int n = splitTags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag2 = stringArray[n2];
                this.chipsContainer.createNewChip(tag2);
                ++n2;
            }
        } else if (this.exchangeAsset != null && this.exchangeAsset.getLabels() != null) {
            this.exchangeAsset.getLabels().forEach(tag -> this.chipsContainer.createNewChip(tag));
        }
    }

    private String removeWhiteSpace(String tagsList) {
        return Arrays.stream(tagsList.split(TAGS_SEPARATOR)).map(String::trim).filter(Predicate.not(String::isEmpty)).collect(Collectors.joining(TAGS_SEPARATOR));
    }

    private void fillCategoriesTable() {
        this.categoriesTable.clearRows();
        Optional<List<AssetMetadataEditorConfiguration>> pomCategories = this.getCategoriesFromPom();
        List<AssetMetadataEditorConfiguration> rowConfigurations = pomCategories.isPresent() ? this.obtainValidCategories(pomCategories.get()) : this.loadAssetCategoriesFromExchange();
        this.categoriesTable.addRows(rowConfigurations, true);
    }

    private void fillCustomFieldsTable() {
        this.customFieldsTable.clearRows();
        Optional<List<AssetMetadataEditorConfiguration>> pomCustomFields = this.getCustomFieldsFromPom();
        List<AssetMetadataEditorConfiguration> customFieldsToDisplay = pomCustomFields.isPresent() ? this.obtainValidCustomFields(pomCustomFields.get()) : this.loadAssetCustomFieldsFromExchange();
        this.customFieldsTable.addRows(customFieldsToDisplay, true);
    }

    private List<AssetMetadataEditorConfiguration> obtainValidCustomFields(List<AssetMetadataEditorConfiguration> customFields) {
        ArrayList<String> invalidCustomFields = new ArrayList<String>();
        ArrayList<AssetMetadataEditorConfiguration> result = new ArrayList<AssetMetadataEditorConfiguration>();
        for (AssetMetadataEditorConfiguration customField : customFields) {
            if (this.isValidCustomField(customField.getId())) {
                result.add(customField);
                continue;
            }
            invalidCustomFields.add(customField.getId());
        }
        if (!invalidCustomFields.isEmpty()) {
            this.statusCustomFieldsMessage = INVALID_CUSTOM_FIELD_WARNING + String.join((CharSequence)", ", invalidCustomFields);
            this.setWarningMessage();
        }
        return result;
    }

    private boolean isValidCustomField(String customField) {
        return this.customFieldsTable.getTypesManager().getType(customField).isPresent();
    }

    private void setWarningMessage() {
        this.setMessage(Stream.of(this.statusCategoriesMessage, this.statusCustomFieldsMessage).filter(s -> StringUtils.isNotBlank((String)s)).collect(Collectors.joining(" - ")), 2);
    }

    private Optional<List<AssetMetadataEditorConfiguration>> getCustomFieldsFromPom() {
        List result;
        Optional customFieldsInPom = this.mavenDecorator.getCustomFields();
        if (customFieldsInPom.isEmpty()) {
            return Optional.empty();
        }
        if (((String)customFieldsInPom.get()).isBlank()) {
            return Optional.of(Collections.emptyList());
        }
        try {
            result = (List)this.assetMetadataEditorConfigurationMapper.readValue((String)customFieldsInPom.get(), (TypeReference)new TypeReference<List<AssetMetadataEditorConfiguration>>(){});
        }
        catch (JsonProcessingException jsonProcessingException) {
            this.statusCustomFieldsMessage = CUSTOM_FIELDS_BAD_FORMAT_WARNING_MESSAGE;
            this.setWarningMessage();
            result = Collections.emptyList();
        }
        return Optional.of(result);
    }

    private boolean isValidCategory(String category) {
        return this.categoriesTable.getTypesManager().getType(category).isPresent();
    }

    private List<AssetMetadataEditorConfiguration> obtainValidCategories(List<AssetMetadataEditorConfiguration> categories) {
        ArrayList<AssetMetadataEditorConfiguration> result = new ArrayList<AssetMetadataEditorConfiguration>();
        ArrayList<String> invalidCategories = new ArrayList<String>();
        for (AssetMetadataEditorConfiguration cat : categories) {
            if (this.isValidCategory(cat.getId())) {
                result.add(cat);
                continue;
            }
            invalidCategories.add(cat.getId());
        }
        if (!invalidCategories.isEmpty()) {
            this.statusCategoriesMessage = INVALID_CATEGORY_WARNING + String.join((CharSequence)", ", invalidCategories);
            this.setWarningMessage();
        }
        return result;
    }

    private List<AssetMetadataEditorConfiguration> loadAssetCategoriesFromExchange() {
        ArrayList<AssetMetadataEditorConfiguration> result = new ArrayList<AssetMetadataEditorConfiguration>();
        List exchangeCategories = this.exchangeAsset != null ? this.exchangeAsset.getCategories() : new ArrayList();
        for (ExchangeSchema.Category cat : exchangeCategories) {
            result.add(new AssetMetadataEditorConfiguration(cat.getKey(), cat.getValue()));
        }
        return result;
    }

    private List<AssetMetadataEditorConfiguration> loadAssetCustomFieldsFromExchange() {
        ArrayList<AssetMetadataEditorConfiguration> result = new ArrayList<AssetMetadataEditorConfiguration>();
        List exchangeCustomFields = this.exchangeAsset != null ? this.exchangeAsset.getCustomFields() : new ArrayList();
        for (ExchangeSchema.CustomFieldUnion customField : exchangeCustomFields) {
            switch (customField.getGraphQlTypeName()) {
                case "DateCustomField": {
                    ExchangeSchema.DateCustomField dateCustomField = (ExchangeSchema.DateCustomField)customField;
                    result.add(new AssetMetadataEditorConfiguration(dateCustomField.getKey(), dateCustomField.getDateValue()));
                    break;
                }
                case "EnumCustomField": {
                    ExchangeSchema.EnumCustomField enumCustomField = (ExchangeSchema.EnumCustomField)customField;
                    result.add(new AssetMetadataEditorConfiguration(enumCustomField.getKey(), enumCustomField.getEnumValue()));
                    break;
                }
                case "NumericCustomField": {
                    ExchangeSchema.NumericCustomField numericCustomField = (ExchangeSchema.NumericCustomField)customField;
                    result.add(new AssetMetadataEditorConfiguration(numericCustomField.getKey(), numericCustomField.getNumberValue().intValue()));
                    break;
                }
                case "NumericListCustomField": {
                    ExchangeSchema.NumericListCustomField numericListCustomField = (ExchangeSchema.NumericListCustomField)customField;
                    result.add(new AssetMetadataEditorConfiguration(numericListCustomField.getKey(), numericListCustomField.getNumberListValue().stream().map(value -> String.valueOf(value.intValue())).collect(Collectors.toList())));
                    break;
                }
                case "TextCustomField": {
                    ExchangeSchema.TextCustomField textCustomField = (ExchangeSchema.TextCustomField)customField;
                    result.add(new AssetMetadataEditorConfiguration(textCustomField.getKey(), textCustomField.getTextValue()));
                    break;
                }
                case "TextListCustomField": {
                    ExchangeSchema.TextListCustomField textListCustomField = (ExchangeSchema.TextListCustomField)customField;
                    result.add(new AssetMetadataEditorConfiguration(textListCustomField.getKey(), textListCustomField.getTextListValue()));
                    break;
                }
            }
        }
        return result;
    }

    private Optional<List<AssetMetadataEditorConfiguration>> getCategoriesFromPom() {
        List result;
        Optional categoriesInPom = this.mavenDecorator.getCategories();
        if (!categoriesInPom.isPresent()) {
            return Optional.empty();
        }
        if (((String)categoriesInPom.get()).isBlank()) {
            return Optional.of(Collections.emptyList());
        }
        try {
            result = (List)this.assetMetadataEditorConfigurationMapper.readValue((String)categoriesInPom.get(), (TypeReference)new TypeReference<List<AssetMetadataEditorConfiguration>>(){});
        }
        catch (JsonProcessingException jsonProcessingException) {
            this.statusCategoriesMessage = CATEGORIES_BAD_FORMAT_WARNING_MESSAGE;
            this.setWarningMessage();
            result = Collections.emptyList();
        }
        return Optional.of(result);
    }

    public void setExchangeAssetData(ExchangeAsset asset, AuthUser currentUser, String organizationId, ProjectType projectType) {
        this.exchangeAsset = asset;
        CategoriesTypesManager categoriesTypesManager = new CategoriesTypesManager(currentUser, organizationId, projectType);
        categoriesTypesManager.addCategoryEditorContentChangedListener(this::relayoutWizard);
        this.categoriesTable.setTypesManager((TypesManager)categoriesTypesManager);
        CustomFieldsTypesManager customFieldsTypesManager = new CustomFieldsTypesManager(currentUser, organizationId, projectType);
        customFieldsTypesManager.addCustomFieldEditorContentChangedListener(this::relayoutWizard);
        this.customFieldsTable.setTypesManager((TypesManager)customFieldsTypesManager);
    }

    public void saveChanges() {
        this.saveTagsToPom();
        this.saveCategoriesToPom();
        this.saveCustomFieldsToPom();
    }

    private void saveTagsToPom() {
        this.mavenDecorator.setTags(String.join((CharSequence)TAGS_SEPARATOR, this.chipsContainer.getChipsContents()));
    }

    private void saveCategoriesToPom() {
        HashMap<String, AssetMetadataEditorConfiguration> selectedCategories = new HashMap<String, AssetMetadataEditorConfiguration>();
        for (DynamicRow row : this.categoriesTable.getRows()) {
            AssetMetadataEditorConfiguration conf = (AssetMetadataEditorConfiguration)row.save();
            selectedCategories.put(conf.getId(), conf);
        }
        try {
            String categories = this.assetMetadataEditorConfigurationMapper.writeValueAsString(selectedCategories.values());
            this.mavenDecorator.setCategories(categories);
        }
        catch (JsonProcessingException e) {
            MuleCorePlugin.logError((String)SAVING_CATEGORIES_ERROR, (Throwable)e);
        }
    }

    private void saveCustomFieldsToPom() {
        HashMap<String, AssetMetadataEditorConfiguration> selectedCustomFields = new HashMap<String, AssetMetadataEditorConfiguration>();
        for (DynamicRow row : this.customFieldsTable.getRows()) {
            AssetMetadataEditorConfiguration conf = (AssetMetadataEditorConfiguration)row.save();
            selectedCustomFields.put(conf.getId(), conf);
        }
        try {
            String customFields = this.assetMetadataEditorConfigurationMapper.writeValueAsString(selectedCustomFields.values());
            this.mavenDecorator.setCustomFields(customFields);
        }
        catch (JsonProcessingException e) {
            MuleCorePlugin.logError((String)SAVING_CUSTOM_FIELDS_ERROR, (Throwable)e);
        }
    }

    public boolean isValid() {
        boolean isValid = true;
        for (DynamicRow row : this.categoriesTable.getRows()) {
            if (((IPublishToExchangeEditorValidator)row.getContent()).isValid()) continue;
            isValid = false;
        }
        for (DynamicRow row : this.customFieldsTable.getRows()) {
            if (((IPublishToExchangeEditorValidator)row.getContent()).isValid()) continue;
            isValid = false;
        }
        return isValid;
    }

    public int getAmountTags() {
        return this.chipsContainer.getChipsContents().size();
    }

    public int getAmountCategories() {
        return this.categoriesTable.getRows().size();
    }
}

