/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.core.auth.AuthUser;
import org.mule.tooling.core.auth.Organization;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.exchange.ExchangeAsset;
import org.mule.tooling.maven.MavenMuleProjectDecorator;
import org.mule.tooling.maven.ui.MavenInfoComponent;
import org.mule.tooling.ui.authentication.widgets.UserLoginStatusComponent;
import org.mule.tooling.ui.widgets.util.FormLayoutUtils;

public class PublishToExchangeWizardPageOne
extends WizardPage {
    private static final String INVALID_VERSION = "Invalid version. Semantic version expected. Example: 1.0.0";
    private static final String EMPTY_VALUES = "Some fields contains empty values";
    private static final String INVALID_PROJECT_TYPE = "Project type field is required";
    private static final String INVALID_PROJECT_TYPE_IS_NOT_THE_SAME = "Project type selected is not the same as in Exchange";
    private static final String INVALID_ARTIFACT_ID = "Invalid Artifact Id";
    private static final String BUSINESS_GROUP = "Business group";
    private static final String ADD_ACCOUNT = "Add account";
    private static final String USER = "User";
    private static final String PAGE_TITLE = "Publish to Exchange";
    private static final String ORG_MULE_TOOLING_EXCHANGE_PUBLISH = "org.mule.tooling.exchange.publish";
    private static final String PUBLISH_TO_EXCHANGE_TITLE = "Configure your project to publish it to Exchange";
    private final MavenMuleProjectDecorator mavenDecorator;
    private MavenInfoComponent mavenInfoComponent;
    private UserLoginStatusComponent userDataModule;

    public PublishToExchangeWizardPageOne(MavenMuleProjectDecorator mavenDecorator) {
        super(ORG_MULE_TOOLING_EXCHANGE_PUBLISH, PAGE_TITLE, null);
        this.mavenDecorator = mavenDecorator;
    }

    public void createControl(Composite parent) {
        this.setMessage(PUBLISH_TO_EXCHANGE_TITLE);
        Composite pageOneMainComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)pageOneMainComposite);
        pageOneMainComposite.setLayout((Layout)FormLayoutUtils.formLayout());
        this.userDataModule = UserLoginStatusComponent.createWithUserAndBusinessGroupSelector((String)USER, (String)ADD_ACCOUNT, (String)BUSINESS_GROUP, (String)PAGE_TITLE);
        Composite userComposite = this.userDataModule.createControl(pageOneMainComposite);
        FormLayoutUtils.attach((Control)userComposite).top().left(5).right(5);
        this.mavenInfoComponent = new MavenInfoComponent(this.mavenDecorator);
        Composite mavenInfoCompo = this.mavenInfoComponent.createComponents(pageOneMainComposite);
        FormLayoutUtils.attach((Control)mavenInfoCompo).topFrom((Control)userComposite, 5).left().right();
        this.setControl((Control)pageOneMainComposite);
        this.userDataModule.addBusinessGroupCustomListener(this.getBusinessGroupListener());
        this.initValidations();
    }

    private Consumer<Organization> getBusinessGroupListener() {
        return selectedOrganization -> {
            AuthUser activeUser = CoreUtils.getLoginManager().retrieveActiveAuthUser();
            this.mavenInfoComponent.updateGroupIdByExchange((Organization)selectedOrganization, activeUser);
            this.setValidationError(!this.mavenInfoComponent.hasExchangeError(), this.mavenInfoComponent.getExchangeErrorDescription());
            this.validateField();
        };
    }

    protected void initValidations() {
        this.validateField();
        this.setFieldValidations();
    }

    private void setValidationError(boolean valid, String errorDescription) {
        this.setPageComplete(valid);
        this.setErrorMessage(errorDescription);
    }

    private void setFieldValidations() {
        List<Text> componentsToCheck = Arrays.asList(this.mavenInfoComponent.getVersion(), this.mavenInfoComponent.getArtifactId(), this.mavenInfoComponent.getName());
        ModifyListener validateListener = event -> this.validateField();
        componentsToCheck.forEach(t -> t.addModifyListener(validateListener));
        this.mavenInfoComponent.getProjectTypeCombo().addSelectionChangedListener(event -> {
            this.mavenInfoComponent.validateSelectedProjectType();
            this.validateField();
        });
    }

    public AuthUser getCurrentUser() {
        return this.userDataModule.getCurrentUser();
    }

    public Organization getCurrentOrganization() {
        return this.userDataModule.getCurrentOrganization();
    }

    public Optional<File> getDeployablePom() {
        return this.mavenInfoComponent.getDeployableFile();
    }

    public String getArtifactId() {
        return this.mavenInfoComponent.getArtifactId().getText();
    }

    public String getGroupId() {
        return this.mavenInfoComponent.getGroupId().getText();
    }

    public MavenInfoComponent getMavenInfoComponent() {
        return this.mavenInfoComponent;
    }

    public void saveChanges() {
        this.mavenInfoComponent.saveChanges();
    }

    protected void validateField() {
        if (this.mavenInfoComponent.hasEmptyFields()) {
            this.setValidationError(false, EMPTY_VALUES);
            return;
        }
        if (!this.mavenInfoComponent.isValidSemVersion()) {
            this.setValidationError(false, INVALID_VERSION);
            return;
        }
        if (!this.mavenInfoComponent.hasProjectTypeSelected()) {
            this.setValidationError(false, INVALID_PROJECT_TYPE);
            return;
        }
        if (this.mavenInfoComponent.isSelectedProjectTypeDifferentAsInExchange()) {
            this.setValidationError(false, INVALID_PROJECT_TYPE_IS_NOT_THE_SAME);
            return;
        }
        if (this.mavenInfoComponent.isValidArtifactId()) {
            this.setValidationError(false, INVALID_ARTIFACT_ID);
            return;
        }
        if (this.mavenInfoComponent.hasExchangeError()) {
            this.setValidationError(false, this.mavenInfoComponent.getExchangeErrorDescription());
            return;
        }
        if (this.mavenInfoComponent.isSnapshotVersion()) {
            this.setValidationError(false, "SNAPSHOTS are not supported in Studio");
            this.mavenInfoComponent.setErrorSnapshotVersionIcon();
            return;
        }
        this.mavenInfoComponent.setInfoVersionIcon();
        this.setValidationError(true, null);
    }

    public void performHelp() {
        Program.launch((String)"https://docs.mulesoft.com/studio/latest/export-to-exchange-task");
    }

    public ExchangeAsset getExchangeAsset() {
        return this.mavenInfoComponent.getLatestExchangeAsset();
    }
}

