/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.auth.AuthUser;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.maven.ui.WorkspaceModuleDependencyController;
import org.mule.tooling.maven.ui.dependency.MuleModuleToUpdate;
import org.mule.tooling.maven.ui.exceptions.UnableToCheckForUpdatesException;
import org.mule.tooling.maven.ui.preferences.NotificationsPreferences;
import org.mule.tooling.ui.MuleImages;
import org.mule.tooling.ui.authentication.widgets.ActiveUserChangeListener;
import org.mule.tooling.ui.authentication.widgets.UserLoginStatusComponent;
import org.mule.tooling.ui.properties.IDependency;
import org.mule.tooling.ui.properties.dependencies.DependencyUtils;
import org.mule.tooling.ui.widgets.WidgetsImages;
import org.mule.tooling.ui.widgets.progress.bar.ProgressBarMonitor;

public class MuleModulesUpdateDialog
extends TitleAreaDialog {
    private static final Image CHECKBOX_CLEARED_IMAGE = WidgetsImages.getImage((String)"icons/checkboxcleared.gif");
    private static final Image CHECKBOX_GREYED_IMAGE = WidgetsImages.getImage((String)"icons/checkboxgreyed.gif");
    private static final Image CHECKBOX_SELECTED_IMAGE = WidgetsImages.getImage((String)"icons/checkboxselected.gif");
    private static final Image CHECKBOX_UNSELECTED_IMAGE = WidgetsImages.getImage((String)"icons/checkboxunselected.gif");
    private static final String DIALOG_DESCRIPTION = "Modules available to update. You will see the modules that you are declaring in your projects.";
    private static final String DIALOG_TITLE = "Manage Modules";
    private static final String DISCLAIMER_INFO_TEXT = "You can update your project modules later doing right click over the project > Manage Dependencies > Manage Modules";
    private static final String PREFERENCE_PAGE_LINK = "See the <a>Notifications Preference Page</a> to configure the table order and check other related preferences";
    private static final String PROGRESS_BAR_LABEL_ERROR = "An error occurred when looking for updates at Exchange. Please, try again later.";
    private static final String PROGRESS_BAR_LABEL_FETCHING_MODULES = "Fetching Mule Modules updates...";
    private static final String PROGRESS_BAR_LABEL_LOGIN_EXPIRED = "Table is only showing public Modules updates, if there are any. Please log in to check for updates of your private Modules.";
    private static final String PROGRESS_BAR_LABEL_UP_TO_DATE = "All your Mule Modules are up to date";
    private static final String WARNING_TEXT = "Updating to a new major version may generate conflicts in your project";
    private static final int MIN_COLUMN_SIZE = 50;
    private static final int SMALL_COLUMN_WEIGHT = 18;
    private static final int LARGE_COLUMN_WEIGHT = 23;
    private List<MuleModuleToUpdate> muleModulesToDisplay = new ArrayList<MuleModuleToUpdate>();
    private List<MuleModuleToUpdate> modulesToUpdateToLatestMinorPatchVersion = new ArrayList<MuleModuleToUpdate>();
    private List<MuleModuleToUpdate> modulesToUpdateToLatestVersion = new ArrayList<MuleModuleToUpdate>();
    private TableColumn latestVersionWithinMajorColumn;
    private TableColumn latestVersionColumn;
    private MuleModulesToUpdateFilter tableFilter;
    private Text filterText;
    private TableViewer tableViewer;
    private CLabel progressBarLabel;
    private ProgressBarMonitor progressBarMonitor;
    private Composite warningComposite;
    private Button okButton;
    private Composite userLoginComposite;
    private boolean projectsFirst;
    private boolean shouldFetchVersion;

    public MuleModulesUpdateDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.projectsFirst = NotificationsPreferences.getUpdatesDialogSortBy().equals("byProject");
    }

    public MuleModulesUpdateDialog(Shell parentShell, List<MuleModuleToUpdate> muleModulesToDisplay, boolean shouldFetchVersion) {
        this(parentShell);
        this.muleModulesToDisplay = muleModulesToDisplay;
        this.shouldFetchVersion = shouldFetchVersion;
    }

    protected Point getInitialSize() {
        return new Point(1090, 625);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.okButton = this.getButton(0);
        this.okButton.setText("Apply and close");
        this.okButton.setSize(118, 27);
        this.okButton.setEnabled(false);
        this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!MuleModulesUpdateDialog.this.modulesToUpdateToLatestMinorPatchVersion.isEmpty() || !MuleModulesUpdateDialog.this.modulesToUpdateToLatestVersion.isEmpty()) {
                    AnalyticsRecordsFactory.single((String)Events.MULE_MODULES_WITH_UPDATES).addMetadata("amount", String.valueOf(MuleModulesUpdateDialog.this.muleModulesToDisplay.size())).track();
                    AnalyticsRecordsFactory.single((String)Events.MULE_MODULES_UPDATED_WITHIN_MAJOR).addMetadata("percentage", String.valueOf(MuleModulesUpdateDialog.this.modulesToUpdateToLatestMinorPatchVersion.size() / MuleModulesUpdateDialog.this.muleModulesToDisplay.size())).track();
                    AnalyticsRecordsFactory.single((String)Events.MULE_MODULES_UPDATED_TO_LATEST).addMetadata("percentage", String.valueOf(MuleModulesUpdateDialog.this.modulesToUpdateToLatestVersion.size() / MuleModulesUpdateDialog.this.muleModulesToDisplay.size())).track();
                    WorkspaceModuleDependencyController.getInstance().updateMuleModulesToLatestPatchWithinMajorVersion(MuleModulesUpdateDialog.this.modulesToUpdateToLatestMinorPatchVersion);
                    WorkspaceModuleDependencyController.getInstance().updateMuleModulesToLatestVersion(MuleModulesUpdateDialog.this.modulesToUpdateToLatestVersion);
                }
            }
        });
        this.setButtonLayoutData(this.okButton);
    }

    public void create() {
        super.create();
        this.getShell().setMinimumSize(new Point(425, 425));
        this.getShell().setText(DIALOG_TITLE);
        this.setMessage(DIALOG_DESCRIPTION);
    }

    public boolean close() {
        this.progressBarMonitor.setCanceled(true);
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogComposite = (Composite)super.createDialogArea(parent);
        Composite dialogContentComposite = new Composite(dialogComposite, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)dialogContentComposite);
        GridLayoutFactory.swtDefaults().applyTo(dialogContentComposite);
        this.createAccountComposite(dialogContentComposite);
        this.createTableFilter(dialogContentComposite);
        this.createUpdatesTable(dialogContentComposite);
        this.createProgressBar(dialogContentComposite);
        this.createDisclaimerArea(dialogContentComposite);
        this.populateVersions();
        return dialogComposite;
    }

    private void createAccountComposite(Composite parent) {
        UserLoginStatusComponent userLoginComponent = UserLoginStatusComponent.createWithUserSelector((String)"Username", (String)"Add Account", (String)"Mule Modules update dialog");
        this.userLoginComposite = userLoginComponent.createControl(parent);
        userLoginComponent.addUserChangeListener(new ActiveUserChangeListener(){

            public void userSelected(AuthUser user) {
                this.clearTable();
                MuleModulesUpdateDialog.this.populateVersions();
            }

            public void tokenExpired() {
                this.clearTable();
                MuleModulesUpdateDialog.this.populateVersions();
            }

            public void notUserSelected() {
            }

            private void clearTable() {
                MuleModulesUpdateDialog.this.filterText.setText("");
                MuleModulesUpdateDialog.this.tableFilter.setSearchText("");
                MuleModulesUpdateDialog.this.muleModulesToDisplay.clear();
                MuleModulesUpdateDialog.this.modulesToUpdateToLatestMinorPatchVersion.clear();
                MuleModulesUpdateDialog.this.modulesToUpdateToLatestVersion.clear();
                MuleModulesUpdateDialog.this.checkIfApplyButtonShouldBeEnabled();
                MuleModulesUpdateDialog.this.checkIfWarningShouldBeShown();
                MuleModulesUpdateDialog.this.tableViewer.refresh();
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.userLoginComposite);
    }

    private void createTableFilter(Composite dialogContentComposite) {
        this.filterText = new Text(dialogContentComposite, 896);
        this.filterText.setMessage("Search in table");
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                MuleModulesUpdateDialog.this.tableFilter.setSearchText(MuleModulesUpdateDialog.this.filterText.getText());
                MuleModulesUpdateDialog.this.tableViewer.refresh();
            }
        });
        this.filterText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if ((0x100 & e.detail) != 0) {
                    MuleModulesUpdateDialog.this.tableFilter.setSearchText("");
                    MuleModulesUpdateDialog.this.tableViewer.refresh();
                }
            }
        });
        GridDataFactory.swtDefaults().align(1, 1).hint(200, 25).applyTo((Control)this.filterText);
        this.tableFilter = new MuleModulesToUpdateFilter();
    }

    private void createUpdatesTable(Composite parent) {
        Composite tableComposite = new Composite(parent, 0);
        GridDataFactory.swtDefaults().grab(true, true).align(4, 4).applyTo((Control)tableComposite);
        GridLayoutFactory.swtDefaults().applyTo(tableComposite);
        this.tableViewer = new TableViewer(tableComposite, 68100);
        this.createColumns(tableComposite);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.getTable().setEnabled(false);
        this.tableViewer.addFilter((ViewerFilter)this.tableFilter);
        this.addSelectAllListener();
    }

    private void createColumns(Composite tableComposite) {
        TableViewerColumn column2;
        TableViewerColumn column1;
        if (this.projectsFirst) {
            column1 = this.createTableViewerColumn("Project", Optional.empty(), true, false, (CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    MuleModuleToUpdate moduleToUpdate = (MuleModuleToUpdate)element;
                    return moduleToUpdate.getProject().getName();
                }
            });
            column2 = this.createTableViewerColumn("Module", Optional.empty(), true, false, (CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    MuleModuleToUpdate moduleToUpdate = (MuleModuleToUpdate)element;
                    return moduleToUpdate.getMuleModule().getName();
                }
            });
        } else {
            column1 = this.createTableViewerColumn("Module", Optional.empty(), true, false, (CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    MuleModuleToUpdate moduleToUpdate = (MuleModuleToUpdate)element;
                    return moduleToUpdate.getMuleModule().getName();
                }
            });
            column2 = this.createTableViewerColumn("Project", Optional.empty(), true, false, (CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    MuleModuleToUpdate moduleToUpdate = (MuleModuleToUpdate)element;
                    return moduleToUpdate.getProject().getName();
                }
            });
        }
        TableViewerColumn column3 = this.createTableViewerColumn("Current version", Optional.empty(), true, false, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                MuleModuleToUpdate moduleToUpdate = (MuleModuleToUpdate)element;
                return moduleToUpdate.getMuleModule().getVersion();
            }
        });
        TableViewerColumn column4 = this.createTableViewerColumn("Latest version in major", Optional.of(CHECKBOX_GREYED_IMAGE), true, false, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String latestPatchVersionWithinMajorVersion = DependencyUtils.getLatestVersionWithinMajorVersion((IDependency)((MuleModuleToUpdate)element).getMuleModule());
                return latestPatchVersionWithinMajorVersion.equals(((MuleModuleToUpdate)element).getMuleModule().getVersion()) ? "-----" : latestPatchVersionWithinMajorVersion;
            }

            public Image getImage(Object element) {
                if (MuleModulesUpdateDialog.this.modulesToUpdateToLatestMinorPatchVersion.contains(element)) {
                    return CHECKBOX_SELECTED_IMAGE;
                }
                String latestPatchVersionWithinMajorVersion = DependencyUtils.getLatestVersionWithinMajorVersion((IDependency)((MuleModuleToUpdate)element).getMuleModule());
                if (latestPatchVersionWithinMajorVersion.equals(((MuleModuleToUpdate)element).getMuleModule().getVersion())) {
                    return null;
                }
                return CHECKBOX_CLEARED_IMAGE;
            }
        });
        column4.setEditingSupport((EditingSupport)new UpdateToLatestMinorPatchVersionEditingSupport(this.tableViewer));
        this.latestVersionWithinMajorColumn = column4.getColumn();
        TableViewerColumn column5 = this.createTableViewerColumn("Latest version", Optional.of(CHECKBOX_GREYED_IMAGE), true, false, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return DependencyUtils.getLatestVersion((IDependency)((MuleModuleToUpdate)element).getMuleModule());
            }

            public Image getImage(Object element) {
                if (MuleModulesUpdateDialog.this.modulesToUpdateToLatestVersion.contains(element)) {
                    return CHECKBOX_SELECTED_IMAGE;
                }
                return CHECKBOX_CLEARED_IMAGE;
            }
        });
        column5.setEditingSupport((EditingSupport)new UpdateToLatestVersionEditingSupport(this.tableViewer));
        this.latestVersionColumn = column5.getColumn();
        TableColumnLayout tableLayout = new TableColumnLayout(true);
        tableLayout.setColumnData((Widget)column1.getColumn(), (ColumnLayoutData)new ColumnWeightData(23, 50));
        tableLayout.setColumnData((Widget)column2.getColumn(), (ColumnLayoutData)new ColumnWeightData(23, 50));
        tableLayout.setColumnData((Widget)column3.getColumn(), (ColumnLayoutData)new ColumnWeightData(18, 50));
        tableLayout.setColumnData((Widget)this.latestVersionWithinMajorColumn, (ColumnLayoutData)new ColumnWeightData(18, 50));
        tableLayout.setColumnData((Widget)this.latestVersionColumn, (ColumnLayoutData)new ColumnWeightData(18, 50));
        tableComposite.setLayout((Layout)tableLayout);
    }

    private TableViewerColumn createTableViewerColumn(String headerName, Optional<Image> headerImage, boolean isResizable, boolean isMoveable, CellLabelProvider labelProvider) {
        TableViewerColumn columnViewer = new TableViewerColumn(this.tableViewer, 16384);
        TableColumn column = columnViewer.getColumn();
        column.setText(headerName);
        if (headerImage.isPresent()) {
            column.setImage(headerImage.get());
        }
        column.setResizable(isResizable);
        column.setMoveable(isMoveable);
        columnViewer.setLabelProvider(labelProvider);
        return columnViewer;
    }

    private void addSelectAllListener() {
        this.latestVersionWithinMajorColumn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                List<MuleModuleToUpdate> filteredModules = Arrays.stream(MuleModulesUpdateDialog.this.tableViewer.getTable().getItems()).map(item -> (MuleModuleToUpdate)item.getData()).collect(Collectors.toList());
                List<MuleModuleToUpdate> filteredModulesUpdatedWIthinMajor = MuleModulesUpdateDialog.this.filterModulesUpdatedWithinMajor(filteredModules);
                boolean thereAreItemsUnselected = !MuleModulesUpdateDialog.this.modulesToUpdateToLatestMinorPatchVersion.containsAll(filteredModulesUpdatedWIthinMajor);
                MuleModulesUpdateDialog.this.modulesToUpdateToLatestMinorPatchVersion.removeAll(filteredModulesUpdatedWIthinMajor);
                if (thereAreItemsUnselected) {
                    MuleModulesUpdateDialog.this.modulesToUpdateToLatestMinorPatchVersion.addAll(filteredModulesUpdatedWIthinMajor);
                    MuleModulesUpdateDialog.this.modulesToUpdateToLatestVersion.removeAll(filteredModulesUpdatedWIthinMajor);
                }
                MuleModulesUpdateDialog.this.updateColumnHeadersImages();
                MuleModulesUpdateDialog.this.checkIfApplyButtonShouldBeEnabled();
                MuleModulesUpdateDialog.this.checkIfWarningShouldBeShown();
                MuleModulesUpdateDialog.this.tableViewer.refresh();
            }
        });
        this.latestVersionColumn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                List filteredModules = Arrays.stream(MuleModulesUpdateDialog.this.tableViewer.getTable().getItems()).map(item -> (MuleModuleToUpdate)item.getData()).collect(Collectors.toList());
                boolean thereAreItemsUnselected = !MuleModulesUpdateDialog.this.modulesToUpdateToLatestVersion.containsAll(filteredModules);
                MuleModulesUpdateDialog.this.modulesToUpdateToLatestVersion.removeAll(filteredModules);
                if (thereAreItemsUnselected) {
                    MuleModulesUpdateDialog.this.modulesToUpdateToLatestVersion.addAll(filteredModules);
                    MuleModulesUpdateDialog.this.modulesToUpdateToLatestMinorPatchVersion.removeAll(filteredModules);
                }
                MuleModulesUpdateDialog.this.updateColumnHeadersImages();
                MuleModulesUpdateDialog.this.checkIfApplyButtonShouldBeEnabled();
                MuleModulesUpdateDialog.this.checkIfWarningShouldBeShown();
                MuleModulesUpdateDialog.this.tableViewer.refresh();
            }
        });
    }

    private List<MuleModuleToUpdate> filterModulesUpdatedWithinMajor(List<MuleModuleToUpdate> listToBeFiltered) {
        return listToBeFiltered.stream().filter(muleModuleToDisplay -> !DependencyUtils.getLatestVersionWithinMajorVersion((IDependency)muleModuleToDisplay.getMuleModule()).equals(muleModuleToDisplay.getMuleModule().getVersion())).collect(Collectors.toList());
    }

    private void createProgressBar(Composite parent) {
        Composite progresBarComposite = new Composite(parent, 0);
        GridDataFactory.swtDefaults().grab(true, false).align(4, 0x1000008).applyTo((Control)progresBarComposite);
        GridLayoutFactory.swtDefaults().applyTo(progresBarComposite);
        this.progressBarLabel = new CLabel(progresBarComposite, 0);
        this.progressBarLabel.setText(PROGRESS_BAR_LABEL_FETCHING_MODULES);
        GridDataFactory.swtDefaults().grab(true, false).align(0x1000000, 1).applyTo((Control)this.progressBarLabel);
        ProgressBar progressBar = new ProgressBar(progresBarComposite, 0);
        GridDataFactory.swtDefaults().grab(true, false).align(4, 1).applyTo((Control)progressBar);
        this.progressBarMonitor = new ProgressBarMonitor(progressBar);
    }

    private void createDisclaimerArea(Composite parent) {
        Composite disclaimerComposite = new Composite(parent, 0);
        GridDataFactory.swtDefaults().grab(true, false).align(4, 0x1000008).applyTo((Control)disclaimerComposite);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(disclaimerComposite);
        Label separator = new Label(disclaimerComposite, 258);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)separator);
        this.warningComposite = new Composite(disclaimerComposite, 0);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.warningComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.warningComposite);
        this.warningComposite.setVisible(false);
        Label warningImage = new Label(this.warningComposite, 0);
        warningImage.setImage(MuleImages.WARN_EDITOR_IMAGE);
        Label warningMessage = new Label(this.warningComposite, 64);
        warningMessage.setText(WARNING_TEXT);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)warningMessage);
        Label disclaimerImage = new Label(disclaimerComposite, 0);
        disclaimerImage.setImage(MuleImages.IMG_INFO);
        Label disclaimerMessage = new Label(disclaimerComposite, 64);
        disclaimerMessage.setText(DISCLAIMER_INFO_TEXT);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)disclaimerMessage);
        Link openPreferencePage = new Link(disclaimerComposite, 0);
        openPreferencePage.setText(PREFERENCE_PAGE_LINK);
        openPreferencePage.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> NotificationsPreferences.openPreferencePage(this.getShell())));
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)openPreferencePage);
    }

    private void populateVersions() {
        if (CoreUtils.getLoginManager().retrieveActiveAuthUser() == null || CoreUtils.getLoginManager().isTokenValid().succeeded()) {
            final boolean isUserSessionExpired = (Boolean)CoreUtils.getLoginManager().isTokenValid().getResult() == false;
            this.setProgressBarLabel(null, PROGRESS_BAR_LABEL_FETCHING_MODULES);
            this.progressBarLabel.setVisible(true);
            this.filterText.setEnabled(false);
            this.tableViewer.getTable().setEnabled(false);
            this.userLoginComposite.setEnabled(false);
            Job job = new Job(PROGRESS_BAR_LABEL_FETCHING_MODULES){

                protected IStatus run(IProgressMonitor monitor) {
                    MuleModulesUpdateDialog.this.progressBarMonitor.beginTask(MuleModulesUpdateDialog.PROGRESS_BAR_LABEL_FETCHING_MODULES, 100);
                    if (MuleModulesUpdateDialog.this.muleModulesToDisplay.isEmpty()) {
                        try {
                            MuleModulesUpdateDialog.this.muleModulesToDisplay.addAll(WorkspaceModuleDependencyController.getInstance().getAvailableMuleModulesUpdates((IProgressMonitor)MuleModulesUpdateDialog.this.progressBarMonitor));
                        }
                        catch (CoreException e) {
                            MuleCorePlugin.logError((String)"Mule projects modules couldn't be collected", (Throwable)e);
                        }
                        catch (UnableToCheckForUpdatesException e) {
                            MuleCorePlugin.logError((String)"There was a problem checking for Mule modules updates from Exchange.", (Throwable)e);
                        }
                    } else if (!MuleModulesUpdateDialog.this.shouldFetchVersion) {
                        MuleModulesUpdateDialog.this.progressBarMonitor.worked(50);
                        MuleModulesUpdateDialog.this.muleModulesToDisplay = WorkspaceModuleDependencyController.getInstance().updateMuleModulesVersionsToDisplay(MuleModulesUpdateDialog.this.muleModulesToDisplay);
                        MuleModulesUpdateDialog.this.progressBarMonitor.done();
                    }
                    if (MuleModulesUpdateDialog.this.progressBarMonitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    Display.getDefault().asyncExec(() -> {
                        MuleModulesUpdateDialog.this.sortDependencies();
                        MuleModulesUpdateDialog.this.filterText.setEnabled(true);
                        MuleModulesUpdateDialog.this.tableViewer.setInput(MuleModulesUpdateDialog.this.muleModulesToDisplay);
                        MuleModulesUpdateDialog.this.tableViewer.getTable().setEnabled(true);
                        MuleModulesUpdateDialog.this.latestVersionWithinMajorColumn.setImage(CHECKBOX_CLEARED_IMAGE);
                        MuleModulesUpdateDialog.this.latestVersionColumn.setImage(CHECKBOX_CLEARED_IMAGE);
                        if (isUserSessionExpired) {
                            MuleModulesUpdateDialog.this.setProgressBarLabel(MuleImages.WARN_EDITOR_IMAGE, MuleModulesUpdateDialog.PROGRESS_BAR_LABEL_LOGIN_EXPIRED);
                        } else if (MuleModulesUpdateDialog.this.muleModulesToDisplay.isEmpty()) {
                            MuleModulesUpdateDialog.this.setProgressBarLabel(null, MuleModulesUpdateDialog.PROGRESS_BAR_LABEL_UP_TO_DATE);
                        } else {
                            MuleModulesUpdateDialog.this.progressBarLabel.setVisible(false);
                        }
                        MuleModulesUpdateDialog.this.userLoginComposite.setEnabled(true);
                    });
                    return Status.OK_STATUS;
                }
            };
            this.progressBarMonitor.addJob(job);
            job.setUser(true);
            job.setPriority(10);
            job.schedule();
        } else {
            this.progressBarMonitor.done();
            this.setProgressBarLabel(MuleImages.IMG_ERROR, PROGRESS_BAR_LABEL_ERROR);
        }
    }

    private void setProgressBarLabel(Image image, String text) {
        this.progressBarLabel.setImage(image);
        this.progressBarLabel.setText(text);
        this.progressBarLabel.getParent().layout();
    }

    private void sortDependencies() {
        this.muleModulesToDisplay.sort((lhs, rhs) -> {
            int compareResult;
            int n = compareResult = this.projectsFirst ? lhs.getProject().getName().compareTo(rhs.getProject().getName()) : lhs.getMuleModule().getName().compareTo(rhs.getMuleModule().getName());
            if (compareResult == 0) {
                compareResult = this.projectsFirst ? lhs.getMuleModule().getName().compareTo(rhs.getMuleModule().getName()) : lhs.getProject().getName().compareTo(rhs.getProject().getName());
            }
            return compareResult;
        });
    }

    private void updateColumnHeadersImages() {
        if (this.modulesToUpdateToLatestMinorPatchVersion.isEmpty()) {
            this.latestVersionWithinMajorColumn.setImage(CHECKBOX_CLEARED_IMAGE);
        } else if (this.modulesToUpdateToLatestMinorPatchVersion.size() == this.filterModulesUpdatedWithinMajor(this.muleModulesToDisplay).size()) {
            this.latestVersionWithinMajorColumn.setImage(CHECKBOX_SELECTED_IMAGE);
        } else {
            this.latestVersionWithinMajorColumn.setImage(CHECKBOX_UNSELECTED_IMAGE);
        }
        if (this.modulesToUpdateToLatestVersion.isEmpty()) {
            this.latestVersionColumn.setImage(CHECKBOX_CLEARED_IMAGE);
        } else if (this.modulesToUpdateToLatestVersion.size() == this.muleModulesToDisplay.size()) {
            this.latestVersionColumn.setImage(CHECKBOX_SELECTED_IMAGE);
        } else {
            this.latestVersionColumn.setImage(CHECKBOX_UNSELECTED_IMAGE);
        }
    }

    private void checkIfApplyButtonShouldBeEnabled() {
        this.okButton.setEnabled(!this.modulesToUpdateToLatestMinorPatchVersion.isEmpty() || !this.modulesToUpdateToLatestVersion.isEmpty());
    }

    private void checkIfWarningShouldBeShown() {
        for (MuleModuleToUpdate muleModule : this.modulesToUpdateToLatestVersion) {
            if (DependencyUtils.areSameMajor((String)muleModule.getMuleModule().getVersion(), (String)DependencyUtils.getLatestVersion((IDependency)muleModule.getMuleModule()))) continue;
            this.warningComposite.setVisible(true);
            return;
        }
        this.warningComposite.setVisible(false);
    }

    private class MuleModulesToUpdateFilter
    extends ViewerFilter {
        private String searchString;

        private MuleModulesToUpdateFilter() {
        }

        public void setSearchText(String s) {
            this.searchString = ".*" + s.toLowerCase() + ".*";
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.searchString == null || this.searchString.length() == 0) {
                return true;
            }
            MuleModuleToUpdate module = (MuleModuleToUpdate)element;
            return module.getProject().getName().toLowerCase().matches(this.searchString) || module.getMuleModule().getName().toLowerCase().matches(this.searchString);
        }
    }

    private class UpdateToLatestMinorPatchVersionEditingSupport
    extends EditingSupport {
        private final TableViewer viewer;

        public UpdateToLatestMinorPatchVersionEditingSupport(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.viewer = viewer;
        }

        protected CellEditor getCellEditor(Object element) {
            return new CheckboxCellEditor(null, 40);
        }

        protected boolean canEdit(Object element) {
            IDependency dep = ((MuleModuleToUpdate)element).getMuleModule();
            return !DependencyUtils.getLatestVersionWithinMajorVersion((IDependency)dep).equals(dep.getVersion());
        }

        protected Object getValue(Object element) {
            return MuleModulesUpdateDialog.this.modulesToUpdateToLatestMinorPatchVersion.contains(element);
        }

        protected void setValue(Object element, Object value) {
            if (((Boolean)value).booleanValue()) {
                MuleModulesUpdateDialog.this.modulesToUpdateToLatestMinorPatchVersion.add((MuleModuleToUpdate)element);
                if (MuleModulesUpdateDialog.this.modulesToUpdateToLatestVersion.contains(element)) {
                    MuleModulesUpdateDialog.this.modulesToUpdateToLatestVersion.remove(element);
                }
            } else {
                MuleModulesUpdateDialog.this.modulesToUpdateToLatestMinorPatchVersion.remove(element);
            }
            MuleModulesUpdateDialog.this.updateColumnHeadersImages();
            MuleModulesUpdateDialog.this.checkIfApplyButtonShouldBeEnabled();
            MuleModulesUpdateDialog.this.checkIfWarningShouldBeShown();
            this.viewer.update(element, null);
        }
    }

    private class UpdateToLatestVersionEditingSupport
    extends EditingSupport {
        private final TableViewer viewer;

        public UpdateToLatestVersionEditingSupport(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.viewer = viewer;
        }

        protected CellEditor getCellEditor(Object element) {
            return new CheckboxCellEditor(null, 40);
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            return MuleModulesUpdateDialog.this.modulesToUpdateToLatestVersion.contains(element);
        }

        protected void setValue(Object element, Object value) {
            if (((Boolean)value).booleanValue()) {
                MuleModulesUpdateDialog.this.modulesToUpdateToLatestVersion.add((MuleModuleToUpdate)element);
                if (MuleModulesUpdateDialog.this.modulesToUpdateToLatestMinorPatchVersion.contains(element)) {
                    MuleModulesUpdateDialog.this.modulesToUpdateToLatestMinorPatchVersion.remove(element);
                }
            } else {
                MuleModulesUpdateDialog.this.modulesToUpdateToLatestVersion.remove(element);
            }
            MuleModulesUpdateDialog.this.updateColumnHeadersImages();
            MuleModulesUpdateDialog.this.checkIfApplyButtonShouldBeEnabled();
            MuleModulesUpdateDialog.this.checkIfWarningShouldBeShown();
            this.viewer.update(element, null);
        }
    }
}

