/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.maven.ui.MuleModulesUpdateDialog;
import org.mule.tooling.maven.ui.dependency.MuleModuleToUpdate;
import org.mule.tooling.ui.widgets.notification.AbstractNotificationPopup;
import org.mule.tooling.ui.widgets.util.FormLayoutUtils;
import org.mule.tooling.ui.widgets.util.ThemeUtils;

public class MuleModuleNotificationPopup
extends AbstractNotificationPopup {
    private static final String MODULE_UPDATES_NOTIFICATION_CSS_CLASS_ID = "org-mule-tooling-maven-ui-MuleModuleNotificationPopup";
    private static final String POPUP_TITLE = "Module updates available";
    private static final String POPUP_MESSAGE = "Review and update modules used in your projects.";
    private List<MuleModuleToUpdate> fetchedUpdates = new ArrayList<MuleModuleToUpdate>();

    public MuleModuleNotificationPopup(List<MuleModuleToUpdate> fetchedUpdates) {
        this.setDelayClose(0L);
        this.fetchedUpdates = fetchedUpdates;
    }

    protected void createContentArea(Composite parent) {
        this.getShell().setText(POPUP_TITLE);
        GridLayoutFactory.fillDefaults().applyTo(parent);
        parent.setLayout((Layout)FormLayoutUtils.formLayout());
        Label message = new Label(parent, 0);
        message.setText(POPUP_MESSAGE);
        FormLayoutUtils.attach((Control)message).top(5).left(7).right(7);
        ToolBar toolBar = new ToolBar(parent, 0x800000);
        this.createButton(toolBar, "Close", new Runnable(){

            @Override
            public void run() {
                AnalyticsRecordsFactory.single((String)Events.MULE_MODULES_UPDATES_NOTIFICATION_CLOSED).track();
                MuleModuleNotificationPopup.this.close();
                MuleModuleNotificationPopup.this.setReturnCode(1);
            }
        });
        this.createButton(toolBar, "Manage Modules", new Runnable(){

            @Override
            public void run() {
                AnalyticsRecordsFactory.single((String)Events.MULE_MODULES_UPDATE_DIALOG_OPENED).addMetadata("origin", "notification").track();
                MuleModuleNotificationPopup.this.close();
                MuleModuleNotificationPopup.this.setReturnCode(0);
                new MuleModulesUpdateDialog(Display.getDefault().getActiveShell(), MuleModuleNotificationPopup.this.fetchedUpdates, true).open();
            }
        });
        FormLayoutUtils.attach((Control)toolBar).topFrom((Control)message, 5).right(7);
        ThemeUtils.setCssClassAndId((Object)this.getShell(), (String)MODULE_UPDATES_NOTIFICATION_CSS_CLASS_ID, (String)MODULE_UPDATES_NOTIFICATION_CSS_CLASS_ID);
    }

    private void createButton(ToolBar toolBar, String buttonText, final Runnable action) {
        ToolItem item = new ToolItem(toolBar, 0x800000);
        toolBar.setForeground(ThemeUtils.getCurrentTheme().getNotificationToolItemForegroundColor());
        item.setText(buttonText);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                action.run();
            }
        });
    }

    protected String getPopupShellTitle() {
        return POPUP_TITLE;
    }

    protected void createTitleBarImage(Composite parent) {
    }

    protected void createTitleBarButtons(Composite parent) {
    }

    public int open() {
        AnalyticsRecordsFactory.single((String)Events.MULE_MODULES_UPDATES_NOTIFICATION_OPENED).track();
        return super.open();
    }
}

