/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.classloader.ProjectClasspathUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;

public class MuleArtifactJavaSpecificationsUpdater
implements IElementChangedListener {
    private Map<IJavaProject, IClasspathEntry[]> projectClasspathMap = new HashMap<IJavaProject, IClasspathEntry[]>();
    private static String ARTIFACT_JAVA_PROPERTY_NAME = "javaSpecificationVersions";

    public void elementChanged(ElementChangedEvent event) {
        IJavaElementDelta delta = event.getDelta();
        try {
            this.processDelta(delta);
        }
        catch (JavaModelException e) {
            MuleCorePlugin.logError((String)("There was an error while processing a Java event: \n" + delta.toString()), (Throwable)e);
        }
    }

    private void processDelta(IJavaElementDelta delta) throws JavaModelException {
        if (this.hasFlag(delta, 2228672)) {
            IJavaProject project;
            IJavaElement changedElement = delta.getElement();
            if (changedElement.getJavaProject() instanceof IJavaProject && this.jreVersionHasChanged(project = changedElement.getJavaProject())) {
                try {
                    this.handleJreChange(project);
                }
                catch (IOException | CoreException e) {
                    MuleCorePlugin.logError((String)("There was a problem updating the java specification versions for project " + project.getProject().getName()), (Throwable)e);
                }
            }
        } else if (this.hasFlag(delta, 8)) {
            this.processChildren(delta);
        }
    }

    private void processChildren(IJavaElementDelta delta) throws JavaModelException {
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta childDelta = iJavaElementDeltaArray[n2];
            this.processDelta(childDelta);
            ++n2;
        }
    }

    private void handleJreChange(IJavaProject javaProject) throws IOException, CoreException {
        IMuleProject muleProject = MuleRuntime.create((IProject)javaProject.getProject());
        String[] newVersion = new String[]{ProjectClasspathUtils.getShortJavaVersion((IJavaProject)muleProject.getJavaProject())};
        CoreUtils.updateFieldInMuleArtifactJson((File)muleProject.getMuleArtifactFile().getLocation().toFile(), (String)ARTIFACT_JAVA_PROPERTY_NAME, (Object)newVersion);
    }

    private boolean wasAClasspathChange(IJavaElementDelta delta) {
        int deltaFlags = delta.getFlags();
        return (deltaFlags & 0x200000) != 0 && (deltaFlags & 0xC0) == 0;
    }

    private boolean jreVersionHasChanged(IJavaProject javaProject) {
        block3: {
            IClasspathEntry[] classpathEntries;
            block4: {
                Optional<IClasspathEntry> newJreEntry;
                Optional<IClasspathEntry> oldJreEntry;
                if (javaProject == null) break block3;
                classpathEntries = javaProject.getRawClasspath();
                if (!this.classpathEntriesChanged(this.projectClasspathMap.get(javaProject), classpathEntries) || Objects.equals(oldJreEntry = this.findJreEntry(this.projectClasspathMap.get(javaProject)), newJreEntry = this.findJreEntry(classpathEntries))) break block4;
                return true;
            }
            try {
                this.projectClasspathMap.put(javaProject, classpathEntries);
            }
            catch (JavaModelException e) {
                MuleCorePlugin.logError((String)"There was a problem obtaining the extension in the project from delta", (Throwable)e);
            }
        }
        return false;
    }

    private boolean hasFlag(IJavaElementDelta delta, int flag) {
        return (delta.getFlags() & flag) != 0;
    }

    private boolean classpathEntriesChanged(IClasspathEntry[] oldEntries, IClasspathEntry[] newEntries) {
        return oldEntries != null && !Arrays.equals(oldEntries, newEntries);
    }

    private Optional<IClasspathEntry> findJreEntry(IClasspathEntry[] classpathEntries) {
        if (classpathEntries != null) {
            IClasspathEntry[] iClasspathEntryArray = classpathEntries;
            int n = classpathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 5 && JavaRuntime.JRE_CONTAINER.equals(entry.getPath().segment(0))) {
                    return Optional.of(entry);
                }
                ++n2;
            }
        }
        return Optional.empty();
    }
}

