/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.maven.runner.MavenBinarySearcher;
import org.mule.tooling.maven.ui.JreUpdateConnectorEvent;
import org.mule.tooling.maven.ui.MavenPluginExecutionRules;
import org.mule.tooling.maven.ui.MuleArtifactJavaSpecificationsUpdater;
import org.mule.tooling.maven.ui.preferences.MavenPreferences;
import org.mule.tooling.ui.utils.UiUtils;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public class MavenUIPlugin
extends AbstractUIPlugin {
    public static final String DIALOG_DEFAULT_TITLE = "Maven Support";
    public static final String MAVEN_OUTPUT_CONSOLE_NAME = "Maven Output";
    private static final String MAVEN_PREFERENCE_MAVEN_OPTS = "maven_preference_maven_opts";
    private static final String MAVEN_PREFERENCE_BASE_CMDLINE = "maven_preference_base_cmdline";
    private static final String MAVEN_PREFERENCE_DEFAULT_GROUPID = "maven_preference_default_groupid";
    private static final String MAVEN_PREFERENCE_DONT_WARN_IF_NO_INSTALLATION_FOUND = "maven_preference_dont_warn_no_installation_found";
    private static final String MAVEN_PREFERENCE_RUNTIME_VERSION_WARNING = "maven_preference_runtime_version_warning";
    private static final String MAVEN_PREFERENCE_GLOBAL_SETTINGS_PATH = "maven_preference_global_settings_path";
    private static final String MAVEN_PREFERENCE_GLOBAL_SETTINGS_OVERRIDE = "maven_preference_global_settings_override";
    private static final String MAVEN_PREFERENCE_USER_SETTINGS_PATH = "maven_preference_user_settings_path";
    private static final String MAVEN_PREFERENCE_USER_SETTINGS_OVERRIDE = "maven_preference_user_settings_override";
    public static final String PLUGIN_ID = "org.mule.tooling.maven.ui";
    private static MavenUIPlugin plugin;
    private MavenPreferences mavenPreferences;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        JavaCore.addElementChangedListener((IElementChangedListener)new JreUpdateConnectorEvent());
        JavaCore.addElementChangedListener((IElementChangedListener)new MuleArtifactJavaSpecificationsUpdater());
        this.mavenPreferences = MavenPreferences.newInstance(this.getPreferenceStore());
        this.resolveOldProperties();
        this.validateMavenBinary();
    }

    public IPreferenceStore getPreferenceStore() {
        return MuleCorePlugin.getScopedPreferenceStore();
    }

    private void validateMavenBinary() {
        String mavenInstallationHome = this.mavenPreferences.getMavenInstallationHome();
        mavenInstallationHome = mavenInstallationHome == null ? "" : mavenInstallationHome;
    }

    private void resolveOldProperties() {
        DefaultScope.INSTANCE.getNode(PLUGIN_ID);
        IEclipsePreferences mavenPreferencesUI = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        ScopedPreferenceStore mavenPreferencesCore = (ScopedPreferenceStore)this.getPreferenceStore();
        if (mavenPreferencesUI.get(MAVEN_PREFERENCE_MAVEN_OPTS, null) != null) {
            mavenPreferencesCore.setValue("mule_core_plugin_preference_maven_opts", mavenPreferencesUI.get(MAVEN_PREFERENCE_MAVEN_OPTS, ""));
            this.deletePreference(mavenPreferencesUI, MAVEN_PREFERENCE_MAVEN_OPTS);
        }
        if (mavenPreferencesUI.get(MAVEN_PREFERENCE_BASE_CMDLINE, null) != null) {
            mavenPreferencesCore.setValue("mule_core_plugin_preference_maven_base_cmdline", mavenPreferencesUI.get(MAVEN_PREFERENCE_BASE_CMDLINE, ""));
            this.deletePreference(mavenPreferencesUI, MAVEN_PREFERENCE_BASE_CMDLINE);
        }
        if (mavenPreferencesUI.get(MAVEN_PREFERENCE_DEFAULT_GROUPID, null) != null) {
            mavenPreferencesCore.setValue("mule_core_plugin_preference_maven_default_groupid", mavenPreferencesUI.get(MAVEN_PREFERENCE_DEFAULT_GROUPID, ""));
            this.deletePreference(mavenPreferencesUI, MAVEN_PREFERENCE_DEFAULT_GROUPID);
        }
        if (mavenPreferencesUI.get(MAVEN_PREFERENCE_DONT_WARN_IF_NO_INSTALLATION_FOUND, null) != null) {
            mavenPreferencesCore.setValue("mule_core_plugin_preference_dont_warn_no_installation_found", mavenPreferencesUI.getBoolean(MAVEN_PREFERENCE_DONT_WARN_IF_NO_INSTALLATION_FOUND, false));
            this.deletePreference(mavenPreferencesUI, MAVEN_PREFERENCE_DONT_WARN_IF_NO_INSTALLATION_FOUND);
        }
        if (mavenPreferencesUI.get(MAVEN_PREFERENCE_RUNTIME_VERSION_WARNING, null) != null) {
            mavenPreferencesCore.setValue("mule_core_plugin_preference_maven_runtime_version_warning", mavenPreferencesUI.getBoolean(MAVEN_PREFERENCE_RUNTIME_VERSION_WARNING, false));
            this.deletePreference(mavenPreferencesUI, MAVEN_PREFERENCE_RUNTIME_VERSION_WARNING);
        }
        if (mavenPreferencesUI.get(MAVEN_PREFERENCE_GLOBAL_SETTINGS_PATH, null) != null) {
            mavenPreferencesCore.setValue("mule_core_plugin_preference_maven_override_global_settings_path", mavenPreferencesUI.get(MAVEN_PREFERENCE_GLOBAL_SETTINGS_PATH, ""));
            this.deletePreference(mavenPreferencesUI, MAVEN_PREFERENCE_GLOBAL_SETTINGS_PATH);
        }
        if (mavenPreferencesUI.get(MAVEN_PREFERENCE_GLOBAL_SETTINGS_OVERRIDE, null) != null) {
            mavenPreferencesCore.setValue("mule_core_plugin_preference_maven_override_global_settings", mavenPreferencesUI.getBoolean(MAVEN_PREFERENCE_GLOBAL_SETTINGS_OVERRIDE, false));
            this.deletePreference(mavenPreferencesUI, MAVEN_PREFERENCE_GLOBAL_SETTINGS_OVERRIDE);
        }
        if (mavenPreferencesUI.get(MAVEN_PREFERENCE_USER_SETTINGS_PATH, null) != null) {
            mavenPreferencesCore.setValue("mule_core_plugin_preference_maven_override_user_settings_path", mavenPreferencesUI.get(MAVEN_PREFERENCE_USER_SETTINGS_PATH, ""));
            this.deletePreference(mavenPreferencesUI, MAVEN_PREFERENCE_USER_SETTINGS_PATH);
        }
        if (mavenPreferencesUI.get(MAVEN_PREFERENCE_USER_SETTINGS_OVERRIDE, null) != null) {
            mavenPreferencesCore.setValue("mule_core_plugin_preference_maven_override_user_settings", mavenPreferencesUI.get(MAVEN_PREFERENCE_USER_SETTINGS_OVERRIDE, ""));
            this.deletePreference(mavenPreferencesUI, MAVEN_PREFERENCE_USER_SETTINGS_OVERRIDE);
        }
        try {
            mavenPreferencesUI.flush();
        }
        catch (BackingStoreException e) {
            MuleCorePlugin.logError((String)"Could not delete maven.ui preference", (Throwable)e);
        }
        try {
            mavenPreferencesCore.save();
        }
        catch (IOException e) {
            MuleCorePlugin.logError((String)"Could not save maven core preference", (Throwable)e);
        }
    }

    private void deletePreference(IEclipsePreferences mavenPreferencesUI, String preference) {
        mavenPreferencesUI.remove(preference);
    }

    public boolean isMavenBinaryValid(String mavenInstallationHome) {
        boolean mavenBinaryValid = false;
        File binDirectory = new File(mavenInstallationHome, "bin");
        List mavenBinaryFilenames = MavenBinarySearcher.newInstance().getMavenBinaryFilenames();
        for (String mavenBinaryFilename : mavenBinaryFilenames) {
            if (mavenBinaryValid) continue;
            mavenBinaryValid = this.isMavenBinaryValid(binDirectory, mavenBinaryFilename);
        }
        return mavenBinaryValid;
    }

    private boolean isMavenBinaryValid(File binDirectory, String mavenBinaryFilename) {
        boolean mavenBinaryValid;
        File mavenBinaryFile = new File(binDirectory, mavenBinaryFilename);
        try {
            mavenBinaryValid = mavenBinaryFile.exists() && mavenBinaryFile.canExecute();
        }
        catch (SecurityException e) {
            this.logWarning("There was a problem trying to validate the Maven binary file", e);
            mavenBinaryValid = false;
        }
        return mavenBinaryValid;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static MavenUIPlugin getDefault() {
        return plugin;
    }

    public void logError(String message, Throwable e) {
        this.getLog().log((IStatus)new Status(4, PLUGIN_ID, message, e));
    }

    public void logError(String message) {
        this.getLog().log((IStatus)new Status(4, PLUGIN_ID, message));
    }

    public MavenPreferences getPreferences() {
        return this.mavenPreferences;
    }

    public MavenPluginExecutionRules getExecutionRules() {
        return MavenPluginExecutionRules.INSTANCE;
    }

    public void warnUserMavenNotFound(final boolean userIsInPreferencePage, String location) {
        Display display = Display.getCurrent() != null ? Display.getCurrent() : Display.getDefault();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        final Shell shell = window != null ? window.getShell() : null;
        final IPreferenceStore preferenceStore = this.getPreferenceStore();
        final String message = this.getNoInstallationFoundMessage(userIsInPreferencePage, location);
        boolean dontWarnAgain = this.getPreferences().isDontWarnAgainIfNoInstallationFoundChecked();
        if (userIsInPreferencePage || !dontWarnAgain) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (userIsInPreferencePage) {
                        MessageDialog.openWarning((Shell)shell, (String)MavenUIPlugin.DIALOG_DEFAULT_TITLE, (String)message);
                    } else {
                        MessageDialogWithToggle dialogWithToggle = MessageDialogWithToggle.openWarning((Shell)shell, (String)MavenUIPlugin.DIALOG_DEFAULT_TITLE, (String)message, (String)"Do not warn me again", (boolean)false, (IPreferenceStore)preferenceStore, null);
                        preferenceStore.setValue("mule_core_plugin_preference_dont_warn_no_installation_found", dialogWithToggle.getToggleState());
                    }
                }
            });
        }
    }

    private String getNoInstallationFoundMessage(boolean userIsInPreferencePage, String location) {
        StringBuilder messageBuilder = new StringBuilder();
        if (location == null || location.equals(null) || location.trim().isEmpty()) {
            messageBuilder.append("No Maven installation specified. ");
        } else {
            messageBuilder.append("No Maven installation was found at the specified location (" + location + "). ");
        }
        if (!userIsInPreferencePage) {
            messageBuilder.append("Go to Preferences -> Anypoint Studio -> Maven Settings to correct this issue. ");
        }
        messageBuilder.append("Maven support has been disabled.");
        String message = messageBuilder.toString();
        return message;
    }

    public MessageConsole getGenericOutputConsole() {
        return UiUtils.getMessageConsole((String)MAVEN_OUTPUT_CONSOLE_NAME);
    }

    public void logWarning(String message) {
        this.getLog().log((IStatus)new Status(2, PLUGIN_ID, message));
    }

    public void logWarning(String message, Throwable e) {
        this.getLog().log((IStatus)new Status(2, PLUGIN_ID, message, e));
    }
}

