/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui;

import java.io.File;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.core.auth.AuthUser;
import org.mule.tooling.core.auth.Organization;
import org.mule.tooling.core.auth.PlatformUrls;
import org.mule.tooling.core.m2.ProjectType;
import org.mule.tooling.exchange.ExchangeAsset;
import org.mule.tooling.maven.MavenMuleProjectDecorator;
import org.mule.tooling.maven.exchange.service.ExchangeClient;
import org.mule.tooling.maven.exchange.service.error.ExchangeUnauthorizedException;
import org.mule.tooling.maven.exchange.service.error.UnrecognizedExchangeProjectTypeException;
import org.mule.tooling.maven.ui.ExchangeSearcher;
import org.mule.tooling.maven.utils.MavenUtils;
import org.mule.tooling.ui.utils.GrayedTooltipTextListener;
import org.mule.tooling.ui.widgets.util.FormLayoutUtils;
import org.mule.tooling.utils.Pair;

public class MavenInfoComponent {
    public static final String SNAPSHOTS_NOT_SUPPORTED_ERROR = "SNAPSHOTS are not supported in Studio";
    private static final String PROJECT_TYPE = "Project type:";
    private static final String VERSION = "Version:";
    private static final String ARTIFACT_ID = "Artifact Id:";
    private static final String GROUP_ID = "Group Id:";
    private static final String NAME = "Name:";
    private static final String DESCRIPTION = "Description:";
    private static final String PROJECT_INFORMATION = "Project Information:";
    private MavenMuleProjectDecorator mavenMuleProject;
    private Text groupIdText;
    private Text artifactIdText;
    private Text versionText;
    private Text nameText;
    private Text descriptionText;
    private ComboViewer projectTypeCombo;
    private CLabel errorImag;
    private ExchangeClient exchangeClient;
    private boolean errorByExchange = false;
    private String exchangeErrorDescription = null;
    private Composite mavenInfo;
    private CLabel versionImg;
    private Label actualVersion;
    private List<ProjectType> allowedProjectType;
    private ProjectType lastProjectType;
    private ExchangeAsset latestExchangeAsset;
    private ExchangeSearcher exchangeSearcher;

    public MavenInfoComponent(MavenMuleProjectDecorator mavenMuleProject) {
        this.mavenMuleProject = mavenMuleProject;
        this.exchangeClient = ExchangeClient.getExchangeClient();
        this.allowedProjectType = ProjectType.getAllowedProjectTypes();
        this.exchangeSearcher = new ExchangeSearcher();
    }

    public Composite createComponents(Composite parent) {
        this.mavenInfo = new Composite(parent, 0);
        this.mavenInfo.setLayout((Layout)FormLayoutUtils.formLayout());
        FormLayoutUtils.attach((Control)this.mavenInfo).left().top().right().bottom();
        Label label = new Label(this.mavenInfo, 0x1000000);
        label.setText(PROJECT_INFORMATION);
        FormLayoutUtils.attach((Control)label).left(5).top();
        Label nameLabel = new Label(this.mavenInfo, 0);
        nameLabel.setText(NAME);
        FormLayoutUtils.attach((Control)nameLabel).topFrom((Control)label, 10).left(12).right(5);
        this.nameText = new Text(this.mavenInfo, 2048);
        this.nameText.setText(this.mavenMuleProject.getName());
        this.nameText.setTextLimit(255);
        FormLayoutUtils.attach((Control)this.nameText).topFrom((Control)nameLabel, 1).left(12).right(5);
        Label descriptionLabel = new Label(this.mavenInfo, 0);
        descriptionLabel.setText(DESCRIPTION);
        FormLayoutUtils.attach((Control)descriptionLabel).topFrom((Control)this.nameText, 10).left(12).right(5);
        this.descriptionText = new Text(this.mavenInfo, 2048);
        this.descriptionText.setText(this.mavenMuleProject.getDescription());
        this.descriptionText.setTextLimit(255);
        FormLayoutUtils.attach((Control)this.descriptionText).topFrom((Control)descriptionLabel, 1).left(12).right(5);
        Label groupIdLabel = new Label(this.mavenInfo, 0);
        groupIdLabel.setText(GROUP_ID);
        FormLayoutUtils.attach((Control)groupIdLabel).topFrom((Control)this.descriptionText, 10).left(12).right(5);
        this.groupIdText = new Text(this.mavenInfo, 2048);
        this.groupIdText.setEnabled(false);
        FormLayoutUtils.attach((Control)this.groupIdText).topFrom((Control)groupIdLabel, 1).left(12).right(5);
        CLabel infoGroupIdImag = new CLabel(this.mavenInfo, 0);
        infoGroupIdImag.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
        infoGroupIdImag.setToolTipText("groupId is inherited and cannot be modified");
        FormLayoutUtils.attach((Control)infoGroupIdImag).topFrom((Control)groupIdLabel, 5).left(1).right(5);
        Label artifactLabel = new Label(this.mavenInfo, 0);
        artifactLabel.setText(ARTIFACT_ID);
        FormLayoutUtils.attach((Control)artifactLabel).topFrom((Control)this.groupIdText, 10).left(12).right(5);
        this.artifactIdText = new Text(this.mavenInfo, 2048);
        this.artifactIdText.setText(this.mavenMuleProject.getArtifactId());
        FormLayoutUtils.attach((Control)this.artifactIdText).topFrom((Control)artifactLabel, 1).left(12).right(5);
        Label versionLabel = new Label(this.mavenInfo, 0);
        versionLabel.setText(VERSION);
        FormLayoutUtils.attach((Control)versionLabel).topFrom((Control)this.artifactIdText, 10).left(12).right(5);
        this.versionText = new Text(this.mavenInfo, 2048);
        FormLayoutUtils.attach((Control)this.versionText).topFrom((Control)versionLabel, 1).left(12).right(5);
        this.actualVersion = new Label(this.mavenInfo, 0);
        this.actualVersion.setForeground(GrayedTooltipTextListener.getInactiveColor());
        FormLayoutUtils.attach((Control)this.actualVersion).topFrom((Control)this.versionText, 5).right(5);
        this.versionImg = new CLabel(this.mavenInfo, 0);
        this.updateVersionStatusComponent();
        FormLayoutUtils.attach((Control)this.versionImg).topFrom((Control)versionLabel, 5).left(1).right(5);
        Label projectType = new Label(this.mavenInfo, 0);
        projectType.setText(PROJECT_TYPE);
        FormLayoutUtils.attach((Control)projectType).topFrom((Control)this.actualVersion, 5).left(12).right(5);
        this.projectTypeCombo = new ComboViewer(this.mavenInfo);
        this.projectTypeCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.projectTypeCombo.setInput(this.allowedProjectType);
        Optional pomProjectType = this.mavenMuleProject.getProjectType();
        if (pomProjectType.isPresent() && this.allowedProjectType.contains(pomProjectType.get())) {
            this.projectTypeCombo.setSelection((ISelection)new StructuredSelection(pomProjectType.get()));
        } else {
            this.projectTypeCombo.setSelection((ISelection)new StructuredSelection((Object)ProjectType.EMPTY_SELECTION));
        }
        FormLayoutUtils.attach((Control)this.projectTypeCombo.getControl()).topFrom((Control)projectType, 1).left(12).right(5);
        this.errorImag = new CLabel(this.mavenInfo, 0);
        this.validateSelectedProjectType();
        FormLayoutUtils.attach((Control)this.errorImag).topFrom((Control)projectType, 5).left(1).right(5);
        return this.mavenInfo;
    }

    private void updateAssetData(String groupID) {
        this.latestExchangeAsset = this.exchangeSearcher.getLastVersionExchangeAsset(groupID, this.getArtifactId().getText());
        Pair<String, String> assetVersions = this.exchangeSearcher.getAssetVersions(this.latestExchangeAsset);
        String suggestedVersion = (String)assetVersions.getLeft();
        String lastDeployedVersion = (String)assetVersions.getRight();
        this.versionText.setText(suggestedVersion != null ? suggestedVersion : MavenUtils.formatToValidVersion((String)this.mavenMuleProject.getVersion()));
        if (this.latestExchangeAsset != null) {
            this.actualVersion.setText("Last deployed version: " + lastDeployedVersion);
            this.nameText.setText(this.latestExchangeAsset.getName());
            this.nameText.setEnabled(false);
            this.descriptionText.setText(this.latestExchangeAsset.getDescription());
            this.descriptionText.setEnabled(false);
            this.artifactIdText.setEnabled(false);
            this.lastProjectType = ProjectType.from((String)this.latestExchangeAsset.getType().toUpperCase());
            if (this.lastProjectType.isUnrecognized()) {
                throw new UnrecognizedExchangeProjectTypeException(this.latestExchangeAsset.getType().toUpperCase());
            }
            this.projectTypeCombo.setSelection((ISelection)new StructuredSelection((Object)this.lastProjectType));
            this.projectTypeCombo.getControl().setEnabled(false);
        } else {
            this.actualVersion.setText("");
        }
        this.mavenInfo.layout();
    }

    private void updateVersionStatusComponent() {
        if (this.isSnapshotVersion()) {
            this.setErrorSnapshotVersionIcon();
        } else {
            this.setInfoVersionIcon();
        }
    }

    public void setInfoVersionIcon() {
        this.versionImg.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
        this.versionImg.setToolTipText("Assets cannot be rewritten or modified once published");
    }

    public void setErrorSnapshotVersionIcon() {
        this.versionImg.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
        this.versionImg.setToolTipText(SNAPSHOTS_NOT_SUPPORTED_ERROR);
    }

    public boolean isSnapshotVersion() {
        return StringUtils.endsWith((String)this.versionText.getText(), (String)"-SNAPSHOT");
    }

    public void saveChanges() {
        this.mavenMuleProject.setArtifactId(this.artifactIdText.getText());
        this.mavenMuleProject.setGroupId(this.groupIdText.getText());
        this.mavenMuleProject.setVersion(this.versionText.getText());
        this.mavenMuleProject.setName(this.nameText.getText());
        this.mavenMuleProject.setDescription(this.descriptionText.getText());
        this.mavenMuleProject.setProjectType((ProjectType)this.projectTypeCombo.getStructuredSelection().getFirstElement());
    }

    public boolean hasEmptyFields() {
        return this.artifactIdText.getText().isEmpty() || this.versionText.getText().isEmpty() || this.nameText.getText().isEmpty();
    }

    public boolean hasProjectTypeSelected() {
        ProjectType firstElement = (ProjectType)this.projectTypeCombo.getStructuredSelection().getFirstElement();
        return !ProjectType.EMPTY_SELECTION.equals((Object)firstElement);
    }

    public void validateSelectedProjectType() {
        if (this.hasProjectTypeSelected()) {
            this.errorImag.setImage(null);
        } else {
            this.errorImag.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
        }
    }

    public boolean isValidArtifactId() {
        return this.artifactIdText.getText().contains(" ");
    }

    public boolean isValidSemVersion() {
        return MavenUtils.isValidSemanticVersion((String)this.versionText.getText());
    }

    public boolean isSelectedProjectTypeDifferentAsInExchange() {
        return this.lastProjectType != null && this.lastProjectType != (ProjectType)this.projectTypeCombo.getStructuredSelection().getFirstElement();
    }

    public boolean hasExchangeError() {
        return this.errorByExchange;
    }

    public String getExchangeErrorDescription() {
        return this.exchangeErrorDescription;
    }

    public void updateGroupIdByExchange(Organization selectedOrganization, AuthUser activeUser) {
        this.setGroupId("");
        if (selectedOrganization != null) {
            if (activeUser != null && PlatformUrls.getActivePlatformUrl().equals(activeUser.getBaseUrl())) {
                try {
                    String groupID = this.exchangeClient.getGroupID(activeUser, selectedOrganization.getId());
                    this.setGroupId(groupID);
                    this.updateExchangeServiceError(false, null);
                    this.updateAssetData(groupID);
                }
                catch (ExchangeUnauthorizedException exchangeUnauthorizedException) {
                    this.updateExchangeServiceError(true, "Not Authorized. You currently don't have access to this feature.");
                }
                catch (UnrecognizedExchangeProjectTypeException e) {
                    this.updateExchangeServiceError(true, e.getMessage());
                }
                catch (Exception exception) {
                    this.updateExchangeServiceError(true, "There was a problem connecting to Exchange.");
                }
            }
        } else {
            this.updateExchangeServiceError(true, "Not Authorized. You currently don't have access to this feature.");
        }
    }

    public boolean existInExchange() {
        return this.exchangeSearcher.existInExchange(this.getGroupId().getText(), this.getArtifactId().getText(), this.getVersion().getText());
    }

    private void updateExchangeServiceError(boolean error, String description) {
        this.errorByExchange = error;
        this.exchangeErrorDescription = description;
    }

    public Optional<File> getDeployableFile() {
        return Optional.ofNullable(this.mavenMuleProject.getPomFile());
    }

    private void setGroupId(String groupId) {
        this.groupIdText.setText(groupId);
    }

    public Text getArtifactId() {
        return this.artifactIdText;
    }

    public Text getGroupId() {
        return this.groupIdText;
    }

    public Text getVersion() {
        return this.versionText;
    }

    public Text getName() {
        return this.nameText;
    }

    public ComboViewer getProjectTypeCombo() {
        return this.projectTypeCombo;
    }

    public void setCombo(ComboViewer combo) {
        this.projectTypeCombo = combo;
    }

    public ExchangeAsset getLatestExchangeAsset() {
        return this.latestExchangeAsset;
    }
}

