/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.mule.tooling.maven.ui.MavenUIPlugin;
import org.osgi.framework.Bundle;

public class MavenImages {
    private static ImageRegistry registry = new ImageRegistry();
    private static final IPath ICONS_PATH = new Path("icons");
    public static final ImageDescriptor DESC_RUN_MVN = MavenImages.getManaged("", "RunAsMuleWithMaven-16x16.png");
    public static final Image OK_IMAGE = MavenImages.getManagedImage("", "Ok-Create-16x16.png");
    public static final Image NOT_OK_IMAGE = MavenImages.getManagedImage("", "NotOk-Delete-16x16.png");
    public static final Image BUSY = MavenImages.getManagedImage("", "Busy.gif");
    public static final Image FIND = MavenImages.getManagedImage("", "find_obj.gif");
    public static final Image EDIT = MavenImages.getManagedImage("", "write_obj.gif");

    public static ImageDescriptor getManaged(String prefix, String path) {
        IPath relPath = ICONS_PATH.append(prefix).append(path);
        ImageDescriptor desc = registry.getDescriptor(relPath.toString());
        if (desc == null) {
            desc = MavenImages.create(relPath);
            registry.put(relPath.toString(), desc);
        }
        return desc;
    }

    public static Image getManagedImage(String prefix, String path) {
        IPath relPath = ICONS_PATH.append(prefix).append(path);
        Image image = registry.get(relPath.toString());
        if (image == null) {
            ImageDescriptor desc = MavenImages.getManaged(prefix, path);
            image = desc.createImage();
        }
        return image;
    }

    public static ImageDescriptor create(IPath path) {
        return MavenImages.createImageDescriptor(MavenUIPlugin.getDefault().getBundle(), path, true);
    }

    public static ImageDescriptor createImageDescriptor(Bundle bundle, IPath path, boolean useMissingImageDescriptor) {
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        if (useMissingImageDescriptor) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return null;
    }
}

