/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui;

import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.maven.ui.MavenCommandLineConfigurationComponent;
import org.mule.tooling.maven.ui.MavenUIPlugin;
import org.mule.tooling.runtime.controller.MuleControllerHelper;
import org.mule.tooling.ui.launchConfiguration.extensible.LaunchConfigPartExtension;
import org.mule.tooling.ui.wizards.extensible.PartStatusHandler;
import org.mule.tooling.ui.wizards.extensible.WizardPagePartExtension;

public class MavenCommandLineLaunchConfigPart
implements LaunchConfigPartExtension {
    private MavenCommandLineConfigurationComponent configurationComponent;
    private IPropertyChangeListener propertyChangeListener;
    private String commandLineArguments;
    private boolean updateSnapshots;

    public Control createControl(Composite parent) {
        this.configurationComponent = new MavenCommandLineConfigurationComponent(MavenUIPlugin.getDefault().getPreferences().getBaseCommandline());
        this.configurationComponent.setStatusHandler(new PartStatusHandler(){

            public void setPartComplete(WizardPagePartExtension part, boolean isComplete) {
            }

            public void setErrorMessage(WizardPagePartExtension part, String message) {
            }

            public void clearErrors(WizardPagePartExtension part) {
            }

            public void notifyUpdate(WizardPagePartExtension part, String key, Object value) {
                if ("key.mvn.command.line".equals(key)) {
                    MavenCommandLineLaunchConfigPart.this.onCommandLineUpdated((String)value);
                } else if ("key.mvn.update.snapshots".equals(key)) {
                    MavenCommandLineLaunchConfigPart.this.onUpdateSnapshotsUpdated((Boolean)value);
                }
            }
        });
        Control control = this.configurationComponent.createControl(parent);
        return control;
    }

    private void onUpdateSnapshotsUpdated(Boolean value) {
        boolean oldUpdateSnapshots = this.updateSnapshots;
        this.updateSnapshots = value;
        this.propertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "maven.snapshot.updates", (Object)oldUpdateSnapshots, (Object)this.updateSnapshots));
    }

    private void onCommandLineUpdated(String value) {
        String oldCommandLineArguments = this.commandLineArguments;
        this.commandLineArguments = value;
        this.propertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "maven.command.line", (Object)oldCommandLineArguments, (Object)this.commandLineArguments));
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        String attribute = "";
        try {
            attribute = configuration.getAttribute("maven.command.line", "");
        }
        catch (CoreException e) {
            MuleCorePlugin.logError((String)"There was a problem reading the launch configuration for the maven commandline", (Throwable)e);
        }
        this.setInitialVMArgumentsIfNecessary(configuration);
        this.commandLineArguments = attribute;
        this.configurationComponent.setCommandLineArguments(attribute);
        boolean updateSnapshots = false;
        try {
            updateSnapshots = configuration.getAttribute("maven.snapshot.updates", false);
        }
        catch (CoreException e) {
            MuleCorePlugin.logError((String)"There was a problem reading the launch configuration for the maven update snapshots", (Throwable)e);
        }
        this.updateSnapshots = updateSnapshots;
        this.configurationComponent.setUpdateSnapshots(updateSnapshots);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("maven.command.line", this.commandLineArguments);
        configuration.setAttribute("maven.snapshot.updates", this.updateSnapshots);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("maven.command.line", "");
        configuration.setAttribute("maven.snapshot.updates", false);
    }

    public void setPropertyChangeListener(IPropertyChangeListener propertyChangeListener) {
        this.propertyChangeListener = propertyChangeListener;
    }

    public void dispose() {
    }

    public void runPreLaunchConfigActions(ILaunchConfiguration configuration) {
    }

    public void runPostLaunchConfigActions(ILaunchConfiguration configuration) {
    }

    private void setInitialVMArgumentsIfNecessary(ILaunchConfiguration configuration) {
        if (this.shouldSetVMArgs(configuration)) {
            String vmArgs = MuleControllerHelper.getInitialVMArguments().stream().collect(Collectors.joining(" "));
            ((ILaunchConfigurationWorkingCopy)configuration).setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, vmArgs);
        }
    }

    private boolean shouldSetVMArgs(ILaunchConfiguration configuration) {
        boolean shouldSetArgs = false;
        try {
            shouldSetArgs = configuration.getType().getIdentifier().equals("org.mule.tooling.runtime.muleServerLaunchType") && configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "").isBlank();
        }
        catch (CoreException e) {
            MuleCorePlugin.logError((String)"There was a problem retrieving the Run Configuration VM arguments", (Throwable)e);
        }
        return shouldSetArgs;
    }
}

