/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.maven.ui.MavenUIPlugin;
import org.mule.tooling.ui.utils.UiUtils;
import org.mule.tooling.ui.wizards.extensible.PartStatusHandler;
import org.mule.tooling.ui.wizards.extensible.WizardContext;
import org.mule.tooling.ui.wizards.extensible.WizardPagePartExtension;

public class MavenCommandLineConfigurationComponent
implements WizardPagePartExtension {
    private static final String SNAPSHOT_UPDATES_ARG = "-U";
    private static final String NOT_SNAPSHOT_UPDATES_ARG = "-nsu";
    private static final String TOOLTIP_TEXT = "<enter command line configuration parameters>";
    private String baseCommandLine;
    public static final String KEY_MVN_COMMAND_LINE = "key.mvn.command.line";
    public static final String KEY_MVN_UPDATE_SNAPSHOTS = "key.mvn.update.snapshots";
    private Text commandLineText;
    @WizardContext
    private PartStatusHandler statusHandler;
    @WizardContext
    private String commandLineArguments;
    @WizardContext
    private boolean updateSnapshots;
    private Label effectiveCommand;
    private Button updateSnapshotsCheck;

    public MavenCommandLineConfigurationComponent() {
        this(MavenUIPlugin.getDefault().getPreferences().getBaseCommandline());
    }

    public MavenCommandLineConfigurationComponent(String baseCommandLine) {
        this.baseCommandLine = baseCommandLine;
    }

    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        Group group = UiUtils.createGroupWithTitle((Composite)composite, (String)"Maven command line arguments", (int)2);
        this.commandLineText = new Text((Composite)group, 2048);
        if (this.baseCommandLine != null && this.baseCommandLine.contains(NOT_SNAPSHOT_UPDATES_ARG)) {
            this.updateSnapshotsCheck = new Button((Composite)group, 32);
            this.updateSnapshotsCheck.setText("Force check for updated releases and snapshots on remote repositories");
            this.updateSnapshotsCheck.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                boolean update = this.updateSnapshotsCheck.getSelection();
                this.onUpdateSnapshotsModified(update);
                this.statusHandler.notifyUpdate((WizardPagePartExtension)this, KEY_MVN_UPDATE_SNAPSHOTS, (Object)update);
            }));
            GridDataFactory.swtDefaults().align(4, 1).grab(true, false).span(2, 1).applyTo((Control)this.updateSnapshotsCheck);
        }
        if (this.baseCommandLine != null) {
            this.createEffectiveCommandlineText(group);
        }
        UiUtils.addGrayedTooltipWhenEmpty((Text)this.commandLineText, (String)TOOLTIP_TEXT);
        this.commandLineText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MavenCommandLineConfigurationComponent.this.updateCommandLine();
            }
        });
        GridDataFactory.swtDefaults().align(4, 1).grab(true, false).span(2, 1).applyTo((Control)this.commandLineText);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)group);
        Point point = new Point(LayoutConstants.getSpacing().x, LayoutConstants.getSpacing().y * 3 / 2);
        GridLayoutFactory.swtDefaults().numColumns(2).spacing(point).applyTo((Composite)group);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo(composite);
        GridDataFactory.fillDefaults().applyTo((Control)composite);
        return composite;
    }

    private void onUpdateSnapshotsModified(boolean update) {
        this.baseCommandLine = update ? this.baseCommandLine.replaceAll(NOT_SNAPSHOT_UPDATES_ARG, SNAPSHOT_UPDATES_ARG) : this.baseCommandLine.replaceAll(SNAPSHOT_UPDATES_ARG, NOT_SNAPSHOT_UPDATES_ARG);
        this.updateCommandLine();
    }

    private void updateCommandLine() {
        String text = this.commandLineText.getText();
        this.onCommandLineModified(text);
    }

    private void createEffectiveCommandlineText(Group group) {
        Label effectiveCommandLabel = new Label((Composite)group, 0);
        effectiveCommandLabel.setText("Command:");
        this.effectiveCommand = new Label((Composite)group, 0);
        this.effectiveCommand.setText(this.baseCommandLine);
    }

    protected void onCommandLineModified(String arguments) {
        String newCommandLineArguments = arguments;
        this.commandLineArguments = newCommandLineArguments.equals(TOOLTIP_TEXT) ? "" : newCommandLineArguments;
        this.effectiveCommand.setText(MessageFormat.format("{0} {1}", this.baseCommandLine, this.commandLineArguments));
        this.statusHandler.notifyUpdate((WizardPagePartExtension)this, KEY_MVN_COMMAND_LINE, (Object)this.commandLineArguments);
    }

    public PartStatusHandler getStatusHandler() {
        return this.statusHandler;
    }

    public void setStatusHandler(PartStatusHandler statusHandler) {
        this.statusHandler = statusHandler;
    }

    public String getCommandLineArguments() {
        return this.commandLineArguments;
    }

    public void setCommandLineArguments(String commandLineArguments) {
        this.commandLineArguments = commandLineArguments;
        this.commandLineText.setText(commandLineArguments);
    }

    public void setUpdateSnapshots(boolean updateSnapshots) {
        this.updateSnapshots = updateSnapshots;
        if (this.updateSnapshotsCheck != null) {
            this.updateSnapshotsCheck.setSelection(updateSnapshots);
        }
        this.onUpdateSnapshotsModified(updateSnapshots);
    }

    public void initializeDefaults() {
    }

    public void performFinish(IProgressMonitor monitor) {
    }
}

