/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.JavaRuntime;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.api.extension.model.ExtensionModel;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.io.EditingScope;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.tooling.ToolingClientHelper;
import org.mule.tooling.core.utils.ExtensionModelLoadException;
import org.mule.tooling.core.utils.ExtensionModelLoaderUtils;
import org.mule.tooling.core.utils.Tuple;
import org.mule.tooling.maven.ui.JreUpdateConnectorDialog;
import org.mule.tooling.maven.ui.dependency.MuleModuleToUpdate;
import org.mule.tooling.maven.ui.properties.ModuleDependency;
import org.mule.tooling.ui.properties.IDependency;
import org.mule.tooling.ui.properties.dependencies.DependencyUtils;

public class JreUpdateConnectorEvent
implements IElementChangedListener {
    private Map<IJavaProject, IClasspathEntry[]> projectClasspathMap;

    public JreUpdateConnectorEvent() {
        this.projectClasspathMap = new HashMap<IJavaProject, IClasspathEntry[]>();
    }

    public JreUpdateConnectorEvent(Map<IJavaProject, IClasspathEntry[]> projectClasspathMap) {
        this.projectClasspathMap = projectClasspathMap;
    }

    public void elementChanged(ElementChangedEvent event) {
        IJavaElementDelta delta = event.getDelta();
        try {
            this.processDelta(delta);
        }
        catch (JavaModelException e) {
            MuleCorePlugin.logError((String)("There was an error while processing a Java event: \n" + delta.toString()), (Throwable)e);
        }
    }

    private void processDelta(IJavaElementDelta delta) throws JavaModelException {
        if (this.hasFlag(delta, 2228672)) {
            IJavaProject project;
            List<MuleModuleToUpdate> extensions;
            IJavaElement changedElement = delta.getElement();
            if (changedElement.getJavaProject() instanceof IJavaProject && !(extensions = this.getConnectorsToUpdate(project = changedElement.getJavaProject())).isEmpty()) {
                JreUpdateConnectorDialog.open(extensions, project);
            }
        } else if (this.hasFlag(delta, 8)) {
            this.processChildren(delta);
        }
    }

    private void processChildren(IJavaElementDelta delta) throws JavaModelException {
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta childDelta = iJavaElementDeltaArray[n2];
            this.processDelta(childDelta);
            ++n2;
        }
    }

    private boolean hasFlag(IJavaElementDelta delta, int flag) {
        return (delta.getFlags() & flag) != 0;
    }

    public List<MuleModuleToUpdate> getConnectorsToUpdate(IJavaProject javaProject) {
        List<MuleModuleToUpdate> extensions = new ArrayList<MuleModuleToUpdate>();
        try {
            if (javaProject != null) {
                Optional<IClasspathEntry> newJreEntry;
                Optional<IClasspathEntry> oldJreEntry;
                IClasspathEntry[] classpathEntries = javaProject.getRawClasspath();
                if (this.classpathEntriesChanged(this.projectClasspathMap.get(javaProject), classpathEntries) && !Objects.equals(oldJreEntry = this.findJreEntry(this.projectClasspathMap.get(javaProject)), newJreEntry = this.findJreEntry(classpathEntries))) {
                    extensions = this.getIncompatibleExtensions(javaProject);
                }
                this.projectClasspathMap.put(javaProject, classpathEntries);
            }
        }
        catch (JavaModelException e) {
            MuleCorePlugin.logError((String)"There was a problem obtaining the extension in the project from delta", (Throwable)e);
        }
        return extensions;
    }

    public List<MuleModuleToUpdate> getIncompatibleExtensions(IJavaProject javaProject) {
        ArrayList<MuleModuleToUpdate> modulesToUpdate = new ArrayList<MuleModuleToUpdate>();
        IMuleProject muleProject = MuleRuntime.create((IProject)javaProject.getProject());
        List externalModules = muleProject.getModuleManager(EditingScope.TEST).getExternalModules();
        List dependencies = externalModules.stream().map(module -> new ModuleDependency((ExternalContributionMuleModule)module, DependencyUtils.getOriginalScope((IMuleProject)muleProject, (ExternalContributionMuleModule)module))).collect(Collectors.toList());
        for (IDependency extension : dependencies) {
            if (this.isExtensionCompatibleWithJre(muleProject, extension.getDependency())) continue;
            modulesToUpdate.add(new MuleModuleToUpdate(extension, MuleRuntime.create((IProject)javaProject.getProject())));
        }
        return modulesToUpdate;
    }

    public boolean isExtensionCompatibleWithJre(IMuleProject muleProject, MavenDependency mavenDependency) {
        try {
            ToolingRuntimeClient client = ToolingClientHelper.getInstance().getOrCreateToolingRuntimeClientFor(muleProject.getServerDefinition().getVersion());
            IVMInstall vm = JavaRuntime.getVMInstall((IJavaProject)muleProject.getJavaProject());
            String jreVersionProject = JavaModelUtil.getCompilerCompliance((IVMInstall2)((IVMInstall2)vm), null);
            Tuple pair = ExtensionModelLoaderUtils.loadExtensionModel((MavenDependency)mavenDependency, (ToolingRuntimeClient)client);
            if (pair != null) {
                Set compatibleversions = ((ExtensionModel)((Tuple)pair.second()).first()).getSupportedJavaVersions();
                return compatibleversions.contains(jreVersionProject);
            }
        }
        catch (CoreException | ExtensionModelLoadException e) {
            MuleCorePlugin.logError((String)"There was a problem obtaining the jre of the project", (Throwable)e);
        }
        return false;
    }

    private Optional<IClasspathEntry> findJreEntry(IClasspathEntry[] classpathEntries) {
        if (classpathEntries != null) {
            IClasspathEntry[] iClasspathEntryArray = classpathEntries;
            int n = classpathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 5 && JavaRuntime.JRE_CONTAINER.equals(entry.getPath().segment(0))) {
                    return Optional.of(entry);
                }
                ++n2;
            }
        }
        return Optional.empty();
    }

    private boolean classpathEntriesChanged(IClasspathEntry[] oldEntries, IClasspathEntry[] newEntries) {
        return oldEntries != null && !Arrays.equals(oldEntries, newEntries);
    }
}

