/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.api.extension.model.ExtensionModel;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.tooling.ToolingClientHelper;
import org.mule.tooling.core.utils.ExtensionModelLoadException;
import org.mule.tooling.core.utils.ExtensionModelLoaderUtils;
import org.mule.tooling.core.utils.Tuple;
import org.mule.tooling.core.utils.VMUtils;
import org.mule.tooling.maven.ui.MuleModulesUpdateDialog;
import org.mule.tooling.maven.ui.dependency.MuleModuleToUpdate;

public class JreUpdateConnectorDialog
extends Dialog {
    private static final String DIALOG_TITLE = "Plugins Information";
    private static final String LABEL_CANCEL = "Cancel";
    private static final String LABEL_UPDATE = "Update";
    private static final String MESSAGE_RECOMMEND_USING_CAMPATIBLE_VERSION = "We strongly recommend using campatible version of connector, or the application will not compile.\n Are you sure you want to cancel?";
    private static final String TITLE_ANYPOINT_STUDIO = "Anypoint Studio";
    private List<MuleModuleToUpdate> plugins;
    private IJavaProject project;

    protected JreUpdateConnectorDialog(Shell parentShell, List<MuleModuleToUpdate> plugins, IJavaProject project) {
        super(parentShell);
        this.plugins = plugins;
        this.project = project;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setMinimumSize(800, 500);
        this.getShell().setText(DIALOG_TITLE);
        TableViewer tableViewer = new TableViewer(parent, 68100);
        tableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        tableViewer.setComparator(new ViewerComparator());
        tableViewer.getTable().setHeaderVisible(true);
        tableViewer.getTable().setLinesVisible(true);
        this.createTableColumn(tableViewer, "Connector", 200, new PluginLabelProvider());
        this.createTableColumn(tableViewer, "Version", 100, new VersionLabelProvider());
        this.createTableColumn(tableViewer, "Compatibility", 500, new CompatibilityLabelProvider(this.project));
        tableViewer.setInput(this.plugins);
        return parent;
    }

    protected boolean isResizable() {
        return true;
    }

    private void createTableColumn(TableViewer viewer, String title, int width, ColumnLabelProvider labelProvider) {
        TableViewerColumn column = new TableViewerColumn(viewer, 0);
        column.getColumn().setText(title);
        column.getColumn().setWidth(width);
        column.setLabelProvider((CellLabelProvider)labelProvider);
    }

    public static void open(List<MuleModuleToUpdate> libraries, IJavaProject project) {
        if (Boolean.getBoolean("studio.test")) {
            return;
        }
        Display.getDefault().asyncExec(() -> {
            Shell shell = Display.getDefault().getActiveShell();
            JreUpdateConnectorDialog dialog = new JreUpdateConnectorDialog(shell, libraries, project);
            dialog.open();
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, LABEL_UPDATE, true).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JreUpdateConnectorDialog.this.handleOkButton();
            }
        });
        this.createButton(parent, 1, LABEL_CANCEL, false);
    }

    private void handleOkButton() {
        this.close();
        new MuleModulesUpdateDialog(this.getShell(), this.plugins, false).open();
    }

    protected void cancelPressed() {
        boolean confirmed = MessageDialog.openConfirm((Shell)this.getShell(), (String)TITLE_ANYPOINT_STUDIO, (String)MESSAGE_RECOMMEND_USING_CAMPATIBLE_VERSION);
        if (confirmed) {
            super.cancelPressed();
        }
    }

    private static class CompatibilityLabelProvider
    extends ColumnLabelProvider {
        private IMuleProject muleProject;
        private ToolingRuntimeClient client;
        private Optional<String> jreVersionProject;

        public CompatibilityLabelProvider(IJavaProject project) {
            this.muleProject = MuleRuntime.create((IProject)project.getProject());
            this.client = ToolingClientHelper.getInstance().getOrCreateToolingRuntimeClientFor(this.muleProject.getServerDefinition().getVersion());
            this.jreVersionProject = VMUtils.getJreVersion((IJavaProject)this.muleProject.getJavaProject());
        }

        public String getText(Object element) {
            if (element instanceof MuleModuleToUpdate) {
                MuleModuleToUpdate muleModuleToUpdate = (MuleModuleToUpdate)element;
                return this.getCompatibilityMessage(muleModuleToUpdate);
            }
            return super.getText(element);
        }

        private String getCompatibilityMessage(MuleModuleToUpdate element) {
            try {
                Tuple pair = ExtensionModelLoaderUtils.loadExtensionModel((MavenDependency)element.getMuleModule().getDependency(), (ToolingRuntimeClient)this.client);
                if (pair != null) {
                    Set compatibleversions = ((ExtensionModel)((Tuple)pair.second()).first()).getSupportedJavaVersions();
                    return compatibleversions.contains(this.jreVersionProject) ? "Compatible" : "Update " + element.getMuleModule().getArtifactId() + " to be compatible with Java " + String.valueOf(this.jreVersionProject);
                }
            }
            catch (ExtensionModelLoadException e) {
                MuleCorePlugin.logError((String)"There was a problem obtaining the extension model", (Throwable)e);
            }
            return null;
        }
    }

    private static class PluginLabelProvider
    extends ColumnLabelProvider {
        private PluginLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof MuleModuleToUpdate) {
                return ((MuleModuleToUpdate)element).getMuleModule().getArtifactId();
            }
            return super.getText(element);
        }
    }

    private static class VersionLabelProvider
    extends ColumnLabelProvider {
        private VersionLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof MuleModuleToUpdate) {
                return ((MuleModuleToUpdate)element).getMuleModule().getVersion();
            }
            return super.getText(element);
        }
    }
}

