/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui;

import java.io.File;
import java.io.FileNotFoundException;
import org.mule.tooling.core.m2.internal.MavenCore;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.runtime.server.ServerMatcher;
import org.mule.tooling.maven.ui.MavenUIPlugin;

public class IsRepoPopulatedRule {
    public boolean isPopulatedFor(IServerDefinition serverDefinition) {
        String m2repo = MavenCore.getM2repoPath();
        File m2repoFile = new File(m2repo);
        if (!m2repoFile.exists()) {
            MavenUIPlugin.getDefault().logError("Can't determine if M2 repo is populated", new FileNotFoundException("m2 repo can't be found"));
            return false;
        }
        return this.artifactExists(m2repoFile, "com/mulesoft/muleesb", "mule-core-ee", serverDefinition.getVersionWithSuffix()) && !ServerMatcher.fromString((String)"[3.3,3.8)").matches(serverDefinition);
    }

    private boolean artifactExists(File m2repoFile, String pathLikeGroupId, String artifactId, String version) {
        String pathToAnArtifactThatWouldBeInstalled = pathLikeGroupId + File.separator + artifactId + File.separator + version + File.separator + artifactId + "-" + version + ".jar";
        return new File(m2repoFile, pathToAnArtifactThatWouldBeInstalled).exists();
    }
}

