/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui;

import com.github.zafarkhaja.semver.Version;
import java.util.List;
import java.util.Optional;
import org.mule.tooling.core.auth.AuthUser;
import org.mule.tooling.core.auth.PlatformUrls;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.exchange.ExchangeAsset;
import org.mule.tooling.exchange.client.ExternalServiceCallException;
import org.mule.tooling.exchange.client.GraphServiceClient;
import org.mule.tooling.exchange.client.GraphServiceQueryBuilder;
import org.mule.tooling.exchange.client.GraphServiceResponse;
import org.mule.tooling.exchange.preferences.ExchangePreferences;
import org.mule.tooling.maven.utils.MavenUtils;
import org.mule.tooling.utils.Pair;

public class ExchangeSearcher {
    private GraphServiceClient graphServiceClient = this.getGraphServiceClient();

    public ExchangeAsset getLastVersionExchangeAsset(String groupId, String artifactId) {
        ExchangeAsset exchangeAsset = null;
        try {
            GraphServiceQueryBuilder queryBuilder = GraphServiceQueryBuilder.create().withCoordinates(groupId, artifactId).includeSnapshots(ExchangePreferences.includeSnapshots()).withAssetTypes(new GraphServiceClient.AssetType[]{GraphServiceClient.AssetType.EXTENSION, GraphServiceClient.AssetType.REST_API}).build();
            GraphServiceResponse searchResult = this.graphServiceClient.search(queryBuilder, Optional.empty());
            List exchangeResult = searchResult.getElements();
            if (!exchangeResult.isEmpty()) {
                exchangeAsset = (ExchangeAsset)exchangeResult.get(0);
            }
        }
        catch (ExternalServiceCallException e) {
            e.printStackTrace();
        }
        return exchangeAsset;
    }

    public boolean existInExchange(String groupId, String artifactId, String version) {
        try {
            GraphServiceQueryBuilder queryBuilder = GraphServiceQueryBuilder.create().withCoordinates(groupId, artifactId, version).includeSnapshots(ExchangePreferences.includeSnapshots()).withAssetTypes(new GraphServiceClient.AssetType[]{GraphServiceClient.AssetType.EXTENSION, GraphServiceClient.AssetType.REST_API}).build();
            GraphServiceResponse searchResult = this.graphServiceClient.search(queryBuilder, Optional.empty());
            List exchangeResult = searchResult.getElements();
            if (!exchangeResult.isEmpty()) {
                return true;
            }
        }
        catch (ExternalServiceCallException e) {
            e.printStackTrace();
        }
        return false;
    }

    public Pair<String, String> getAssetVersions(ExchangeAsset exchangeAsset) {
        String suggestedVersion = null;
        String lastVersion = exchangeAsset != null ? exchangeAsset.getVersion() : null;
        Version version = MavenUtils.getVersion((String)lastVersion);
        if (version != null) {
            suggestedVersion = version.incrementPatchVersion().toString();
        }
        return new Pair((Object)suggestedVersion, (Object)lastVersion);
    }

    private GraphServiceClient getGraphServiceClient() {
        return GraphServiceClient.create((String)PlatformUrls.getActiveGraphServiceUrl(), this.getAccessToken());
    }

    private Optional<String> getAccessToken() {
        AuthUser activeUser = CoreUtils.getLoginManager().retrieveActiveAuthUser();
        return Optional.ofNullable(activeUser.getToken());
    }
}

