/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.auth.AuthUser;
import org.mule.tooling.core.m2.ProjectType;
import org.mule.tooling.maven.exchange.service.ExchangeClient;
import org.mule.tooling.maven.ui.editors.DateEditor;
import org.mule.tooling.maven.ui.editors.DynamicContentEditor;
import org.mule.tooling.maven.ui.editors.MultipleValuesEditor;
import org.mule.tooling.maven.ui.editors.NumberEditor;
import org.mule.tooling.maven.ui.editors.TextEditor;
import org.mule.tooling.maven.ui.exceptions.UnsupportedDataTypeException;
import org.mule.tooling.ui.widgets.dynamic.table.DynamicContent;
import org.mule.tooling.ui.widgets.dynamic.table.DynamicContentType;
import org.mule.tooling.ui.widgets.dynamic.table.TypesManager;
import org.mule.tooling.ui.widgets.dynamic.table.TypesManagerFilter;

public class CustomFieldsTypesManager
implements TypesManager {
    private AuthUser currentUser;
    private String organizationId;
    private ProjectType projectType;
    private List<DynamicContentType> rowTypes;
    private List<DynamicContentType> selectedTypes;
    private List<ICustomFieldEditorContentChanged> listeners = new ArrayList<ICustomFieldEditorContentChanged>();

    public CustomFieldsTypesManager(AuthUser currentUser, String organizationId, ProjectType projectType) {
        this.currentUser = currentUser;
        this.organizationId = organizationId;
        this.projectType = projectType;
        this.rowTypes = new ArrayList<DynamicContentType>();
        this.selectedTypes = new ArrayList<DynamicContentType>();
    }

    public List<DynamicContentType> getTypes() {
        this.fillTypes();
        ArrayList<DynamicContentType> response = new ArrayList<DynamicContentType>();
        for (DynamicContentType type : this.rowTypes) {
            if (this.selectedTypes.contains(type)) continue;
            response.add(type);
        }
        return response;
    }

    private void fillTypes() {
        if (this.rowTypes.isEmpty()) {
            List<ExchangeClient.ExchangeCustomFieldDTO> exchangeCustomFields = this.getCustomFieldsFromExchange();
            String projectTypeName = this.projectType.name().toLowerCase();
            exchangeCustomFields.stream().filter(customFieldDTO -> customFieldDTO.acceptsAssetType(projectTypeName)).forEach(customField -> {
                Optional<DynamicContentType> content = this.createNewCustomFieldRowType((ExchangeClient.ExchangeCustomFieldDTO)customField);
                if (content.isPresent()) {
                    this.rowTypes.add(content.get());
                }
            });
        }
    }

    private Optional<DynamicContentType> createNewCustomFieldRowType(ExchangeClient.ExchangeCustomFieldDTO customField) {
        try {
            CustomFieldContentBuilder contentBuilder = new CustomFieldContentBuilder(customField.getDataType(), customField.getAcceptedValues());
            return Optional.of(new DynamicContentType(customField.getDisplayName(), customField.getTagKey(), (DynamicContentType.ParameterBuilder)contentBuilder));
        }
        catch (UnsupportedDataTypeException e) {
            MuleCorePlugin.logError((String)e.getMessage());
            return Optional.empty();
        }
    }

    private List<ExchangeClient.ExchangeCustomFieldDTO> getCustomFieldsFromExchange() {
        return ExchangeClient.getExchangeClient().getCustomFields(this.currentUser, this.organizationId);
    }

    public Optional<DynamicContentType> getType(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new IllegalArgumentException("Type Id cannot be null");
        }
        this.fillTypes();
        for (DynamicContentType type : this.rowTypes) {
            if (!type.getId().equals(id)) continue;
            return Optional.of(type);
        }
        return Optional.empty();
    }

    public void setSelectedTypes(List<DynamicContentType> types) {
        if (types == null) {
            throw new IllegalArgumentException("Selected types list cannot be null");
        }
        this.selectedTypes = types;
    }

    public void addFilter(TypesManagerFilter filter) {
    }

    public void removeFilter(TypesManagerFilter filter) {
    }

    public void addCustomFieldEditorContentChangedListener(ICustomFieldEditorContentChanged listener) {
        this.listeners.add(listener);
    }

    public void removeCustomFieldEditorContentChangedListener(ICustomFieldEditorContentChanged listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners() {
        this.listeners.forEach(ICustomFieldEditorContentChanged::update);
    }

    static /* synthetic */ void access$0(CustomFieldsTypesManager customFieldsTypesManager) {
        customFieldsTypesManager.notifyListeners();
    }

    public class CustomFieldContentBuilder
    implements DynamicContentType.ParameterBuilder {
        private List<String> acceptedValues;
        private CustomFieldTypes dataType;

        public CustomFieldContentBuilder(String dataType, List<String> acceptedValues) throws UnsupportedDataTypeException {
            this.dataType = CustomFieldTypes.get(dataType);
            this.acceptedValues = acceptedValues;
        }

        public DynamicContent create() {
            DynamicContentEditor editor = null;
            switch (this.dataType) {
                case ENUM: {
                    editor = new MultipleValuesEditor(this.acceptedValues);
                    break;
                }
                case TEXT: {
                    editor = new TextEditor();
                    break;
                }
                case NUMBER: {
                    editor = new NumberEditor();
                    break;
                }
                case NUMBER_LIST: {
                    editor = new MultipleValuesEditor(Pattern.compile("-?[0-9]{0,10}"), Pattern.compile("-[1-9]|-?[1-9]\\d{1,9}|\\d"), "custom field");
                    break;
                }
                case TEXT_LIST: {
                    editor = new MultipleValuesEditor(Pattern.compile(".*"), Pattern.compile(".+"), "custom field");
                    break;
                }
                case DATE: {
                    editor = new DateEditor();
                    break;
                }
                default: {
                    MuleCorePlugin.logWarning((String)("Unsupported data type: " + String.valueOf((Object)this.dataType)));
                }
            }
            if (editor != null) {
                ((DynamicContentEditor)editor).addValuesModifiedListener(() -> CustomFieldsTypesManager.access$0(CustomFieldsTypesManager.this));
            }
            return editor;
        }
    }

    static enum CustomFieldTypes {
        DATE("date"),
        ENUM("enum"),
        NUMBER("number"),
        NUMBER_LIST("number-list"),
        TEXT("text"),
        TEXT_LIST("text-list");

        private final String dataType;

        private CustomFieldTypes(String dataType) {
            this.dataType = dataType;
        }

        public static CustomFieldTypes get(String dataType) throws UnsupportedDataTypeException {
            Optional<CustomFieldTypes> maybeCustomField = Arrays.stream(CustomFieldTypes.values()).filter(value -> value.dataType.equals(dataType)).findFirst();
            if (maybeCustomField.isPresent()) {
                return maybeCustomField.get();
            }
            throw new UnsupportedDataTypeException(dataType);
        }
    }

    public static interface ICustomFieldEditorContentChanged {
        public void update();
    }
}

