/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.core.auth.AuthUser;
import org.mule.tooling.core.m2.ProjectType;
import org.mule.tooling.maven.exchange.service.ExchangeClient;
import org.mule.tooling.maven.ui.editors.MultipleValuesEditor;
import org.mule.tooling.ui.widgets.dynamic.table.DynamicContent;
import org.mule.tooling.ui.widgets.dynamic.table.DynamicContentType;
import org.mule.tooling.ui.widgets.dynamic.table.TypesManager;
import org.mule.tooling.ui.widgets.dynamic.table.TypesManagerFilter;

public class CategoriesTypesManager
implements TypesManager {
    private AuthUser currentUser;
    private String organizationId;
    private ProjectType projectType;
    private List<DynamicContentType> rowTypes;
    private List<DynamicContentType> selectedTypes;
    private List<ICategoryEditorContentChanged> listeners = new ArrayList<ICategoryEditorContentChanged>();

    public CategoriesTypesManager(AuthUser currentUser, String organizationId, ProjectType projectType) {
        this.currentUser = currentUser;
        this.organizationId = organizationId;
        this.projectType = projectType;
        this.rowTypes = new ArrayList<DynamicContentType>();
        this.selectedTypes = new ArrayList<DynamicContentType>();
    }

    public List<DynamicContentType> getTypes() {
        if (this.rowTypes.isEmpty()) {
            this.fillTypes();
        }
        ArrayList<DynamicContentType> response = new ArrayList<DynamicContentType>();
        for (DynamicContentType type : this.rowTypes) {
            if (this.selectedTypes.contains(type)) continue;
            response.add(type);
        }
        return response;
    }

    private void fillTypes() {
        List<ExchangeClient.ExchangeCategoryDTO> exchangeCategories = this.getOrganizationCategoriesFromExchange();
        exchangeCategories.stream().filter(p -> p.getAssetTypeRestrictions().isEmpty() || p.getAssetTypeRestrictions().contains(this.projectType.name().toLowerCase())).forEach(category -> {
            boolean bl = this.rowTypes.add(new DynamicContentType(category.getDisplayName(), category.getTagKey(), (DynamicContentType.ParameterBuilder)new CategoryContentBuilder(category.getAcceptedValues())));
        });
    }

    private List<ExchangeClient.ExchangeCategoryDTO> getOrganizationCategoriesFromExchange() {
        return ExchangeClient.getExchangeClient().getCategories(this.currentUser, this.organizationId);
    }

    public Optional<DynamicContentType> getType(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new IllegalArgumentException("Type Id cannot be null");
        }
        if (this.rowTypes.isEmpty()) {
            this.fillTypes();
        }
        for (DynamicContentType type : this.rowTypes) {
            if (!type.getId().equals(id)) continue;
            return Optional.of(type);
        }
        return Optional.empty();
    }

    public void setSelectedTypes(List<DynamicContentType> types) {
        if (types == null) {
            throw new IllegalArgumentException("Selected Types List Cannot Be Null");
        }
        this.selectedTypes = types;
    }

    public void addFilter(TypesManagerFilter filter) {
    }

    public void removeFilter(TypesManagerFilter filter) {
    }

    public void addCategoryEditorContentChangedListener(ICategoryEditorContentChanged listener) {
        this.listeners.add(listener);
    }

    public void removeCategoryEditorContentChangedListener(ICategoryEditorContentChanged listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners() {
        this.listeners.forEach(ICategoryEditorContentChanged::update);
    }

    static /* synthetic */ void access$0(CategoriesTypesManager categoriesTypesManager) {
        categoriesTypesManager.notifyListeners();
    }

    public class CategoryContentBuilder
    implements DynamicContentType.ParameterBuilder {
        private List<String> acceptedValues;

        public CategoryContentBuilder(List<String> acceptedValues) {
            this.acceptedValues = acceptedValues;
        }

        public DynamicContent create() {
            MultipleValuesEditor editor = new MultipleValuesEditor(this.acceptedValues);
            editor.addValuesModifiedListener(() -> CategoriesTypesManager.access$0(CategoriesTypesManager.this));
            return editor;
        }
    }

    public static interface ICategoryEditorContentChanged {
        public void update();
    }
}

